/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.i18n.extension.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableColumn;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.i18n.Messages;
import org.gvsig.i18n.extension.preferences.table.LocaleTableModel;
import org.gvsig.i18n.extension.preferences.table.RadioButtonCellEditor;
import org.gvsig.i18n.extension.preferences.table.RadioButtonCellRenderer;
import org.gvsig.i18n.impl.I18nManagerImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class I18nPreferencePage
extends AbstractPreferencePage {
    private static final long serialVersionUID = 7164183052397200888L;
    private final ImageIcon icon;
    private JTable localesTable;
    private LocaleTableModel tableModel;
    private JTextArea txtWarning = null;
    private JTextArea txtCollaboration = null;

    public I18nPreferencePage() {
        this.setParentID("org.gvsig.coreplugin.preferences.general.GeneralPage");
        this.icon = PluginServices.getIconTheme().get("i18n-preferences");
        this.initComponents();
    }

    private void initComponents() {
        Font hints_fnt = new JLabel().getFont();
        Component tablePanel = this.getLocalesPanel();
        this.txtWarning = this.getActiveLocaleLabel(this.getBackground(), hints_fnt.deriveFont(1));
        this.txtCollaboration = this.getCollaborationLabel(this.getBackground(), hints_fnt);
        Box.Filler fillerBorder1 = new Box.Filler(new Dimension(16, 16), new Dimension(16, 16), new Dimension(16, 16));
        Box.Filler fillerBorder2 = new Box.Filler(new Dimension(16, 16), new Dimension(16, 16), new Dimension(16, 16));
        Box.Filler fillerBottom = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 4, 0, 4, 0};
        layout.rowHeights = new int[]{0, 4, 0, 4, 0, 4, 0, 4, 0};
        this.setLayout(layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.add(this.txtWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.add(this.txtCollaboration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.3;
        this.add(tablePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add(fillerBorder1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add(fillerBorder2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        this.add(fillerBottom, gridBagConstraints);
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.txtCollaboration.setText(i18nManager.getTranslation("I18nPreferencePage.colaboraciones", new String[]{"translations@gvsig.org"}));
        this.txtWarning.setText(i18nManager.getTranslation("I18nPreferencePage.ayuda"));
    }

    public boolean isResizeable() {
        return true;
    }

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getTitle() {
        return Messages.getText((String)"idioma");
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public JPanel getPanel() {
        return this;
    }

    public void setChangesApplied() {
        if (this.tableModel == null) {
            return;
        }
        this.tableModel.setChangesApplied();
    }

    public boolean isValueChanged() {
        if (this.tableModel == null) {
            return false;
        }
        return this.tableModel.isValueChanged();
    }

    public void storeValues() throws StoreException {
        if (this.tableModel == null) {
            return;
        }
        this.tableModel.saveSelectedLocale();
    }

    public void initializeDefaults() {
        if (this.tableModel == null) {
            return;
        }
        this.tableModel.selectDefaultLocale();
    }

    public void initializeValues() {
        if (this.tableModel == null) {
            this.tableModel = new LocaleTableModel(I18nManagerImpl.getInstance());
            this.localesTable.setModel(this.tableModel);
            TableColumn activeColumn = this.localesTable.getColumnModel().getColumn(3);
            activeColumn.setCellEditor(new RadioButtonCellEditor());
            activeColumn.setCellRenderer(new RadioButtonCellRenderer());
            this.localesTable.setSelectionMode(2);
            this.localesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.tableModel.selectPreviousLocale();
        this.translate();
    }

    private Component getLocalesPanel() {
        this.localesTable = new JTable();
        JScrollPane scrollPane = new JScrollPane(this.localesTable);
        JPanel localesPanel = new JPanel();
        localesPanel.setLayout(new BoxLayout(localesPanel, 1));
        localesPanel.add(scrollPane);
        localesPanel.setAlignmentX(0.5f);
        localesPanel.setPreferredSize(new Dimension(236, 200));
        localesPanel.setMaximumSize(new Dimension(500, 230));
        return localesPanel;
    }

    private JTextArea getActiveLocaleLabel(Color bg, Font fnt) {
        JTextArea textArea = new JTextArea(Messages.getText((String)"I18nPreferencePage.ayuda"));
        textArea.setEditable(false);
        textArea.setAutoscrolls(true);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFont(fnt);
        textArea.setBackground(bg);
        return textArea;
    }

    private JTextArea getCollaborationLabel(Color bg, Font fnt) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        JTextArea textArea = new JTextArea(i18nManager.getTranslation("I18nPreferencePage.colaboraciones", new String[]{"translations@gvsig.org"}));
        textArea.setEditable(false);
        textArea.setAutoscrolls(true);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFont(fnt);
        textArea.setBackground(bg);
        return textArea;
    }
}

