/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling;

import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IZoomConstraints;
import org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend.DefaultDynamicLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend.DynamicLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.AttrInTableLabelingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelingFactory {
    private static final Logger logger = LoggerFactory.getLogger(LabelingFactory.class);
    private static Class defaultLabelingStrategy = AttrInTableLabelingStrategy.class;

    public static ILabelingStrategy createStrategy(FLayer layer, ILabelingMethod method, IPlacementConstraints placement, IZoomConstraints zoom) {
        if (method == null && placement == null && zoom == null) {
            return LabelingFactory.createDefaultStrategy(layer);
        }
        ILabelingStrategy strat = LabelingFactory.createDefaultStrategy(layer);
        if (method != null) {
            strat.setLabelingMethod(method);
        }
        if (placement != null) {
            strat.setPlacementConstraints(placement);
        }
        return strat;
    }

    public static DynamicLabelingStrategy createDynamicLabelingStrategy() {
        return new DefaultDynamicLabelingStrategy();
    }

    public static ILabelingStrategy createDefaultStrategy(FLayer layer) {
        try {
            ILabelingStrategy st = (ILabelingStrategy)defaultLabelingStrategy.newInstance();
            st.setLayer(layer);
            return st;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static void setDefaultLabelingStrategy(Class defaultLabelingStrategy) {
        LabelingFactory.defaultLabelingStrategy = defaultLabelingStrategy;
    }
}

