/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IArrowMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.AbstractMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;

public class ArrowMarkerSymbol
extends AbstractMarkerSymbol
implements CartographicSupport,
IArrowMarkerSymbol {
    public static final String ARROW_MARKER_SYMBOL_DYNCLASS_NAME = "ArrowMarkerSymbol";
    private static final String FIELD_SHARPNESS = "sharpness";
    private ArrowMarkerSymbol symSel;
    private double sharpeness;

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.symSel == null) {
            this.symSel = (ArrowMarkerSymbol)this.cloneForSelection(selectionColor);
            this.symSel.setColor(selectionColor);
        } else {
            this.symSel.setColor(selectionColor);
        }
        if (this.symSel instanceof CartographicSupport) {
            this.symSel.setUnit(this.getUnit());
        }
        return this.symSel;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public double getSharpness() {
        return this.sharpeness;
    }

    public void setSharpness(double sharpeness) {
        this.sharpeness = sharpeness;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        Point p;
        double size_d = this.getEfectiveSize(f);
        size_d = this.getAdjustedSize(r, size_d);
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        if (geom == null) {
            return;
        }
        try {
            p = geom.centroid();
        }
        catch (Exception ex) {
            return;
        }
        double radian_half_sharpeness = Math.toRadians(this.getSharpness() * 0.5);
        double halfHeight = size_d * Math.tan(radian_half_sharpeness);
        double theta = this.getRotation();
        g.setColor(this.getColor());
        g.setStroke(new BasicStroke());
        AffineTransform newAf = (AffineTransform)affineTransform.clone();
        newAf.translate(p.getX(), p.getY());
        newAf.rotate(theta);
        GeneralPathX gp = new GeneralPathX();
        gp.moveTo(0.0, 0.0);
        gp.lineTo(size_d, -halfHeight);
        gp.lineTo(size_d, halfHeight);
        gp.closePath();
        gp.transform(newAf);
        g.fill((Shape)gp);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrowMarkerSymbol copy = (ArrowMarkerSymbol)((Object)super.clone());
        if (this.symSel != null) {
            copy.symSel = (ArrowMarkerSymbol)((Object)this.symSel.clone());
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setSharpness(state.getDouble(FIELD_SHARPNESS));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_SHARPNESS, this.getSharpness());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(ArrowMarkerSymbol.ARROW_MARKER_SYMBOL_DYNCLASS_NAME) == null) {
                DynStruct definition = manager.addDefinition(ArrowMarkerSymbol.class, ArrowMarkerSymbol.ARROW_MARKER_SYMBOL_DYNCLASS_NAME, "ArrowMarkerSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("MarkerSymbol"));
                definition.addDynFieldDouble(ArrowMarkerSymbol.FIELD_SHARPNESS).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

