/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.ISimpleMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.AbstractMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;

public class SimpleMarkerSymbol
extends AbstractMarkerSymbol
implements ISimpleMarkerSymbol {
    public static final String SIMPLE_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME = "SimpleMarkerSymbol";
    private static final String FIELD_OUTLINED = "outlined";
    private static final String FIELD_OUTLINECOLOR = "outlineColor";
    private static final String FIELD_OUTLINESIZE = "outlineSize";
    private static final String FIELD_MARKERSTYLE = "markerStyle";
    private boolean outlined;
    private Color outlineColor;
    private double outlineSize;
    private ISymbol selectionSymbol;
    private int markerStyle;

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.selectionSymbol == null) {
            this.selectionSymbol = (SimpleMarkerSymbol)this.cloneForSelection();
        }
        this.selectionSymbol.setColor(selectionColor);
        if (this.selectionSymbol instanceof CartographicSupport) {
            ((CartographicSupport)this.selectionSymbol).setUnit(this.getUnit());
        }
        return this.selectionSymbol;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        Point p;
        double size_d = this.getCartographicSize();
        size_d = this.getAdjustedSize(r, size_d);
        int size_i = (int)Math.round(size_d);
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        int x = 0;
        int y = 0;
        try {
            p = geom.centroid();
        }
        catch (Exception ex) {
            return;
        }
        p.transform(affineTransform);
        int halfSize = size_i / 2;
        int posX = (int)(p.getX() + this.getOffset().getX()) - halfSize;
        int posY = (int)(p.getY() + this.getOffset().getY()) - halfSize;
        g.translate(posX, posY);
        if (this.getRotation() != 0.0) {
            g.rotate(this.getRotation());
        }
        g.setColor(this.getColor());
        GeneralPathX genPath = null;
        g.setStroke(new BasicStroke(1.0f));
        switch (this.markerStyle) {
            case 0: {
                g.fillOval(x, y, size_i, size_i);
                break;
            }
            case 1: {
                g.fillRect(x, y, size_i, size_i);
                break;
            }
            case 2: {
                genPath = new GeneralPathX();
                genPath.moveTo((double)(x += halfSize), (double)((y += halfSize) - halfSize));
                genPath.lineTo((double)x, (double)(y + halfSize));
                genPath.moveTo((double)(x - halfSize), (double)y);
                genPath.lineTo((double)(x + halfSize), (double)y);
                g.draw((Shape)genPath);
                break;
            }
            case 7: {
                genPath = new GeneralPathX();
                genPath.moveTo((double)(x + halfSize), (double)y);
                genPath.lineTo((double)(x + halfSize), (double)(y + size_i));
                g.draw((Shape)genPath);
                break;
            }
            case 8: {
                genPath = new GeneralPathX();
                genPath.moveTo((double)x, (double)(y + halfSize));
                genPath.lineTo((double)(x + size_i), (double)(y + halfSize));
                g.draw((Shape)genPath);
                break;
            }
            case 3: {
                genPath = new GeneralPathX();
                genPath.moveTo((double)((x += halfSize) - halfSize), (double)(y += halfSize));
                genPath.lineTo((double)x, (double)(y + halfSize));
                genPath.lineTo((double)(x + halfSize), (double)y);
                genPath.lineTo((double)x, (double)(y - halfSize));
                genPath.lineTo((double)(x - halfSize), (double)y);
                genPath.closePath();
                g.fill((Shape)genPath);
                break;
            }
            case 4: {
                genPath = new GeneralPathX();
                genPath.moveTo((double)((x += halfSize) - halfSize), (double)((y += halfSize) - halfSize));
                genPath.lineTo((double)(x + halfSize), (double)(y + halfSize));
                genPath.moveTo((double)(x - halfSize), (double)(y + halfSize));
                genPath.lineTo((double)(x + halfSize), (double)(y - halfSize));
                g.draw((Shape)genPath);
                break;
            }
            case 5: {
                int otherSize = (int)((double)size_i * 0.55);
                genPath = new GeneralPathX();
                genPath.moveTo((double)((x += halfSize) - halfSize), (double)((y += halfSize) + halfSize));
                genPath.lineTo((double)(x + halfSize), (double)(y + halfSize));
                genPath.lineTo((double)x, (double)(y - otherSize));
                genPath.closePath();
                g.fill((Shape)genPath);
                break;
            }
            case 6: {
                genPath = new GeneralPathX();
                genPath.moveTo((double)((x += halfSize) - halfSize), (double)(y += halfSize));
                genPath.lineTo((double)(x - 2 * (halfSize / 3)), (double)(y + halfSize / 3));
                genPath.lineTo((double)(x - 2 * (halfSize / 3)), (double)(y + 2 * (halfSize / 3)));
                genPath.lineTo((double)(x - halfSize / 3), (double)(y + 2 * (halfSize / 3)));
                genPath.lineTo((double)x, (double)(y + halfSize));
                genPath.lineTo((double)(x + halfSize / 3), (double)(y + 2 * (halfSize / 3)));
                genPath.lineTo((double)(x + 2 * (halfSize / 3)), (double)(y + 2 * (halfSize / 3)));
                genPath.lineTo((double)(x + 2 * (halfSize / 3)), (double)(y + halfSize / 3));
                genPath.lineTo((double)(x + halfSize), (double)y);
                genPath.lineTo((double)(x + 2 * (halfSize / 3)), (double)(y - halfSize / 3));
                genPath.lineTo((double)(x + 2 * (halfSize / 3)), (double)(y - 2 * (halfSize / 3)));
                genPath.lineTo((double)(x + halfSize / 3), (double)(y - 2 * (halfSize / 3)));
                genPath.lineTo((double)x, (double)(y - halfSize));
                genPath.lineTo((double)(x - halfSize / 3), (double)(y - 2 * (halfSize / 3)));
                genPath.lineTo((double)(x - 2 * (halfSize / 3)), (double)(y - 2 * (halfSize / 3)));
                genPath.lineTo((double)(x - 2 * (halfSize / 3)), (double)(y - halfSize / 3));
                genPath.lineTo((double)(x - halfSize), (double)y);
                genPath.closePath();
                g.fill((Shape)genPath);
            }
        }
        if (this.outlined) {
            g.setColor(this.outlineColor);
            switch (this.markerStyle) {
                case 0: {
                    g.drawOval(x, y, size_i, size_i);
                    break;
                }
                case 1: {
                    g.drawRect(x, y, size_i, size_i);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    g.draw((Shape)genPath);
                }
            }
        }
        if (this.getRotation() != 0.0) {
            g.rotate(-this.getRotation());
        }
        g.translate(-posX, -posY);
    }

    public boolean hasOutline() {
        return this.outlined;
    }

    public void setOutlined(boolean outlined) {
        this.outlined = outlined;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public double getOutlineSize() {
        return this.outlineSize;
    }

    public void setOutlineSize(double outlineSize) {
        this.outlineSize = outlineSize;
    }

    public ISymbol getSelectionSymbol() {
        return this.selectionSymbol;
    }

    public void setSelectionSymbol(ISymbol selectionSymbol) {
        this.selectionSymbol = selectionSymbol;
    }

    public void setStyle(int style) {
        this.markerStyle = style;
    }

    public int getStyle() {
        return this.markerStyle;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SimpleMarkerSymbol copy = (SimpleMarkerSymbol)((Object)super.clone());
        if (this.selectionSymbol != null) {
            copy.selectionSymbol = (ISymbol)this.selectionSymbol.clone();
        }
        return copy;
    }

    public boolean isOutlined() {
        return this.outlined;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setStyle(state.getInt(FIELD_MARKERSTYLE));
        this.setOutlined(state.getBoolean(FIELD_OUTLINED));
        if (this.isOutlined()) {
            this.setOutlineColor((Color)state.get(FIELD_OUTLINECOLOR));
            this.setOutlineSize(state.getDouble(FIELD_OUTLINESIZE));
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_MARKERSTYLE, this.getStyle());
        state.set(FIELD_OUTLINED, this.isOutlined());
        if (this.isOutlined()) {
            state.set(FIELD_OUTLINECOLOR, (Object)this.getOutlineColor());
            state.set(FIELD_OUTLINESIZE, this.getOutlineSize());
        }
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{1, 7};
            manager.registerSymbol("marker", shapeTypes, SimpleMarkerSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SimpleMarkerSymbol.SIMPLE_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(SimpleMarkerSymbol.class, SimpleMarkerSymbol.SIMPLE_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME, "SimpleMarkerSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("MarkerSymbol"));
                definition.addDynFieldInt(SimpleMarkerSymbol.FIELD_MARKERSTYLE).setMandatory(true);
                definition.addDynFieldBoolean(SimpleMarkerSymbol.FIELD_OUTLINED).setMandatory(true);
                definition.addDynFieldObject(SimpleMarkerSymbol.FIELD_OUTLINECOLOR).setClassOfValue(Color.class);
                definition.addDynFieldDouble(SimpleMarkerSymbol.FIELD_OUTLINESIZE);
            }
            return Boolean.TRUE;
        }
    }
}

