/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.svgsupport.SVGRenderer;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.BackgroundFileStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.util.ToolsUtilLocator;

public class SVGStyle
extends BackgroundFileStyle {
    public static final String SVG_STYLE_PERSISTENCE_DEF_NAME = "SVGStyle";
    private static final String SOURCE = "source";
    private final SVGRenderer renderer = ToolsUtilLocator.getSVGSupportManager().createRenderer();

    @Override
    public void drawInsideRectangle(Graphics2D g, Rectangle rect, boolean keepAspectRatio) throws SymbolDrawingException {
        this.renderer.drawInsideRectangle(g, (Rectangle2D)rect, keepAspectRatio);
    }

    public boolean isSuitableFor(ISymbol symbol) {
        return true;
    }

    @Override
    public void setSource(URL url) throws IOException {
        this.source = url;
        this.renderer.setSource(url);
    }

    @Override
    public Rectangle getBounds() {
        try {
            Rectangle2D r = this.renderer.getBounds();
            return new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
        }
        catch (Exception e) {
            return new Rectangle();
        }
    }

    public void drawOutline(Graphics2D g, Rectangle r) throws SymbolDrawingException {
        this.drawInsideRectangle(g, r);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            String sourceSymbolInLibrary = state.getString("sourceSymbolInLibrary");
            if (sourceSymbolInLibrary != null) {
                this.setSource(new URL(this.getSymbolLibraryURL().toString() + sourceSymbolInLibrary));
            } else {
                this.setSource(state.getURL(SOURCE));
            }
        }
        catch (Exception e) {
            throw new BackgroundFileStyle.PersistenceCantSetSourceException(e);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        if (this.isLibrarySymbol()) {
            state.set("sourceSymbolInLibrary", this.getSourceSymbolInLibrary());
        } else {
            state.setNull("sourceSymbolInLibrary");
        }
        state.set(SOURCE, this.source);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SVGStyle.SVG_STYLE_PERSISTENCE_DEF_NAME) == null) {
                DynStruct definition = manager.addDefinition(SVGStyle.class, SVGStyle.SVG_STYLE_PERSISTENCE_DEF_NAME, "SVGStyle Persistence definition", null, null);
                definition.extend(manager.getDefinition("BackgroundFileStyle"));
                definition.addDynFieldURL(SVGStyle.SOURCE).setMandatory(true);
                definition.addDynFieldString("sourceSymbolInLibrary").setMandatory(false);
            }
            return Boolean.TRUE;
        }
    }
}

