/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.AbstractStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ArrowDecoratorStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IArrowDecoratorStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ISimpleLineStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class SimpleLineStyle
extends AbstractStyle
implements CartographicSupport,
ISimpleLineStyle {
    public static final String SIMPLE_LINE_STYLE_PERSISTENCE_DEFINITION_NAME = "SimpleLineStyle";
    private static final String FIELD_DASH_ARRAY = "dashArray";
    private static final String FIELD_TEMP_DASH_ARRAY = "tempDashArray";
    private static final String FIELD_LINE_WIDTH = "lineWidth";
    private static final String FIELD_DASH_PHASE = "dashPhase";
    private static final String FIELD_END_CAP = "endCap";
    private static final String FIELD_LINE_JOIN = "lineJoin";
    private static final String FIELD_MITER_LIMIT = "miterLimit";
    private static final String FIELD_OFFSET = "offset";
    private static final String FIELD_UNIT = "unit";
    private static final String FIELD_ARROW_DECORATOR = "arrowDecorator";
    private static final Color PREVIEW_COLOR_1 = new Color(150, 255, 200);
    private static final Color PREVIEW_COLOR_2 = new Color(255, 200, 100);
    private static final int COLOR1_STROKE = 1;
    private static final int COLOR2_STROKE = 3;
    private float[] dashArray;
    private float[] tempDashArray;
    private float dashPhase;
    private int endCap = 0;
    private int lineJoin;
    private float miterlimit;
    private float lineWidth = 1.0f;
    private double offset = 0.0;
    private IArrowDecoratorStyle arrowDecorator;

    public SimpleLineStyle() {
        BasicStroke dummy = new BasicStroke();
        this.dashArray = dummy.getDashArray();
        this.tempDashArray = dummy.getDashArray();
        this.dashPhase = dummy.getDashPhase();
        this.endCap = 0;
        this.lineJoin = 2;
        this.miterlimit = dummy.getMiterLimit();
    }

    public SimpleLineStyle(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
        this.lineWidth = width;
        this.endCap = cap;
        this.lineJoin = join;
        this.miterlimit = miterlimit;
        this.dashArray = dash;
        this.tempDashArray = dash;
        this.dashPhase = dash_phase;
    }

    public void drawInsideRectangle(Graphics2D g, Rectangle r) {
        Stroke oldStroke = g.getStroke();
        int h = (int)(r.getHeight() / 2.0);
        int margins = 2;
        BasicStroke stroke = new BasicStroke(1.0f, this.endCap, this.lineJoin, this.miterlimit, this.tempDashArray, this.dashPhase);
        g.setStroke(stroke);
        g.setColor(PREVIEW_COLOR_1);
        g.drawLine(margins, h, r.width - margins - margins, h);
        stroke = new BasicStroke(3.0f, this.endCap, this.lineJoin, this.miterlimit, this.tempDashArray, this.dashPhase);
        g.setStroke(stroke);
        g.setColor(PREVIEW_COLOR_2);
        g.drawLine(margins, h, r.width - margins - margins, h);
        g.setStroke(oldStroke);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Stroke getStroke() {
        return new BasicStroke(this.lineWidth, this.endCap, this.lineJoin, this.miterlimit, this.tempDashArray, this.dashPhase);
    }

    public Stroke getCartographicStroke() {
        if (this.dashArray != null) {
            for (int i = 0; i < this.dashArray.length; ++i) {
                this.tempDashArray[i] = (float)this.toCartographicUnits(this.dashArray[i]);
            }
        }
        return new BasicStroke((float)this.toCartographicUnits(this.lineWidth), this.endCap, this.lineJoin, this.miterlimit, this.tempDashArray, this.dashPhase);
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float width) {
        this.lineWidth = width;
    }

    public boolean isSuitableFor(ISymbol symbol) {
        return symbol instanceof ILineSymbol;
    }

    public void setStroke(Stroke stroke) {
        if (stroke != null) {
            BasicStroke dummy = (BasicStroke)stroke;
            this.dashArray = dummy.getDashArray();
            if (this.dashArray != null) {
                this.tempDashArray = new float[this.dashArray.length];
                System.arraycopy(this.dashArray, 0, this.tempDashArray, 0, this.dashArray.length);
            } else {
                this.tempDashArray = null;
            }
            this.dashPhase = dummy.getDashPhase();
            this.endCap = dummy.getEndCap();
            this.lineJoin = dummy.getLineJoin();
            this.miterlimit = dummy.getMiterLimit();
            this.lineWidth = dummy.getLineWidth();
            this.offset = this.getOffset();
        }
    }

    public void drawOutline(Graphics2D g, Rectangle r) {
        this.drawInsideRectangle(g, r);
    }

    public double getOffset() {
        return this.offset;
    }

    public double getCartographicOffset() {
        return this.toCartographicUnits(this.offset);
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public IArrowDecoratorStyle getArrowDecorator() {
        return this.arrowDecorator;
    }

    public void setArrowDecorator(IArrowDecoratorStyle arrowDecoratorStyle) {
        this.arrowDecorator = arrowDecoratorStyle;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SimpleLineStyle copy = (SimpleLineStyle)((Object)super.clone());
        if (this.arrowDecorator != null) {
            copy.arrowDecorator = (ArrowDecoratorStyle)((Object)this.arrowDecorator.clone());
        }
        if (this.dashArray != null) {
            copy.dashArray = new float[this.dashArray.length];
            System.arraycopy(this.dashArray, 0, copy.dashArray, 0, this.dashArray.length);
        }
        if (this.tempDashArray != null) {
            copy.tempDashArray = new float[this.tempDashArray.length];
            System.arraycopy(this.tempDashArray, 0, copy.tempDashArray, 0, this.tempDashArray.length);
        }
        return copy;
    }

    private float[] getDashArray() {
        return this.dashArray;
    }

    private void setDashArray(float[] dashArray) {
        this.dashArray = dashArray;
    }

    private float getDashPhase() {
        return this.dashPhase;
    }

    private void setDashPhase(float dashPhase) {
        this.dashPhase = dashPhase;
    }

    private int getEndCap() {
        return this.endCap;
    }

    private void setEndCap(int endCap) {
        this.endCap = endCap;
    }

    private int getLineJoin() {
        return this.lineJoin;
    }

    private void setLineJoin(int lineJoin) {
        this.lineJoin = lineJoin;
    }

    private float getMiterlimit() {
        return this.miterlimit;
    }

    private void setMiterlimit(float miterlimit) {
        this.miterlimit = miterlimit;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setArrowDecorator((ArrowDecoratorStyle)((Object)state.get(FIELD_ARROW_DECORATOR)));
        this.setDashArray(state.getFloatArray(FIELD_DASH_ARRAY));
        this.tempDashArray = state.getFloatArray(FIELD_TEMP_DASH_ARRAY);
        this.setDashPhase(state.getFloat(FIELD_DASH_PHASE));
        this.setEndCap(state.getInt(FIELD_END_CAP));
        this.setLineJoin(state.getInt(FIELD_LINE_JOIN));
        this.setLineWidth(state.getFloat(FIELD_LINE_WIDTH));
        this.setMiterlimit(state.getFloat(FIELD_MITER_LIMIT));
        this.setOffset(state.getDouble(FIELD_OFFSET));
        this.setUnit(state.getInt(FIELD_UNIT));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_ARROW_DECORATOR, (Persistent)this.getArrowDecorator());
        state.set(FIELD_DASH_ARRAY, this.getDashArray());
        state.set(FIELD_TEMP_DASH_ARRAY, this.tempDashArray);
        state.set(FIELD_DASH_PHASE, this.getDashPhase());
        state.set(FIELD_END_CAP, this.getEndCap());
        state.set(FIELD_LINE_JOIN, this.getLineJoin());
        state.set(FIELD_LINE_WIDTH, this.getLineWidth());
        state.set(FIELD_MITER_LIMIT, this.getMiterlimit());
        state.set(FIELD_OFFSET, this.getOffset());
        state.set(FIELD_UNIT, this.getUnit());
    }

    public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
        super.setCartographicContext(ctx);
        if (this.arrowDecorator instanceof CartographicSupport) {
            ((CartographicSupport)this.arrowDecorator).setCartographicContext(ctx);
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SimpleLineStyle.SIMPLE_LINE_STYLE_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(SimpleLineStyle.class, SimpleLineStyle.SIMPLE_LINE_STYLE_PERSISTENCE_DEFINITION_NAME, "SimpleLineStyle Persistence definition", null, null);
                definition.extend(manager.getDefinition("Style"));
                definition.addDynFieldObject(SimpleLineStyle.FIELD_ARROW_DECORATOR).setClassOfValue(ArrowDecoratorStyle.class);
                definition.addDynFieldArray(SimpleLineStyle.FIELD_DASH_ARRAY).setClassOfItems(Float.TYPE);
                definition.addDynFieldArray(SimpleLineStyle.FIELD_TEMP_DASH_ARRAY).setClassOfItems(Float.TYPE);
                definition.addDynFieldFloat(SimpleLineStyle.FIELD_DASH_PHASE).setMandatory(true);
                definition.addDynFieldInt(SimpleLineStyle.FIELD_END_CAP).setMandatory(true);
                definition.addDynFieldInt(SimpleLineStyle.FIELD_LINE_JOIN).setMandatory(true);
                definition.addDynFieldFloat(SimpleLineStyle.FIELD_LINE_WIDTH).setMandatory(true);
                definition.addDynFieldFloat(SimpleLineStyle.FIELD_MITER_LIMIT).setMandatory(true);
                definition.addDynFieldDouble(SimpleLineStyle.FIELD_OFFSET).setMandatory(true);
                definition.addDynFieldInt(SimpleLineStyle.FIELD_UNIT).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

