/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.spinner.date;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import org.gvsig.tools.swing.impl.usability.spinner.date.NullSpinnerHandler;

public class JNullSpinner
extends JSpinner {
    private int type;
    private Pattern pattern;
    private String enableText;
    private String toolTip;
    private JLabel iconLabel;
    private int filled = 0;
    private String subType;

    public JNullSpinner(int dataType, String subType, Locale loc, String initialValue) {
        this.initSettings(dataType, subType, loc, initialValue);
    }

    public JNullSpinner(int dataType, Object value, int defaultMaximumWidth) {
        this(dataType, value);
        this.filled = defaultMaximumWidth;
    }

    private void initSettings(int dataType, String subType, Locale loc, Object value) {
        this.type = dataType;
        this.subType = subType;
        this.pattern = this.setMatcher(dataType, subType);
        this.setModel(this.type, this.subType, loc);
        this.setValue(value);
    }

    private void setModel(int type, String subType, Locale locale) {
        NullSpinnerHandler handler = new NullSpinnerHandler(type, subType, locale);
        this.setModel(handler.getModel());
    }

    public JNullSpinner(Icon icon) {
        this(8, null);
        this.iconLabel = new JLabel(icon);
    }

    public JNullSpinner(String text) {
        this(8, text);
    }

    public JNullSpinner(String text, Icon icon) {
        this(text);
        this.iconLabel = new JLabel(icon);
    }

    public String getEnableText() {
        return this.enableText;
    }

    private String getText() {
        Object value = this.getValue();
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public void setEnabled(boolean aFlag) {
        super.setEnabled(aFlag);
        if (aFlag) {
            this.setToolTipText(this.toolTip);
        } else {
            this.setToolTipText(this.enableText);
        }
    }

    public void setEnableText(String enableText) {
        this.enableText = enableText;
    }

    public void setToolTip(String text) {
        this.toolTip = text;
    }

    public void setFill(int filledMaximumWidth) {
        this.filled = filledMaximumWidth;
    }

    @Override
    public Object getValue() {
        return this.getModel().getValue();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            value = "";
        }
        this.getModel().setValue(value);
    }

    public JNullSpinner(int dataType, Object value) {
        this.initSettings(dataType, null, null, value);
    }

    private Pattern setMatcher(int dataType, String subType) {
        Pattern p = Pattern.compile(".*?");
        switch (dataType) {
            case 6: {
                Pattern.compile("([0-9]*)\\.[0]");
                break;
            }
            case 7: {
                Pattern.compile("([0-9]*)\\.[0]");
                break;
            }
            case 4: {
                Pattern.compile("([0-9]*)");
                break;
            }
            case 1: {
                Pattern.compile("[t|T]rue|[f|F]alse|[u|U]nknown");
                break;
            }
            case 5: {
                Pattern.compile("([0-9]*)");
            }
        }
        return p;
    }

    public boolean matches(String value) {
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }
}

