/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl.parser;

import org.gvsig.gpe.lib.api.parser.IAttributesIterator;
import org.gvsig.gpe.lib.api.parser.ICoordinateIterator;
import org.gvsig.gpe.lib.api.parser.IGPEContentHandler;
import org.gvsig.gpe.lib.api.parser.IGPEErrorHandler;
import org.gvsig.gpe.lib.impl.warnings.FeatureNotSupportedWarning;

public abstract class GPEContentHandler
implements IGPEContentHandler {
    private IGPEErrorHandler errorHandler = null;

    public IGPEErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(IGPEErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void addBboxToFeature(Object bbox, Object feature) {
        this.addNotSupportedWarning("Feature with bbox");
    }

    public void addBboxToLayer(Object bbox, Object layer) {
        this.addNotSupportedWarning("Layer with bbox");
    }

    public void addDescriptionToLayer(String description, Object layer) {
        this.addNotSupportedWarning("Layer with description");
    }

    public void addElementToFeature(Object element, Object feature) {
        this.addNotSupportedWarning("Feature with elements");
    }

    public void addFeatureToLayer(Object feature, Object layer) {
        this.addNotSupportedWarning("Layer with features");
    }

    public void addGeometryToFeature(Object geometry, Object feature) {
        this.addNotSupportedWarning("Feature with geometry");
    }

    public void addInnerPolygonToPolygon(Object innerPolygon, Object Polygon) {
        this.addNotSupportedWarning("Polygon with inner polygon");
    }

    public void addNameToFeature(String name, Object feature) {
        this.addNotSupportedWarning("Feature with name");
    }

    public void addNameToLayer(String name, Object layer) {
        this.addNotSupportedWarning("Layer with name");
    }

    public void addParentElementToElement(Object parent, Object element) {
        this.addNotSupportedWarning("Element with child elements");
    }

    public void addParentLayerToLayer(Object parent, Object layer) {
        this.addNotSupportedWarning("Layer with children");
    }

    public void addSrsToLayer(String srs, Object Layer) {
        this.addNotSupportedWarning("Layer with srs");
    }

    public void endBbox(Object bbox) {
    }

    public void endElement(Object element) {
    }

    public void endFeature(Object feature) {
    }

    public void endInnerPolygon(Object innerPolygon) {
    }

    public void endLayer(Object layer) {
    }

    public void endLineString(Object lineString) {
    }

    public void endLinearRing(Object linearRing) {
    }

    public void endPoint(Object point) {
    }

    public void endPolygon(Object Polygon) {
    }

    public Object startBbox(String id, ICoordinateIterator coords, String srs) {
        this.addNotSupportedWarning("Create a bbox");
        return null;
    }

    public Object startElement(String namespace, String name, Object value, IAttributesIterator attributes, Object parentElement) {
        this.addNotSupportedWarning("Create an element");
        return null;
    }

    public Object startFeature(String id, String namespace, String name, IAttributesIterator attributes, Object layer) {
        this.addNotSupportedWarning("Feature creation");
        return null;
    }

    public Object startInnerPolygon(String id, ICoordinateIterator coords, String srs) {
        this.addNotSupportedWarning("Create a polygon innerboundary");
        return null;
    }

    public Object startLayer(String id, String namespace, String name, String description, String srs, IAttributesIterator attributes, Object parentLayer, Object bBox) {
        this.addNotSupportedWarning("Layer creation");
        return null;
    }

    public Object startLineString(String id, ICoordinateIterator coords, String srs) {
        this.addNotSupportedWarning("Create a lineString");
        return null;
    }

    public Object startLinearRing(String id, ICoordinateIterator coords, String srs) {
        this.addNotSupportedWarning("Create a linearRing");
        return null;
    }

    public Object startPoint(String id, ICoordinateIterator coords, String srs) {
        this.addNotSupportedWarning("Create a point");
        return null;
    }

    public Object startPolygon(String id, ICoordinateIterator coords, String srs) {
        this.addNotSupportedWarning("Create a polygon");
        return null;
    }

    public void addGeometryToMultiGeometry(Object geometry, Object multiGeometry) {
    }

    public void addCurveToMultiCurve(Object curve, Object multiCurve) {
    }

    public Object startMultiCurve(String id, String srs) {
        this.addNotSupportedWarning("Create a multiCurve");
        return null;
    }

    public void endMultiCurve(Object multiCurve) {
    }

    public Object startCurve(String id, ICoordinateIterator coords, String srs) {
        this.addNotSupportedWarning("Create a Curve");
        return null;
    }

    public void endCurve(Object Curve) {
    }

    public void addLineStringToMultiLineString(Object lineString, Object multiLineString) {
    }

    public void addPointToMultiPoint(Object point, Object multiPoint) {
    }

    public void addPolygonToMultiPolygon(Object polygon, Object multiPolygon) {
    }

    public void endMultiGeometry(Object multiGeometry) {
    }

    public void endMultiLineString(Object multiLineString) {
    }

    public void endMultiPoint(Object multiPoint) {
    }

    public void endMultiPolygon(Object multiPolygon) {
    }

    public Object startMultiGeometry(String id, String srs) {
        this.addNotSupportedWarning("Create a multiGeometry");
        return null;
    }

    public Object startMultiLineString(String id, String srs) {
        this.addNotSupportedWarning("Create a multiLineString");
        return null;
    }

    public Object startMultiPoint(String id, String srs) {
        this.addNotSupportedWarning("Create a multiPoint");
        return null;
    }

    public Object startMultiPolygon(String id, String srs) {
        this.addNotSupportedWarning("Create a multiPolygon");
        return null;
    }

    private void addNotSupportedWarning(String objectName) {
        if (this.errorHandler != null) {
            this.errorHandler.addWarning((Throwable)((Object)new FeatureNotSupportedWarning(objectName)));
        }
    }

    public void addSegmentToCurve(Object segment, Object curve) {
    }

    public Object startCurve(String id, String srs) {
        this.addNotSupportedWarning("Create a Curve");
        return null;
    }

    public Object startMetadata(String type, String data, IAttributesIterator attributes) {
        this.addNotSupportedWarning("Create metadata");
        return null;
    }

    public Object startTime(String name, String description, String type, String time, Object previous, Object next) {
        this.addNotSupportedWarning("Create time");
        return null;
    }

    public Object startTime(String type, String time) {
        this.addNotSupportedWarning("Create metadata");
        return null;
    }

    public void addMetadataToFeature(Object metadata, Object feature) {
        this.addNotSupportedWarning("Feature with metadata");
    }

    public void addMetadataToMetadata(Object metadata, Object parent) {
        this.addNotSupportedWarning("Metadata with children");
    }

    public void addTimeToFeature(Object time, Object feature) {
        this.addNotSupportedWarning("Feature with time");
    }

    public void endMetadata(Object metadata) {
    }

    public void endTime(Object time) {
    }
}

