/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.parser.IGPEContentHandlerInmGeom;
import org.gvsig.gpe.lib.api.parser.IGPEErrorHandler;
import org.gvsig.gpe.lib.spi.parser.IGPEParser;

public abstract class GPEParser
implements IGPEParser {
    private IGPEErrorHandler errorHandler;
    private IGPEContentHandlerInmGeom contentHandler;
    private URI mainFile;
    private InputStream is = null;
    private GPEManager gpeManager = GPELocator.getGPEManager();

    public void parse(IGPEContentHandlerInmGeom contents, IGPEErrorHandler errors, URI uri) {
        this.contentHandler = contents;
        this.errorHandler = errors;
        this.mainFile = uri;
        this.parseURI();
    }

    protected abstract void parseURI();

    public void parse(IGPEContentHandlerInmGeom contents, IGPEErrorHandler errors, InputStream is) {
        this.contentHandler = contents;
        this.errorHandler = errors;
        this.is = is;
        this.parseStream();
        try {
            is.close();
        }
        catch (IOException e) {
            this.errorHandler.addError((Throwable)e);
        }
    }

    protected abstract void parseStream();

    public abstract boolean accept(URI var1);

    public abstract boolean accept(File var1);

    public abstract String getFormat();

    public IGPEContentHandlerInmGeom getContentHandler() {
        return this.contentHandler;
    }

    public IGPEErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public URI getMainFile() {
        return this.mainFile;
    }

    public abstract String getDescription();

    public abstract String getName();

    protected InputStream getInputStream() {
        return this.is;
    }

    protected void setInputStream(InputStream is) {
        this.is = is;
    }

    public void setErrorHandler(IGPEErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setContentHandler(IGPEContentHandlerInmGeom contentHandler) {
        this.contentHandler = contentHandler;
    }

    public GPEManager getGpeManager() {
        return this.gpeManager;
    }
}

