/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.lib.impl.warnings;

import java.util.Hashtable;
import java.util.Map;
import org.gvsig.tools.exception.BaseException;

public class FeatureNotSupportedWarning
extends BaseException {
    private static final long serialVersionUID = 8532995170438868404L;
    private String feature = null;
    private String parserName = null;
    public static final String LAYERWITHNAME = "Layer with name";
    public static final String LAYERWITHDESCRIPTION = "Layer with description";
    public static final String LAYERWITHBBOX = "Layer with bbox";
    public static final String LAYERWITHSRS = "Layer with srs";
    public static final String FEATUEWITHBBOX = "Feature with bbox";
    public static final String FEATUREWITHELEMENTS = "Feature with elements";
    public static final String FEATUREWITHNAME = "Feature with name";
    public static final String FEATURECREATION = "Feature creation";
    public static final String FEATUREWITHGEOMETRY = "Feature with geometry";
    public static final String LAYERCREATION = "Layer creation";
    public static final String LAYERWITHCHILDREN = "Layer with children";
    public static final String LAYERWITHFEATURES = "Layer with features";
    public static final String ELEMENTCREATION = "Create an element";
    public static final String ELEMENTWITHCHILDREN = "Element with child elements";
    public static final String BBOXCREATION = "Create a bbox";
    public static final String POINTCREATION = "Create a point";
    public static final String LINESTRINGCREATION = "Create a lineString";
    public static final String LINEARRINGCREATION = "Create a linearRing";
    public static final String POLYGONCREATION = "Create a polygon";
    public static final String POLYGONWITHINNERPOLYGON = "Polygon with inner polygon";
    public static final String INNERBOUNDARYCREATION = "Create a polygon innerboundary";
    public static final String MULTIPOINTCREATION = "Create a multiPoint";
    public static final String MULTILINESTRINGCREATION = "Create a multiLineString";
    public static final String MULTIPOLYGONCREATION = "Create a multiPolygon";
    public static final String MULTIGEOMETRYCREATION = "Create a multiGeometry";
    public static final String MULTICURVECREATION = "Create a multiCurve";
    public static final String CURVECREATION = "Create a Curve";
    public static final String METADATACREATION = "Create metadata";
    public static final String FEATUREWITHMETADATA = "Feature with metadata";
    public static final String METADATAWITHCHILDREN = "Metadata with children";
    public static final String TIMECREATION = "Create time";
    public static final String FEATUREWITHTIME = "Feature with time";

    public FeatureNotSupportedWarning(String feature, String parserName) {
        this.feature = feature;
        this.parserName = parserName;
        this.initialize();
    }

    public FeatureNotSupportedWarning(String feature) {
        this.feature = feature;
        this.initialize();
    }

    private void initialize() {
        this.messageKey = "gpe_feature_not_supported_warning";
        this.formatString = this.parserName != null ? "The feature '%(feature)' is not supported by the %(parserName) parser. It could be by two reasons: 1) The parser doesn't support this feature.  2) The format doesn't support the feature." : "The feature '%(feature)' is not supported by the consumer application.";
        this.code = 8532995170438868404L;
    }

    protected Map values() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("feature", this.feature);
        if (this.parserName != null) {
            hash.put("parserName", this.parserName);
        }
        return hash;
    }
}

