/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.ods.lib.impl;

import java.io.File;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.AbstractDataProfile;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.ods.lib.api.ODSDocument;
import org.gvsig.ods.lib.api.ODSLocator;
import org.gvsig.ods.lib.api.ODSManager;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynobject.Tags;

public class ODSProfile
extends AbstractDataProfile {
    public ODSProfile() {
        super("ODS", File.class);
    }

    public Object createData(Object ods, Tags tags) {
        ODSManager manager = ODSLocator.getODSManager();
        ODSDocument odsdoc = manager.createODSDocument();
        odsdoc.setSource(ods);
        return odsdoc;
    }

    public Object coerce(DataType dataType, Object data, Tags tags) throws CoercionException {
        try {
            switch (dataType.getType()) {
                case 12: {
                    ODSDocument document = ODSLocator.getODSManager().createODSDocument();
                    document.setSource(data);
                    return document.toByteArray();
                }
                case 13: {
                    if (data instanceof File) {
                        return data;
                    }
                }
                case 8: {
                    ODSDocument document = ODSLocator.getODSManager().createODSDocument();
                    document.setSource(data);
                    return document.toHexString();
                }
            }
        }
        catch (Exception ex) {
            throw new CoercionException("Can't convert ODS to " + dataType.getName(), (Throwable)ex);
        }
        throw new CoercionException("Can't convert ODS to " + dataType.getName());
    }

    public static void selfRegister() {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.registerDataProfile((DataProfile)new ODSProfile());
    }
}

