/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.buffer.impl.histogram.graphic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.raster.swing.buffer.impl.histogram.doubleslider.DoubleSlider;
import org.gvsig.raster.swing.buffer.impl.histogram.doubleslider.DoubleSliderEvent;
import org.gvsig.raster.swing.buffer.impl.histogram.doubleslider.DoubleSliderListener;
import org.gvsig.raster.swing.buffer.impl.histogram.graphic.BoxesPanel;
import org.gvsig.raster.swing.buffer.impl.histogram.graphic.GraphicChartPanel;
import org.gvsig.raster.swing.buffer.impl.histogram.graphic.GraphicEvent;
import org.gvsig.raster.swing.buffer.impl.histogram.graphic.GraphicListener;
import org.gvsig.raster.swing.buffer.impl.histogram.textincreaser.TextIncreaserEvent;
import org.gvsig.raster.swing.buffer.impl.histogram.textincreaser.TextIncreaserListener;

public class GraphicContainer
extends JPanel
implements DoubleSliderListener,
TextIncreaserListener {
    private static final long serialVersionUID = -6230083498345786500L;
    private ArrayList actionCommandListeners = new ArrayList();
    private JPanel pGeneral = null;
    private GraphicChartPanel pGraphic = null;
    private JPanel panelSlider = null;
    private BoxesPanel pBoxes = null;
    private DoubleSlider doubleSlider = null;
    private boolean bDoCallListeners = true;
    private static int eventId = Integer.MIN_VALUE;

    public GraphicContainer() {
        this.initialize();
    }

    public GraphicContainer(boolean showSlider) {
        this.getPDoubleSlider().setVisible(showSlider);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 4));
        this.add((Component)this.getPGraphic(), "Center");
        this.add((Component)this.getPGeneral(), "South");
    }

    private JPanel getPGeneral() {
        if (this.pGeneral == null) {
            this.pGeneral = new JPanel();
            this.pGeneral.setLayout(new BorderLayout(0, 2));
            this.getPDoubleSlider().setPreferredSize(new Dimension(50, 25));
            this.pGeneral.add((Component)this.getPDoubleSlider(), "North");
            this.pGeneral.add((Component)this.getPBoxes(), "South");
        }
        return this.pGeneral;
    }

    public GraphicChartPanel getPGraphic() {
        if (this.pGraphic == null) {
            this.pGraphic = new GraphicChartPanel();
        }
        return this.pGraphic;
    }

    private JComponent getPDoubleSlider() {
        if (this.panelSlider == null) {
            this.panelSlider = new JPanel();
            this.panelSlider.setLayout(new BorderLayout());
            this.panelSlider.add((Component)this.getDoubleSlider(), "Center");
        }
        return this.panelSlider;
    }

    private DoubleSlider getDoubleSlider() {
        if (this.doubleSlider == null) {
            this.doubleSlider = new DoubleSlider();
            this.doubleSlider.addValueChangedListener(this);
        }
        return this.doubleSlider;
    }

    private BoxesPanel getPBoxes() {
        if (this.pBoxes == null) {
            this.pBoxes = new BoxesPanel();
            this.pBoxes.getControlLeft().addValueChangedListener(this);
            this.pBoxes.getControlRight().addValueChangedListener(this);
        }
        return this.pBoxes;
    }

    public double getX1() {
        double value = this.getPBoxes().getControlLeft().getValue();
        if (value > 100.0) {
            value = 100.0;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        return value;
    }

    public double getX2() {
        double value = this.getPBoxes().getControlRight().getValue();
        if (value > 100.0) {
            value = 100.0;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        return value;
    }

    @Override
    public void actionValueChanged(TextIncreaserEvent e) {
        if (e.getSource() == this.getPBoxes().getControlLeft() && this.getPBoxes().getControlLeft().getValue() > this.getPBoxes().getControlRight().getValue()) {
            this.getPBoxes().getControlRight().setValue(this.getPBoxes().getControlLeft().getValue());
        }
        if (e.getSource() == this.getPBoxes().getControlRight() && this.getPBoxes().getControlRight().getValue() < this.getPBoxes().getControlLeft().getValue()) {
            this.getPBoxes().getControlLeft().setValue(this.getPBoxes().getControlRight().getValue());
        }
        this.getDoubleSlider().setX1((int)this.getPBoxes().getControlLeft().getValue());
        this.getDoubleSlider().setX2((int)this.getPBoxes().getControlRight().getValue());
        this.callValueChangedListeners();
    }

    public void addValueChangedListener(GraphicListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(GraphicListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callValueChangedListeners() {
        if (!this.bDoCallListeners) {
            return;
        }
        for (GraphicListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new GraphicEvent(this));
        }
        ++eventId;
    }

    public void setBandVisible(int band, boolean visible) {
        this.getPGraphic().getChart().getChart().getXYPlot().getRenderer().setSeriesVisible(band, Boolean.valueOf(visible));
    }

    public void setBandColor(int band, Color color) {
        this.getPGraphic().getChart().getChart().getXYPlot().getRenderer().setSeriesPaint(band, (Paint)color);
    }

    @Override
    public void actionValueChanged(DoubleSliderEvent e) {
        this.getPBoxes().getControlLeft().setValue(((DoubleSlider)e.getSource()).getX1());
        this.getPBoxes().getControlRight().setValue(((DoubleSlider)e.getSource()).getX2());
        this.callValueChangedListeners();
    }

    @Override
    public void actionValueDragged(DoubleSliderEvent e) {
        this.actionValueChanged(e);
    }
}

