/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.SODS.spreadsheet;

import com.github.miachm.SODS.spreadsheet.Cell;
import com.github.miachm.SODS.spreadsheet.Range;
import java.util.ArrayList;
import java.util.List;

public class Sheet
implements Cloneable,
Comparable<Sheet> {
    private List<List<Cell>> cells = new ArrayList<List<Cell>>();
    private String name;
    private int numColumns = 1;

    public Sheet(String name) {
        this.name = name;
        this.cells.add(new ArrayList());
        Cell cell = new Cell();
        cell.setValue("");
        this.cells.get(0).add(cell);
    }

    public void appendRow() {
        this.appendRows(1);
    }

    public void appendRows(int howmany) {
        this.insertRowsAfter(this.getMaxRows() - 1, howmany);
    }

    public void appendColumn() {
        this.appendColumns(1);
    }

    public void appendColumns(int howmany) {
        this.insertColumnsAfter(this.getMaxColumns() - 1, howmany);
    }

    public void clear() {
        this.getDataRange().clear();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void deleteColumn(int column) {
        this.deleteColumns(column, 1);
    }

    public void deleteColumns(int column, int howmany) {
        for (List<Cell> row : this.cells) {
            for (int i = 0; i < howmany; ++i) {
                row.remove(column);
            }
        }
        this.numColumns -= howmany;
    }

    public void deleteRow(int row) {
        this.deleteRows(row, 1);
    }

    public void deleteRows(int row, int howmany) {
        for (int i = 0; i < howmany; ++i) {
            this.cells.remove(row);
        }
    }

    public Range getDataRange() {
        return this.getRange(0, 0, this.getMaxRows(), this.getMaxColumns());
    }

    public int getMaxColumns() {
        return this.cells.isEmpty() ? this.numColumns : this.cells.get(0).size();
    }

    public int getMaxRows() {
        return this.cells.size();
    }

    public String getName() {
        return this.name;
    }

    public Range getRange(int row, int column) {
        return this.getRange(row, column, 1, 1);
    }

    public Range getRange(int row, int column, int numRows) {
        return this.getRange(row, column, numRows, 1);
    }

    public Range getRange(int row, int column, int numRows, int numColumns) {
        return new Range(this, row, column, numRows, numColumns);
    }

    Cell getCell(int row, int column) {
        return this.cells.get(row).get(column);
    }

    public void insertColumnAfter(int afterPosition) {
        this.insertColumnsAfter(afterPosition, 1);
    }

    public void insertColumnBefore(int beforePosition) {
        this.insertColumnsBefore(beforePosition, 1);
    }

    public void insertColumnsAfter(int columnIndex, int howmany) {
        this.insertColumnsBefore(columnIndex + 1, howmany);
    }

    public void insertColumnsBefore(int columnIndex, int howmany) {
        for (List<Cell> row : this.cells) {
            for (int i = 0; i < howmany; ++i) {
                row.add(columnIndex, new Cell());
            }
        }
        this.numColumns += howmany;
    }

    public void insertRowAfter(int afterPosition) {
        this.insertRowsAfter(afterPosition, 1);
    }

    public void insertRowBefore(int beforePosition) {
        this.insertRowsBefore(beforePosition, 1);
    }

    public void insertRowsBefore(int rowIndex, int howmany) {
        for (int i = 0; i < howmany; ++i) {
            ArrayList<Cell> row = new ArrayList<Cell>();
            for (int j = 0; j < this.numColumns; ++j) {
                row.add(new Cell());
            }
            this.cells.add(rowIndex, row);
        }
    }

    public void insertRowsAfter(int rowIndex, int howmany) {
        this.insertRowsBefore(rowIndex + 1, howmany);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sheet sheet = (Sheet)o;
        if (!this.cells.equals(sheet.cells)) {
            return false;
        }
        return this.name.equals(sheet.name);
    }

    public int hashCode() {
        int result = this.cells.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public int compareTo(Sheet o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return "Sheet{ name='" + this.name + '\'' + " ,cells=" + this.getDataRange().toString() + '}';
    }
}

