/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.alg;

import java.util.List;
import java.util.Set;
import org.javanetworkanalyzer.alg.TraversalAlg;
import org.javanetworkanalyzer.data.VPred;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.javanetworkanalyzer.model.TraversalGraph;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;

public abstract class GraphSearchAlgorithm<V extends VPred, E extends EdgeSPT>
implements TraversalAlg<V, E> {
    protected final Graph<V, E> graph;
    protected V currentStartNode;

    public GraphSearchAlgorithm(Graph<V, E> graph) {
        this.graph = graph;
    }

    protected void init(V startNode) {
        this.currentStartNode = startNode;
    }

    @Override
    public TraversalGraph<V, E> reconstructTraversalGraph() {
        if (this.currentStartNode == null) {
            throw new IllegalStateException("You must call #calculate before reconstructing the traversal graph.");
        }
        TraversalGraph traversalGraph = new TraversalGraph(this.graph.getEdgeFactory(), this.currentStartNode);
        for (VPred v : this.graph.vertexSet()) {
            Set predEdges = v.getPredecessorEdges();
            for (EdgeSPT e : predEdges) {
                VPred source = (VPred)this.graph.getEdgeSource((Object)e);
                VPred target = (VPred)this.graph.getEdgeTarget((Object)e);
                traversalGraph.addVertex(source);
                traversalGraph.addVertex(target);
                if (v.equals(source)) {
                    ((EdgeSPT)traversalGraph.addEdge(target, source)).setBaseGraphEdge(e);
                    continue;
                }
                if (v.equals(target)) {
                    ((EdgeSPT)traversalGraph.addEdge(source, target)).setBaseGraphEdge(e);
                    continue;
                }
                throw new IllegalStateException("A vertex has a predecessor edge not ending on itself.");
            }
        }
        return traversalGraph;
    }

    public Set<E> outgoingEdgesOf(V node) {
        return GraphSearchAlgorithm.outgoingEdgesOf(this.graph, node);
    }

    public static Set outgoingEdgesOf(Graph g, Object node) {
        if (g instanceof DirectedGraph) {
            return ((DirectedGraph)g).outgoingEdgesOf(node);
        }
        return g.edgesOf(node);
    }

    public List<V> successorListOf(V node) {
        if (this.graph instanceof DirectedGraph) {
            return Graphs.successorListOf((DirectedGraph)((DirectedGraph)this.graph), node);
        }
        return Graphs.neighborListOf(this.graph, node);
    }

    public int outdegree(V node) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outDegreeOf(node);
        }
        if (this.graph instanceof UndirectedGraph) {
            return ((UndirectedGraph)this.graph).degreeOf(node);
        }
        return -1;
    }
}

