/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.shape.swing.panels;

import javax.swing.JComponent;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.shape.service.ExportShapeParameters;
import org.gvsig.export.shape.swing.panels.SelectSimplifiedExportView;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSimplifiedExport
extends SelectSimplifiedExportView
implements ExportPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SelectSimplifiedExport.class);
    private final ExportShapeParameters parameters;
    private final JExportProcessPanel processPanel;

    public SelectSimplifiedExport(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = (ExportShapeParameters)parameters;
        this.initComponents();
    }

    private void initComponents() {
        this.chkUseSimplifiedExport.setSelected(this.parameters.getUseSimplifiedExport());
        this.translate();
    }

    private void translate() {
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        i18nc.translate(this.lblUseSimplifiedExport);
        String s = i18n.getTranslation(this.lblUseSimplifiedExportDescription.getText());
        s = "<html>" + s.replace("\n", "<br>\n") + "</html>";
        this.lblUseSimplifiedExportDescription.setText(s);
    }

    public boolean getUseSimplifiedExport() {
        return this.chkUseSimplifiedExport.isSelected();
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getIdPanel() {
        return this.getClass().getSimpleName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Select_simplified_export");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setUseSimplifiedExport(this.getUseSimplifiedExport());
    }
}

