/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyReportLine;
import org.gvsig.topology.lib.api.TopologyReportLineSet;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.swing.api.JTopologyReport;
import org.gvsig.topology.swing.api.TopologySwingLocator;
import org.gvsig.topology.swing.api.TopologySwingServices;
import org.gvsig.topology.swing.impl.DefaultJTopologyReportView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJTopologyReport
extends DefaultJTopologyReportView
implements JTopologyReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJTopologyReport.class);
    private ListSelectionModel selection;
    private ReportTable linesModel;
    private final TopologySwingServices services = TopologySwingLocator.getTopologySwingManager().getDefaultServices();
    private TaskStatusController taskStatusController;
    private TopologyPlan plan;
    private TopologySwingServices.WorkingAreaChangedListener workingAreaChangedListener;

    public DefaultJTopologyReport(TopologyPlan plan) {
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.selection = this.tblErrors.getSelectionModel();
        this.linesModel = new ReportTable();
        this.workingAreaChangedListener = workingArea -> this.doUpdateFilter();
        this.tblErrors.setModel(this.linesModel);
        this.tblErrors.setAutoResizeMode(3);
        this.btnZoomGeometry.addActionListener(e -> this.doZoomGeometry());
        this.btnZoomError.addActionListener(e -> this.doZoomError());
        this.btnCenterGeometry.addActionListener(e -> this.doCenterGeometry());
        this.btnCenterError.addActionListener(e -> this.doCenterError());
        this.btnRefresh.addActionListener(e -> this.doExecutePlan());
        this.tblErrors.getSelectionModel().addListSelectionListener(e -> this.doRowSelected());
        this.tblErrors.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    DefaultJTopologyReport.this.doCenterError();
                }
            }
        });
        this.btnActions.addActionListener(e -> this.doSelectAction());
        this.btnParametersCancel.addActionListener(e -> {
            this.tabData.setEnabledAt(0, true);
            this.tabData.setEnabledAt(1, false);
            this.tabData.setSelectedIndex(0);
            this.pnlParameters.removeAll();
        });
        this.btnShowErrors.addActionListener(e -> this.doUpdateFilter());
        this.btnShowExceptions.addActionListener(e -> this.doUpdateFilter());
        this.btnVisibleExtentOnly.addActionListener(e -> this.doUpdateFilter());
        this.btnShowFormWhenEdit.addActionListener(e -> this.services.setShowFormWhenEdit(this.btnShowFormWhenEdit.isSelected()));
        this.btnEraseErrorMarks.addActionListener(e -> this.services.addError(null));
        DefaultComboBoxModel<ListElement> modelRules = new DefaultComboBoxModel<ListElement>();
        modelRules.addElement(new ListElement(i18n.getTranslation("_Any_rule"), (Object)null));
        List factories = TopologyLocator.getTopologyManager().getRuleFactories();
        for (TopologyRuleFactory factory : factories) {
            modelRules.addElement(new ListElement(factory.getName(), (Object)factory));
        }
        this.cboRules.setModel(modelRules);
        this.cboRules.addActionListener(e -> SwingUtilities.invokeLater(() -> this.doUpdateFilter()));
        this.btnShowForm.addActionListener(e -> this.showErrorForm());
        this.taskStatusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(null, this.lblTaskStatusTitle, this.lblTaskStatusMessage, this.pbTaskStatusProgress, this.btnTaskStatusCancel, null);
        this.translate();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)10, (int)100, (int)20, (int)150);
        this.btnShowErrors.setSelected(false);
        this.btnShowExceptions.setSelected(false);
        this.btnVisibleExtentOnly.setSelected(false);
        this.tabData.setEnabledAt(1, false);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = this.getClass().getResource("/" + imageName);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    private void translate() {
        ToolsSwingManager tsm = ToolsSwingLocator.getToolsSwingManager();
        tsm.translate((AbstractButton)this.btnActions);
        tsm.translate((AbstractButton)this.btnCenterError);
        tsm.translate((AbstractButton)this.btnCenterGeometry);
        tsm.translate((AbstractButton)this.btnRefresh);
        tsm.translate((AbstractButton)this.btnShowErrors);
        tsm.translate((AbstractButton)this.btnShowExceptions);
        tsm.translate((AbstractButton)this.btnZoomError);
        tsm.translate((AbstractButton)this.btnZoomGeometry);
        tsm.translate((AbstractButton)this.btnEraseErrorMarks);
        tsm.translate((AbstractButton)this.btnVisibleExtentOnly);
        tsm.translate((AbstractButton)this.btnParametersAccept);
        tsm.translate((AbstractButton)this.btnParametersCancel);
        tsm.translate((AbstractButton)this.btnShowFormWhenEdit);
        tsm.translate(this.lblShow);
        tsm.translate(this.tabData);
        tsm.translate((AbstractButton)this.btnShowForm);
    }

    public void put(TopologyPlan plan) {
        this.plan = plan;
        this.taskStatusController.bind((TaskStatus)this.plan.getTaskStatus());
        this.plan.getTaskStatus().addObserver((o, o1) -> this.doTaskStatusUpdated(o, o1));
        this.linesModel.setReport(plan.getReport());
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doUpdateFilter() {
        this.linesModel.setFilter(this.getFilter());
    }

    private String getFilter() {
        GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
        TopologyRuleFactory ruleFactory = (TopologyRuleFactory)ListElement.getSelected((JComboBox)this.cboRules);
        if (ruleFactory != null) {
            builder.set((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column("RULE_ID"), (ExpressionBuilder.Value)builder.constant((Object)ruleFactory.getId())));
        }
        if (this.btnShowErrors.isSelected()) {
            if (this.btnShowExceptions.isSelected()) {
                builder.and((ExpressionBuilder.Value)builder.or((ExpressionBuilder.Value)builder.column("IS_ERROR"), (ExpressionBuilder.Value)builder.column("IS_EXCEPTION")));
            } else {
                builder.and((ExpressionBuilder.Value)builder.column("IS_ERROR"));
            }
        } else if (this.btnShowExceptions.isSelected()) {
            builder.and((ExpressionBuilder.Value)builder.column("IS_EXCEPTION"));
        }
        if (this.btnVisibleExtentOnly.isSelected()) {
            Envelope workingArea = this.services.getWorkingArea();
            if (workingArea != null) {
                builder.and((ExpressionBuilder.Value)builder.ST_Intersects((ExpressionBuilder.Value)builder.column("GEOMETRY"), (ExpressionBuilder.Value)builder.geometry(workingArea.getGeometry())));
            }
            this.services.addWorkingAreaChangedListener(this.workingAreaChangedListener);
        } else {
            this.services.removeWorkingAreaChangedListener(this.workingAreaChangedListener);
        }
        if (builder.value() == null) {
            return null;
        }
        return builder.toString();
    }

    private void doExecutePlan() {
        Thread th = new Thread(() -> this.plan.execute(), "TopologyPlan-" + this.plan.getName());
        th.start();
    }

    private void doTaskStatusUpdated(Observable observable, Object notification) {
        if (observable != null && !(observable instanceof TaskStatus)) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.doTaskStatusUpdated(observable, notification));
            return;
        }
        TaskStatus taskStatus = (TaskStatus)observable;
        if (taskStatus == null || !taskStatus.isRunning()) {
            this.lblTaskStatusTitle.setVisible(false);
            this.lblTaskStatusMessage.setVisible(false);
            this.pbTaskStatusProgress.setVisible(false);
            this.btnTaskStatusCancel.setVisible(false);
            this.btnRefresh.setEnabled(true);
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.message(i18n.getTranslation("_Errors") + ": " + this.linesModel.getRowCount());
            return;
        }
        if (!this.pbTaskStatusProgress.isVisible()) {
            this.lblTaskStatusTitle.setVisible(true);
            this.lblTaskStatusMessage.setVisible(true);
            this.pbTaskStatusProgress.setVisible(true);
            this.btnTaskStatusCancel.setVisible(true);
            this.btnRefresh.setEnabled(false);
        }
    }

    private void message(String msg) {
        this.lblTaskStatusTitle.setText(msg);
        this.lblTaskStatusTitle.setVisible(true);
    }

    private void doSelectAction() {
        int n = this.tblErrors.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (this.linesModel.getRowCount() < 1) {
            return;
        }
        int[] selectedRows = this.tblErrors.getSelectedRows();
        TopologyRule rule = this.linesModel.getLine(selectedRows[0]).getRule();
        List actions = rule.getActions();
        if (actions == null || actions.isEmpty()) {
            return;
        }
        ArrayList<TopologyReportLine> lines = new ArrayList<TopologyReportLine>();
        for (int selectedRow : selectedRows) {
            TopologyReportLine line = this.linesModel.getLine(selectedRow);
            if (line.getRule() != rule) continue;
            lines.add(line);
        }
        JPopupMenu menu = new JPopupMenu();
        for (TopologyRuleAction action : actions) {
            JMenuItem item = action.hasParameters() ? new JMenuItem(action.getName() + "...") : new JMenuItem(action.getName());
            item.addActionListener(new TopologyRuleActionListener(rule, lines, action));
            if (lines.size() > 1 && action.hasParameters()) {
                item.setEnabled(false);
            }
            menu.add(item);
        }
        menu.show(this.btnActions, 0, this.btnActions.getHeight());
    }

    private void doExecuteRuleAction(TopologyRule rule, List<TopologyReportLine> lines, TopologyRuleAction action, JDynForm form) {
        DynObject parameters = null;
        if (form != null && (parameters = action.createParameters()) != null) {
            form.getValues(parameters);
        }
        for (TopologyReportLine line : lines) {
            action.execute(rule, line, parameters);
        }
        this.tabData.setEnabledAt(0, true);
        this.tabData.setEnabledAt(1, false);
        this.tabData.setSelectedIndex(0);
        this.pnlParameters.removeAll();
        this.services.addError(null);
    }

    private void doShowActionParametersPanel(TopologyRule rule, List<TopologyReportLine> lines, TopologyRuleAction action) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.tabData.setEnabledAt(0, false);
        this.tabData.setEnabledAt(1, true);
        this.tabData.setSelectedIndex(1);
        try {
            JDynForm form = null;
            this.lblActionTitle.setText("<html>" + i18n.getTranslation("_Rule") + ": <b>" + rule.getName() + "</b>, " + i18n.getTranslation("_Action") + ": <b>" + action.getName() + "</b></html>");
            this.lblActionDescription.setText("<html>" + action.getShortDescription() + "</html>");
            DynObject parameters = action.createParameters();
            if (parameters != null && (form = DynFormLocator.getDynFormManager().createJDynForm(parameters)) != null) {
                this.pnlParameters.setLayout(new BorderLayout());
                this.pnlParameters.removeAll();
                this.pnlParameters.add((Component)form.asJComponent(), "Center");
                this.pnlParameters.revalidate();
                this.pnlParameters.repaint();
            }
            this.btnParametersAccept.addActionListener(new TopologyRuleActionParametersListener(rule, lines, action, form));
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show action parameters panel.", (Throwable)ex);
        }
    }

    private void doZoomGeometry() {
        int n = this.tblErrors.getSelectedRow();
        if (n < 0) {
            return;
        }
        TopologyReportLine line = this.linesModel.getLine(n);
        Geometry geom = line.getGeometry();
        if (geom != null) {
            this.services.zoomTo(geom.getEnvelope());
        }
    }

    private void doZoomError() {
        int n = this.tblErrors.getSelectedRow();
        if (n < 0) {
            return;
        }
        TopologyReportLine line = this.linesModel.getLine(n);
        Geometry geom = line.getError();
        if (geom == null) {
            this.services.addError(null);
            geom = line.getGeometry();
            if (geom != null) {
                this.services.zoomTo(geom.getEnvelope());
            }
        } else {
            this.services.addError(geom);
            this.services.zoomTo(geom.getEnvelope());
        }
    }

    private void doCenterGeometry() {
        try {
            int n = this.tblErrors.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.doRowSelected();
            TopologyReportLine line = this.linesModel.getLine(n);
            Geometry geom = line.getGeometry();
            if (geom != null) {
                this.services.centerTo(geom.centroid());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't center topology error", (Throwable)ex);
        }
    }

    private void doCenterError() {
        try {
            int n = this.tblErrors.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.doRowSelected();
            TopologyReportLine line = this.linesModel.getLine(n);
            Geometry geom = line.getError();
            if (geom == null) {
                this.services.addError(null);
                geom = line.getGeometry();
            } else {
                this.services.addError(geom);
            }
            if (geom != null) {
                this.services.centerTo(geom.centroid());
                LOGGER.trace("ErrorGeom = " + geom.getClass().getSimpleName() + " " + geom.convertToWKTQuietly());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't center topology error", (Throwable)ex);
        }
    }

    private void doRowSelected() {
        try {
            int n = this.tblErrors.getSelectedRow();
            if (n < 0) {
                return;
            }
            TopologyReportLine line = this.linesModel.getLine(n);
            if (line.getFeature1() == null && line.getFeature2() == null) {
                return;
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.services.addError(null);
            if (line.getDataSet1() != null) {
                FeatureStore store1 = line.getDataSet1().getFeatureStore();
                if (line.getFeature1() != null) {
                    this.services.selectFeature(store1, line.getFeature1());
                }
            }
            if (line.getDataSet2() != null) {
                FeatureStore store2 = line.getDataSet2().getFeatureStore();
                if (line.getFeature2() != null) {
                    this.services.selectFeature(store2, line.getFeature2());
                }
            }
            this.message(i18n.getTranslation("_Errors") + ": " + this.linesModel.getRowCount() + " " + line.getDescription());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't select topology error", (Throwable)ex);
        }
    }

    private void saveCurrentSelection() {
        this.tblErrors.setSelectionModel(new DefaultListSelectionModel());
    }

    private void restoreCurrentSelection() {
        this.tblErrors.setSelectionModel(this.selection);
    }

    private void showErrorForm() {
        int n = this.tblErrors.getSelectedRow();
        if (n < 0) {
            return;
        }
        TopologyReportLine line = this.linesModel.getLine(n);
        DataStore store = line.getDataSet1().getStore();
        try {
            FeatureStore fStore = (FeatureStore)store;
            FeatureType fType = fStore.getDefaultFeatureType();
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            FeatureAttributeDescriptor[] pk = fType.getPrimaryKey();
            if (pk == null) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                String message = i18n.getTranslation("_The_report_cant show._The_table_dont_have_primary_key");
                String title = i18n.getTranslation("_No_primary_key");
                ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(message, title, 2);
                return;
            }
            Feature feature = line.getFeature1().getFeature();
            for (FeatureAttributeDescriptor attr : pk) {
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.variable(attr.getName()), (ExpressionBuilder.Value)builder.constant(feature.get(attr.getName()))));
            }
            String filter = builder.toString();
            JFeaturesForm form = this.createform(fStore);
            FeatureQuery query = fStore.createFeatureQuery();
            query.setFilter(filter);
            form.setQuery(query);
            form.showForm(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create form", (Throwable)ex);
        }
    }

    private JFeaturesForm createform(FeatureStore featureStore) throws CreateJFeatureFormException, ServiceException, DataException {
        DataSwingManager swingManager = DALSwingLocator.getSwingManager();
        JFeaturesForm form = swingManager.createJFeaturesForm(featureStore);
        form.getFormset().setAllowDelete(true);
        form.getFormset().setAllowNew(true);
        ToolsSwingUtils.ensureRowsCols((JComponent)form.asJComponent(), (int)15, (int)80, (int)22, (int)110);
        return form;
    }

    private class ReportTable
    implements TableModel {
        private TopologyReport report;
        private TopologyReportLineSet lines;
        private final String[] columnNames;
        private final Class[] columnClasses;
        private final Set<TableModelListener> tableListeners;
        private final ChangeListener reportListener;
        private String lastFilter;

        public ReportTable() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.report = null;
            this.lines = null;
            this.tableListeners = new HashSet<TableModelListener>();
            this.columnNames = new String[]{"", i18n.getTranslation("_Rule"), i18n.getTranslation("_Dataset1"), i18n.getTranslation("_Dataset2"), i18n.getTranslation("_Exception"), i18n.getTranslation("_Description")};
            this.columnClasses = new Class[]{Integer.class, String.class, String.class, String.class, Boolean.class, String.class};
            this.reportListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(() -> this.stateChanged(e));
                        return;
                    }
                    ReportTable.this.fireTableChanged();
                }
            };
        }

        public void setReport(TopologyReport report) {
            if (this.report != null) {
                this.report.removeChangeListener(this.reportListener);
            }
            this.report = report;
            this.lines = this.report;
            this.lines.addChangeListener(this.reportListener);
        }

        public void setFilter(String filter) {
            if (StringUtils.equals((CharSequence)filter, (CharSequence)this.lastFilter)) {
                return;
            }
            this.lines = this.report.getLineSet(filter);
            this.lines.addChangeListener(this.reportListener);
            this.lastFilter = filter;
            this.fireTableChanged();
        }

        public TopologyReport getReport() {
            return this.report;
        }

        @Override
        public int getRowCount() {
            if (this.lines == null) {
                return 0;
            }
            return this.lines.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.lines == null) {
                return "";
            }
            TopologyReportLine line = this.lines.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex;
                }
                case 1: {
                    return line.getRule().getName();
                }
                case 2: {
                    return line.getDataSet1().getName();
                }
                case 3: {
                    if (line.getDataSet2() == null) {
                        return "";
                    }
                    return line.getDataSet2().getName();
                }
                case 4: {
                    return line.isException();
                }
                case 5: {
                    return line.getDescription();
                }
            }
            return "???";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.tableListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.tableListeners.remove(l);
        }

        private void fireTableChanged() {
            DefaultJTopologyReport.this.saveCurrentSelection();
            for (TableModelListener tableListener : this.tableListeners) {
                tableListener.tableChanged(new TableModelEvent(this));
            }
            DefaultJTopologyReport.this.restoreCurrentSelection();
        }

        public TopologyReportLine getLine(int lineNum) {
            return this.lines.get(lineNum);
        }
    }

    private class TopologyRuleActionListener
    implements ActionListener {
        private final TopologyRule rule;
        private final List<TopologyReportLine> lines;
        private final TopologyRuleAction action;

        public TopologyRuleActionListener(TopologyRule rule, List<TopologyReportLine> lines, TopologyRuleAction action) {
            this.action = action;
            this.lines = lines;
            this.rule = rule;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.action.hasParameters()) {
                DefaultJTopologyReport.this.doShowActionParametersPanel(this.rule, this.lines, this.action);
            } else {
                DefaultJTopologyReport.this.doExecuteRuleAction(this.rule, this.lines, this.action, null);
            }
        }
    }

    private class TopologyRuleActionParametersListener
    implements ActionListener {
        private final TopologyRule rule;
        private final List<TopologyReportLine> lines;
        private final TopologyRuleAction action;
        private final JDynForm form;

        public TopologyRuleActionParametersListener(TopologyRule rule, List<TopologyReportLine> lines, TopologyRuleAction action, JDynForm form) {
            this.action = action;
            this.lines = lines;
            this.rule = rule;
            this.form = form;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultJTopologyReport.this.doExecuteRuleAction(this.rule, this.lines, this.action, this.form);
        }
    }
}

