/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.exceptions.ConnectionErrorLayerException;
import org.gvsig.fmap.mapcontext.exceptions.DriverLayerException;
import org.gvsig.fmap.mapcontext.exceptions.LegendLayerException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.exceptions.NameLayerException;
import org.gvsig.fmap.mapcontext.exceptions.ProjectionLayerException;
import org.gvsig.fmap.mapcontext.exceptions.TypeLayerException;
import org.gvsig.fmap.mapcontext.exceptions.URLLayerException;
import org.gvsig.fmap.mapcontext.exceptions.UnsupportedVersionLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.WMSParamsPanel;
import org.gvsig.raster.wms.app.wmsclient.gui.wizard.LayerTreeModel;
import org.gvsig.raster.wms.app.wmsclient.layer.FLyrWMS;
import org.gvsig.raster.wms.io.WMSLayerNode;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSPropsDialog
extends JPanel
implements IWindow {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(WMSPropsDialog.class);
    JDialog dlg = null;
    private JPanel buttonsPanel = null;
    private FLyrRaster fLayer = null;
    boolean applied = false;
    private WindowInfo m_ViewInfo = null;
    private JButton btnApply = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private WMSParamsPanel wmsParamsTabbedPane;
    private CommandListener m_actionListener;
    private WMSServerExplorer explorer = null;

    public WMSPropsDialog(FLayer layer) {
        if (layer instanceof FLyrRaster) {
            this.initialize((FLyrRaster)layer);
        }
    }

    private void initialize(FLyrRaster layer) {
        this.setLayout(new BorderLayout());
        this.setFLayer(layer);
        this.wmsParamsTabbedPane = this.getParamsPanel(((FLyrWMS)layer).getProperties());
        this.wmsParamsTabbedPane.addWizardListener(new WizardListener(){

            public void wizardStateChanged(boolean finishable) {
                WMSPropsDialog.this.getBtnOk().setEnabled(finishable);
                WMSPropsDialog.this.getBtnApply().setEnabled(finishable);
            }

            public void error(Exception e) {
            }
        });
        this.wmsParamsTabbedPane.disableDisagregatedLayers();
        this.add((Component)((Object)this.wmsParamsTabbedPane), "Center");
        this.add((Component)this.getButtonsPanel(), "South");
    }

    public void setFLayer(FLyrRaster f) {
        this.fLayer = f;
    }

    public WMSParamsPanel getParamsPanel(HashMap info) {
        if (info != null) {
            block14: {
                try {
                    if (this.explorer != null) break block14;
                    this.explorer = ((FLyrWMS)this.fLayer).getExplorer();
                    try {
                        this.explorer.connect((ICancellable)new CancelTaskImpl(), true);
                    }
                    catch (ConnectException e) {
                        RasterSwingLibrary.messageBoxError((String)"The connection cannot be established", (Object)this, (Exception)((Object)e));
                        return null;
                    }
                }
                catch (Exception e) {
                    this.explorer = null;
                    JOptionPane.showMessageDialog(null, "error_comunicacion_servidor", "Error", 0);
                }
            }
            try {
                Dimension sz;
                Vector v;
                String infoFormat;
                String format;
                WMSParamsPanel toc = new WMSParamsPanel();
                toc.setLayerName((String)info.get("name"));
                toc.setWizardData(this.explorer);
                toc.setVisible(true);
                toc.setListenerSupport(new WizardListenerSupport());
                WMSLayerNode[] selectedLayers = ((Vector)info.get("selectedLayers")).toArray(new WMSLayerNode[0]);
                for (int i = 0; i < selectedLayers.length; ++i) {
                    toc.getJustTreeLayer().clearSelection();
                    TreePath path = new TreePath(((LayerTreeModel)toc.getJustTreeLayer().getModel()).getNodeByName(selectedLayers[i].getName()));
                    toc.getJustTreeLayer().addSelectionPath(path);
                    toc.addLayer();
                }
                String srs = (String)info.get("srs");
                int index = toc.getSRSIndex(srs);
                if (index != -1) {
                    toc.getLstSRSs().setSelectedIndex(index);
                }
                if ((index = toc.getFormatIndex(format = (String)info.get("format"))) != -1) {
                    toc.getLstFormats().setSelectedIndex(index);
                }
                if ((index = toc.getInfoFormatIndex(infoFormat = (String)info.get("infoformat"))) != -1) {
                    toc.getLstInfoFormats().setSelectedIndex(index);
                }
                toc.setTransparent((Boolean)info.get("wmsTransparency"));
                List l = (List)info.get("styles");
                if (l != null && l.size() > 0) {
                    toc.setStyleSelections(l);
                }
                if ((v = (Vector)info.get("dimensions")) != null) {
                    toc.setDimensions(v);
                }
                if ((sz = (Dimension)info.get("fixedSize")) != null) {
                    toc.setFixedSize(sz);
                }
                toc.refreshInfo();
                this.applied = false;
                return toc;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "error_comunicacion_servidor", "Error", 0);
            }
        }
        return null;
    }

    public JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.m_actionListener = new CommandListener(this);
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new FlowLayout(2));
            this.buttonsPanel.setName("buttonPanel");
            this.buttonsPanel.add(this.getBtnOk());
            this.buttonsPanel.add(this.getBtnApply());
            this.buttonsPanel.add(this.getBtnCancel());
        }
        return this.buttonsPanel;
    }

    public JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton("ok");
            this.btnOk.setText(PluginServices.getText((Object)this, (String)"ok"));
            this.btnOk.setActionCommand("OK");
            this.btnOk.addActionListener(this.m_actionListener);
        }
        return this.btnOk;
    }

    public JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton("apply");
            this.btnApply.setText(PluginServices.getText((Object)this, (String)"apply"));
            this.btnApply.setEnabled(false);
            this.btnApply.setActionCommand("APPLY");
            this.btnApply.addActionListener(this.m_actionListener);
        }
        return this.btnApply;
    }

    public JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton("cancel");
            this.btnCancel.setText(PluginServices.getText((Object)this, (String)"cancel"));
            this.btnCancel.setActionCommand("CANCEL");
            this.btnCancel.addActionListener(this.m_actionListener);
        }
        return this.btnCancel;
    }

    private FLayers mergeFLayers(FLayers group1, FLayers group2) {
        for (int i = 0; i < group2.getLayersCount(); ++i) {
            FLayer layer = group2.getLayer(i);
            if (group1.getLayer(layer.getName()) != null) continue;
            group1.addLayer(layer);
        }
        return group1;
    }

    public WindowInfo getWindowInfo() {
        if (this.m_ViewInfo == null) {
            this.m_ViewInfo = new WindowInfo(9);
            this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"fit_WMS_layer"));
            this.m_ViewInfo.setWidth(500);
            this.m_ViewInfo.setHeight(500);
        }
        return this.m_ViewInfo;
    }

    public void close() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private class CommandListener
    implements ActionListener {
        public CommandListener(WMSPropsDialog tp) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "CANCEL") {
                WMSPropsDialog.this.close();
            } else {
                ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setFormat(WMSPropsDialog.this.wmsParamsTabbedPane.getFormat());
                ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setInfoFormat(WMSPropsDialog.this.wmsParamsTabbedPane.getInfoFormat());
                try {
                    if (!WMSPropsDialog.this.wmsParamsTabbedPane.getDisagregatedLayers()) {
                        ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setLayerQuery(WMSPropsDialog.this.wmsParamsTabbedPane.getLayersQuery());
                    }
                    ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setInfoLayerQuery(WMSPropsDialog.this.wmsParamsTabbedPane.getQueryableLayerQuery());
                    ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setSRS(WMSPropsDialog.this.wmsParamsTabbedPane.getSRS());
                    ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setName(WMSPropsDialog.this.wmsParamsTabbedPane.getLayerName());
                    ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setWmsTransparency(WMSPropsDialog.this.wmsParamsTabbedPane.getTransparency());
                    ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setStyles(WMSPropsDialog.this.wmsParamsTabbedPane.getStyles());
                    ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setDimensions(WMSPropsDialog.this.wmsParamsTabbedPane.getDimensions());
                    ((FLyrWMS)WMSPropsDialog.this.fLayer).getParameters().setFixedSize(WMSPropsDialog.this.wmsParamsTabbedPane.getFixedSize());
                    FLayers parent = WMSPropsDialog.this.fLayer.getParentLayer();
                    if (e.getActionCommand() == "APPLY") {
                        MapControl mapCtrl = null;
                        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
                        for (int i = 0; i < w.length; ++i) {
                            MapContext mapContext;
                            if (!(w[i] instanceof AbstractViewPanel) || (mapContext = ((AbstractViewPanel)w[i]).getMapControl().getMapContext()) != WMSPropsDialog.this.fLayer.getMapContext()) continue;
                            mapCtrl = ((AbstractViewPanel)w[i]).getMapControl();
                        }
                        if (parent != null) {
                            if (WMSPropsDialog.this.wmsParamsTabbedPane.getLayer() instanceof FLayers) {
                                mapCtrl.getMapContext().getLayers().replaceLayer(parent.getName(), (FLayer)WMSPropsDialog.this.mergeFLayers(parent, (FLayers)WMSPropsDialog.this.wmsParamsTabbedPane.getLayer()));
                            }
                        } else {
                            mapCtrl.getMapContext().getLayers().replaceLayer(WMSPropsDialog.this.fLayer.getName(), WMSPropsDialog.this.wmsParamsTabbedPane.getLayer());
                        }
                        mapCtrl.getMapContext().invalidate();
                        WMSPropsDialog.this.applied = true;
                        WMSPropsDialog.this.getBtnApply().setEnabled(!WMSPropsDialog.this.applied);
                    }
                    if (e.getActionCommand() == "OK") {
                        if (!WMSPropsDialog.this.applied) {
                            AbstractViewPanel vista = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
                            MapControl mapCtrl = vista.getMapControl();
                            if (parent != null) {
                                if (WMSPropsDialog.this.wmsParamsTabbedPane.getLayer() instanceof FLayers) {
                                    mapCtrl.getMapContext().getLayers().replaceLayer(parent.getName(), (FLayer)WMSPropsDialog.this.mergeFLayers(parent, (FLayers)WMSPropsDialog.this.wmsParamsTabbedPane.getLayer()));
                                }
                            } else {
                                mapCtrl.getMapContext().getLayers().replaceLayer(WMSPropsDialog.this.fLayer.getName(), WMSPropsDialog.this.wmsParamsTabbedPane.getLayer());
                            }
                            mapCtrl.getMapContext().invalidate();
                        }
                        WMSPropsDialog.this.close();
                    }
                }
                catch (ConnectionErrorLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (DriverLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (LegendLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (NameLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (ProjectionLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (TypeLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (UnsupportedVersionLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (URLLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (LoadLayerException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
                catch (InitializeException e1) {
                    WMSPropsDialog.this.logger.info("", (Throwable)e1);
                }
            }
        }
    }
}

