/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.wmc;

import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ImportMapContextException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.exceptions.UnsupportedVersionLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.WebMapContextFileChooserAccessory;
import org.gvsig.raster.wms.app.wmsclient.layer.FLyrWMS;
import org.gvsig.raster.wms.app.wmsclient.wmc.WebMapContext;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.gvsig.raster.wms.io.WMSServerExplorerParameters;

public class ImportWebMapContextExtension
extends Extension {
    public static final String WMC_FILECHOOSER_ID = "WMC_FILECHOOSER_ID";
    private String lastPath = null;

    public void initialize() {
        String[] arguments = PluginServices.getArguments();
        if (arguments[arguments.length - 1].toLowerCase().endsWith(".cml")) {
            File wmcFile = new File(arguments[arguments.length - 1]);
            if (!wmcFile.exists()) {
                NotificationManager.addError((String)PluginServices.getText((Object)((Object)this), (String)"could_not_find_web_map_context_file"), (Throwable)new FileNotFoundException());
                return;
            }
            this.readMapContextFile(wmcFile, null);
        }
    }

    public void execute(String actionCommand) {
        if (actionCommand.equals("IMPORT")) {
            JFileChooser fc = new JFileChooser(WMC_FILECHOOSER_ID, this.lastPath);
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".cml");
                }

                @Override
                public String getDescription() {
                    return PluginServices.getText((Object)this, (String)"ogc_mapcontext_file") + " (*.cml)";
                }
            });
            IWindow v = PluginServices.getMDIManager().getActiveWindow();
            String currentViewName = v instanceof AbstractViewPanel ? ((AbstractViewPanel)v).getModel().getName() : null;
            WebMapContextFileChooserAccessory acc = new WebMapContextFileChooserAccessory(currentViewName);
            fc.setAccessory((JComponent)acc);
            fc.setAcceptAllFileFilterUsed(false);
            if (fc.showOpenDialog((Component)PluginServices.getMainFrame()) == 0) {
                File f = fc.getSelectedFile();
                this.readMapContextFile(f, acc.getSelectedView());
                String fileName = f.getAbsolutePath();
                this.lastPath = fileName.substring(0, fileName.lastIndexOf(File.separatorChar));
            }
            Object var2_2 = null;
        }
    }

    private void readMapContextFile(File wmcFile, DefaultViewDocument dstView) {
        WebMapContext wmc = new WebMapContext();
        try {
            wmc.readFile(wmcFile);
        }
        catch (UnsupportedVersionLayerException e) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), e.getMessage(), PluginServices.getText((Object)((Object)this), (String)"unsupported_version"), 0);
            return;
        }
        catch (ImportMapContextException e) {
            if (e.isCritical()) {
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), e.getMessage(), PluginServices.getText((Object)((Object)this), (String)"problems_encountered_while_importing"), 0);
                return;
            }
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), e.getMessage() + "\n\n" + PluginServices.getText((Object)((Object)this), (String)"edit_layer_properties_to_fix_them"), PluginServices.getText((Object)((Object)this), (String)"problems_encountered_while_importing"), 0);
        }
        if (dstView == null) {
            dstView = (DefaultViewDocument)ProjectManager.getInstance().createDocument(ViewManager.TYPENAME);
            dstView.setName(wmc.title);
            dstView.setComment("Created from WebMapContext file: " + wmcFile.getName());
            Project theProject = ProjectManager.getInstance().getCurrentProject();
            theProject.add((Document)dstView);
            DefaultViewPanel v = null;
            v = new DefaultViewPanel((Document)dstView);
            PluginServices.getMDIManager().addWindow((IWindow)v);
        }
        for (int i = 0; i < wmc.layerList.size(); ++i) {
            if (!(wmc.layerList.get(i) instanceof FLyrWMS)) continue;
            FLyrWMS layer = wmc.layerList.get(i);
            WMSDataParameters params = wmc.paramsList.get(i);
            DataManager datamanager = DALLocator.getDataManager();
            try {
                WMSServerExplorerParameters explorerParams = (WMSServerExplorerParameters)datamanager.createServerExplorerParameters(WMSServerExplorer.NAME);
                explorerParams.setHost(params.getURI().getPath());
                WMSServerExplorer explorer = (WMSServerExplorer)datamanager.createServerExplorer((DataServerExplorerParameters)explorerParams);
                layer.setExplorer(explorer);
                params.setOverrideHost(false);
                explorer.connect(null, true);
                params.setOnlineResources((Map)explorer.getOnlineResources());
                layer.setParameters((DataStoreParameters)params);
                Rectangle2D rec = wmc.bBox;
                Envelope envelope = GeometryLocator.getGeometryManager().createEnvelope(rec.getX(), rec.getY(), rec.getMaxX(), rec.getMaxY(), 0);
                dstView.getMapContext().getViewPort().setEnvelope(envelope);
            }
            catch (Exception e) {
                NotificationManager.addInfo((String)(PluginServices.getText((Object)((Object)this), (String)"connect_error") + "\n" + PluginServices.getText((Object)((Object)this), (String)"failed_restoring_online_resource_values") + " [" + new Date(System.currentTimeMillis()).toString() + "]"), (Throwable)e);
            }
            dstView.getMapContext().getLayers().addLayer((FLayer)layer);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }
}

