/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;
import org.gvsig.raster.lib.buffer.impl.exceptions.CopyFromBandException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBand
extends BaseWeakReferencingObservable
implements Band {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBand.class);
    int rows;
    int columns;
    NoData noData;
    private final Object lock = new Object();
    private boolean disposed = false;

    public AbstractBand() {
        if (ToolsLocator.getDisposableManager() != null) {
            ToolsLocator.getDisposableManager().bind((Disposable)this);
        } else {
            logger.warn("Can't retrieve the disposable manager,");
        }
    }

    public Double getAsDouble(int row, int column) {
        Object obj = this.get(row, column);
        if (obj == this.getNoData().getValue()) {
            return null;
        }
        if (!(obj instanceof Number)) {
            return null;
        }
        double value = AbstractBand.valueToDoubleByType(this.getDataType(), obj);
        return value;
    }

    private static double valueToDoubleByType(int dataType, Object obj) {
        double value;
        switch (dataType) {
            case 0: {
                value = 0xFF & ((Number)obj).byteValue();
                break;
            }
            case 2: {
                value = ((Number)obj).shortValue();
                break;
            }
            case 1: {
                value = 0xFFFF & ((Number)obj).shortValue();
                break;
            }
            case 3: {
                value = ((Number)obj).intValue();
                break;
            }
            case 4: {
                value = ((Number)obj).floatValue();
                break;
            }
            case 5: {
                value = ((Number)obj).floatValue();
                break;
            }
            default: {
                value = ((Number)obj).doubleValue();
            }
        }
        return value;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public NoData getNoData() {
        return this.noData;
    }

    public BandInfo getBandInfo() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractBand cloned = (AbstractBand)((Object)super.clone());
        cloned.rows = this.rows;
        cloned.columns = this.columns;
        cloned.noData = (NoData)this.noData.clone();
        try {
            cloned.copyFrom(this);
        }
        catch (BandException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return cloned;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isPaginated() {
        return false;
    }

    public void set(int row, int column, Object value) {
        this.doSet(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected abstract void doSet(int var1, int var2, Object var3);

    public void fill(Object value) {
        this.doFill(value);
        this.notifyObservers((Object)new DefaultBandNotification("fill_band_notification", new Object[]{value}));
    }

    protected abstract void doFill(Object var1);

    protected Object nullValueToNoData(Object value) {
        if (value == null) {
            if (this.getNoData().isDefined()) {
                value = this.getNoData().getValue();
            } else {
                return null;
            }
        }
        return value;
    }

    public void copyFrom(Band source) throws BandException {
        this.doCopyFrom(source);
        this.notifyObservers((Object)new DefaultBandNotification("copy_from_band_notification", new Object[]{source}));
    }

    protected abstract void doCopyFrom(Band var1) throws CopyFromBandException;

    public void copyFrom(Band source, int row, int column) throws BandException {
        this.doCopyFrom(source, row, column);
        this.notifyObservers((Object)new DefaultBandNotification("copy_from_band_notification", new Object[]{source}));
    }

    protected abstract void doCopyFrom(Band var1, int var2, int var3) throws CopyFromBandException;

    public void putRow(int row, Object rowBuffer) {
        this.doPutRow(row, rowBuffer);
        this.notifyObservers((Object)new DefaultBandNotification("put_row_band_notification", new Object[]{row, rowBuffer}));
    }

    protected abstract void doPutRow(int var1, Object var2);

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.disposed && ToolsLocator.getDisposableManager().release((Disposable)this)) {
                try {
                    this.doDispose();
                }
                catch (BaseException ex) {
                    logger.error("Error performing dispose", (Throwable)ex);
                }
                this.disposed = true;
            }
        }
    }

    public void doDispose() throws BaseException {
        this.noData = null;
    }
}

