/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractConvertedTypeBand;

public class ConvertedTypeBandDouble
extends AbstractConvertedTypeBand
implements Band.BandDouble {
    public ConvertedTypeBandDouble(Buffer buffer, Band band) {
        super(buffer, band);
    }

    public double[] createRowBuffer() {
        return new double[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        for (int i = 0; i < this.getColumns(); ++i) {
            ((double[])rowBuffer)[i] = ((Number)this.band.get(row, i)).doubleValue();
        }
    }

    public double getValue(int row, int column) {
        return ((Number)this.get(row, column)).byteValue();
    }

    public void setValue(int row, int column, double value) {
        this.doSet(row, column, new Double(value));
    }

    public int getDataType() {
        return 5;
    }

    public Object get(int row, int column) {
        return ((Number)this.get(row, column)).byteValue();
    }

    @Override
    public NoData getNoData() {
        NoData bandNoData = this.band.getNoData();
        if (bandNoData == null) {
            this.noData = BufferLocator.getBufferManager().createNoData(null, null);
        } else {
            Double value = null;
            Double defaultValue = null;
            Number bandvalue = bandNoData.getValue();
            Number bandDefaultValue = bandNoData.getDefaultValue();
            if (bandvalue != null) {
                value = bandvalue.doubleValue();
            }
            if (bandDefaultValue != null) {
                defaultValue = bandDefaultValue.doubleValue();
            }
            this.noData = BufferLocator.getBufferManager().createNoData((Number)value, (Number)defaultValue);
        }
        return this.noData;
    }
}

