/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;
import org.gvsig.raster.lib.buffer.impl.exceptions.CopyFromBandException;

public class MemoryBandByte
extends AbstractBand
implements Band.BandByte {
    byte[] data;

    public MemoryBandByte(int rows, int columns) {
        this(rows, columns, BufferLocator.getBufferManager().createNoData(null, null));
    }

    public MemoryBandByte(int rows, int columns, NoData noData) {
        this.rows = rows;
        this.columns = columns;
        this.data = new byte[rows * columns];
        this.noData = noData == null ? BufferLocator.getBufferManager().createNoData(null, null) : noData;
    }

    public int getDataType() {
        return 0;
    }

    public Object get(int row, int column) {
        return this.getValue(row, column);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.doSetValue(row, column, (Byte)value);
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        Arrays.fill(this.data, (Byte)value);
    }

    byte[] getData() {
        return this.data;
    }

    @Override
    protected void doCopyFrom(Band source) throws CopyFromBandException {
        if (this.getColumns() == source.getColumns() && this.getRows() == source.getRows()) {
            if (source instanceof MemoryBandByte) {
                System.arraycopy(((MemoryBandByte)source).getData(), 0, this.data, 0, this.getRows() * this.getColumns());
            } else {
                Object rowBuffer = source.createRowBuffer();
                for (int row = 0; row < source.getRows(); ++row) {
                    source.fetchRow(row, rowBuffer);
                    try {
                        System.arraycopy(rowBuffer, 0, this.data, row * this.getColumns(), this.getColumns());
                        continue;
                    }
                    catch (Exception e) {
                        throw new CopyFromBandException(source, this, e);
                    }
                }
            }
        } else {
            throw new CopyFromBandException(source, this);
        }
    }

    @Override
    protected void doCopyFrom(Band source, int row, int column) throws CopyFromBandException {
        if (this.getColumns() >= source.getColumns() + column && this.getRows() >= source.getRows() + row) {
            if (source instanceof MemoryBandByte) {
                for (int r = 0; r < Math.min(this.getRows() - row, source.getRows()); ++r) {
                    System.arraycopy(((MemoryBandByte)source).getData(), r * source.getColumns(), this.data, (r + row) * this.getColumns() + column, Math.min(this.getColumns() - column, source.getColumns()));
                }
            } else {
                Object rowBuffer = source.createRowBuffer();
                for (int r = row; r < Math.min(this.getRows() - row, source.getRows()); ++r) {
                    source.fetchRow(r, rowBuffer);
                    System.arraycopy(rowBuffer, 0, this.data, (r + row) * this.getColumns(), Math.min(this.getColumns() - column, source.getColumns()));
                }
            }
        } else {
            throw new CopyFromBandException(source, this);
        }
    }

    public byte getValue(int row, int column) {
        return this.data[row * this.getColumns() + column];
    }

    public void setValue(int row, int column, byte value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected void doSetValue(int row, int column, byte value) {
        this.data[row * this.getColumns() + column] = value;
    }

    public byte[] createRowBuffer() {
        return new byte[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        System.arraycopy(this.data, row * this.getColumns(), (byte[])rowBuffer, 0, this.getColumns());
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        System.arraycopy((byte[])rowBuffer, 0, this.data, row * this.getColumns(), this.getColumns());
    }

    @Override
    public boolean isPaginated() {
        return false;
    }
}

