/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractPaginatedBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedBandInt
extends AbstractPaginatedBand
implements Band.BandInt {
    private static final Logger logger = LoggerFactory.getLogger(PaginatedBandInt.class);

    public PaginatedBandInt(int rows, int columns, NoData noData, BandPageManager pageManager) {
        super(rows, columns, noData, pageManager);
    }

    public int getDataType() {
        return 3;
    }

    @Override
    protected int getDataSize() {
        return 4;
    }

    public Object get(int row, int column) {
        return this.getValue(row, column);
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, (Integer)value);
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        for (int row = 0; row < this.rows; row += this.rowsPerPage) {
            this.loadPage(row);
            Arrays.fill((int[])this.data.array(), (Integer)value);
        }
    }

    public int getValue(int row, int column) {
        this.loadPage(row);
        return ((IntBuffer)this.data).get((row - this.firstRowOfPage) * this.columns + column);
    }

    public void setValue(int row, int column, int value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, value}));
    }

    protected void doSetValue(int row, int column, int value) {
        this.loadPage(row);
        ((IntBuffer)this.data).put((row - this.firstRowOfPage) * this.columns + column, value);
    }

    public int[] createRowBuffer() {
        return new int[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        this.loadPage(row);
        int[] source = (int[])this.data.array();
        int[] target = (int[])rowBuffer;
        System.arraycopy(source, (row - this.firstRowOfPage) * this.columns, target, 0, this.columns);
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        this.loadPage(row);
        int[] source = (int[])rowBuffer;
        int[] target = (int[])this.data.array();
        System.arraycopy(source, 0, target, (row - this.firstRowOfPage) * this.columns, this.columns);
    }

    @Override
    protected void loadPage(int row) {
        if (this.data == null) {
            this.data = IntBuffer.allocate(this.calculateBufferSizeToAllocate(this.rows, this.columns));
        }
        super.loadPage(row);
    }
}

