/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.OperationManager;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.InvalidLookupParametersException;
import org.gvsig.raster.lib.buffer.api.operations.Operation;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.operations.OperationList;
import org.gvsig.raster.lib.buffer.api.operations.OperationListEntry;
import org.gvsig.raster.lib.buffer.impl.operations.DefaultOperationListNotification;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationList
extends BaseWeakReferencingObservable
implements OperationList {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOperationList.class);
    public static final String PERSISTENT_NAME = "OperationListPersistence";
    public static final String PERSISTENT_DESCRIPTION = "Persistence definition of operation list";
    private static final String OPERATIONS_PERSISTENCE_FIELD = "operations";
    private List<OperationListEntry> operations = new ArrayList<OperationListEntry>();
    private DynObject defaultParameters = null;

    public int size() {
        return this.operations.size();
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public boolean contains(Object o) {
        return this.operations.contains(o);
    }

    public Iterator<OperationListEntry> iterator() {
        return this.operations.iterator();
    }

    public Object[] toArray() {
        return this.operations.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.operations.toArray(a);
    }

    public boolean add(OperationListEntry e) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        boolean result = this.operations.add(e);
        this.notifyObservers((Object)new DefaultOperationListNotification("added_entry_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public boolean remove(Object o) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        boolean result = this.operations.remove(o);
        this.notifyObservers((Object)new DefaultOperationListNotification("removed_entry_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public boolean containsAll(Collection<?> c) {
        return this.operations.containsAll(c);
    }

    public boolean addAll(Collection<? extends OperationListEntry> c) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        boolean result = this.operations.addAll(c);
        this.notifyObservers((Object)new DefaultOperationListNotification("added_entries_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public boolean addAll(int index, Collection<? extends OperationListEntry> c) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        boolean result = this.operations.addAll(index, c);
        this.notifyObservers((Object)new DefaultOperationListNotification("added_entries_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public boolean removeAll(Collection<?> c) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        boolean result = this.operations.removeAll(c);
        this.notifyObservers((Object)new DefaultOperationListNotification("removed_entries_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public boolean retainAll(Collection<?> c) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        boolean result = this.operations.retainAll(c);
        this.notifyObservers((Object)new DefaultOperationListNotification("retained_entries_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public void clear() {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        this.operations.clear();
        this.notifyObservers((Object)new DefaultOperationListNotification("clear_entries_notification", new Object[]{oldOperations, this.operations}));
    }

    public OperationListEntry get(int index) {
        return this.operations.get(index);
    }

    public OperationListEntry set(int index, OperationListEntry element) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        OperationListEntry result = this.operations.set(index, element);
        this.notifyObservers((Object)new DefaultOperationListNotification("setted_entry_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public void add(int index, OperationListEntry element) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        if (index < 0) {
            index = this.operations.size() + index;
        }
        this.operations.add(index, element);
        this.notifyObservers((Object)new DefaultOperationListNotification("added_entry_notification", new Object[]{oldOperations, this.operations}));
    }

    public OperationListEntry remove(int index) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        OperationListEntry result = this.operations.remove(index);
        this.notifyObservers((Object)new DefaultOperationListNotification("removed_entry_notification", new Object[]{oldOperations, this.operations}));
        return result;
    }

    public int indexOf(Object o) {
        return this.operations.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.operations.lastIndexOf(o);
    }

    public ListIterator<OperationListEntry> listIterator() {
        return this.operations.listIterator();
    }

    public ListIterator<OperationListEntry> listIterator(int index) {
        return this.operations.listIterator(index);
    }

    public List<OperationListEntry> subList(int fromIndex, int toIndex) {
        return this.operations.subList(fromIndex, toIndex);
    }

    public Buffer execute(SimpleTaskStatus status, Buffer buffer) throws BufferOperationException {
        Buffer tmpBuffer1 = buffer;
        DisposeUtils.bind((Disposable)tmpBuffer1);
        int i = 0;
        for (OperationListEntry operationListEntry : this.operations) {
            Operation operation = operationListEntry.getOperation();
            DynObject parameters = operationListEntry.getParameters();
            OperationFactory factory = operation.getFactory();
            if (operationListEntry.isActive()) {
                DynField[] fields;
                if (factory.isApplicable(tmpBuffer1).equals((Object)OperationFactory.Applicable.NO)) {
                    throw new IllegalArgumentException("The operation is not applicable to the input buffer");
                }
                DynClass paramsDefinition = parameters.getDynClass();
                for (DynField field1 : fields = paramsDefinition.getDynFields()) {
                    DynField_v2 field = (DynField_v2)field1;
                    String name = operationListEntry.getLookpupParameterName(field.getName());
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = (String)field.getTags().get("lookupParameter");
                    }
                    if (StringUtils.isEmpty((CharSequence)name)) continue;
                    parameters.setDynValue(field.getName(), this.getParameterValue(name, i));
                }
                Buffer tmpBuffer2 = operation.execute(status, tmpBuffer1, parameters);
                DisposeUtils.dispose((Disposable)tmpBuffer1);
                tmpBuffer1 = tmpBuffer2;
            }
            ++i;
        }
        return tmpBuffer1;
    }

    public void add(Operation operation, DynObject parameters) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        OperationManager operationManager = (OperationManager)BufferLocator.getBufferManager();
        OperationListEntry entry = operationManager.createOperationListEntry(operation, parameters);
        this.operations.add(entry);
        this.notifyObservers((Object)new DefaultOperationListNotification("added_entry_notification", new Object[]{oldOperations, this.operations}));
    }

    public void add(int index, Operation operation, DynObject parameters) {
        ArrayList<OperationListEntry> oldOperations = this.cloneOperations();
        OperationManager operationManager = (OperationManager)BufferLocator.getBufferManager();
        OperationListEntry entry = operationManager.createOperationListEntry(operation, parameters);
        this.operations.add(index, entry);
        this.notifyObservers((Object)new DefaultOperationListNotification("added_entry_notification", new Object[]{oldOperations, this.operations}));
    }

    public void removeIfExists(String name) {
        int removed = 0;
        int size = this.size();
        Iterator<OperationListEntry> iterator = this.iterator();
        while (iterator.hasNext()) {
            OperationListEntry entry = iterator.next();
            Operation operation = entry.getOperation();
            if (!operation.getFactory().getName().equals(name)) continue;
            iterator.remove();
            ++removed;
        }
        if (this.size() != size - removed) {
            LOG.warn("NO SE HAN ELIMINADO CORRECTAMENTE LAS ENTRADAS DE LA OPERATION_LIST.");
        }
    }

    public Object getParameterValue(String name) {
        int size = this.operations.size();
        return this.getParameterValue(name, size);
    }

    private Object getParameterValue(String name, int index) {
        if (index < 0) {
            index = this.operations.size() + index;
        }
        ListIterator<OperationListEntry> iterator = this.operations.listIterator(index);
        Object result = null;
        while (iterator.hasPrevious()) {
            OperationListEntry operationListEntry = iterator.previous();
            if (operationListEntry != null && operationListEntry.isActive()) {
                DynObject parameters = operationListEntry.getParameters();
                if (parameters.getDynClass().getDynField(name) == null) continue;
                result = parameters.getDynValue(name);
                break;
            }
            LOG.warn("***** THE ENTRY IS NULL *****");
        }
        if (result == null && this.defaultParameters != null && this.defaultParameters.getDynClass().getDynField(name) != null) {
            result = this.defaultParameters.getDynValue(name);
        }
        return result;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(OPERATIONS_PERSISTENCE_FIELD, this.operations);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.operations = new ArrayList<OperationListEntry>();
        Iterator it = state.getIterator(OPERATIONS_PERSISTENCE_FIELD);
        while (it.hasNext()) {
            OperationListEntry operationListEntry = (OperationListEntry)it.next();
            this.add(operationListEntry);
        }
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultOperationList.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldList(OPERATIONS_PERSISTENCE_FIELD).setMandatory(false).setClassOfItems(OperationListEntry.class);
        }
    }

    public List<String> getAvailableParameterNames() {
        HashSet<String> result = new HashSet<String>();
        for (OperationListEntry operationListEntry : this.operations) {
            DynObject parameters = operationListEntry.getParameters();
            DynField[] dynFields = parameters.getDynClass().getDynFields();
            for (int i = 0; i < dynFields.length; ++i) {
                result.add(dynFields[i].getName());
            }
        }
        if (this.defaultParameters != null) {
            DynField[] dynFields;
            for (DynField dynField : dynFields = this.defaultParameters.getDynClass().getDynFields()) {
                result.add(dynField.getName());
            }
        }
        return new ArrayList<String>(result);
    }

    public void setDefaultParameters(DynObject parameters) {
        this.defaultParameters = parameters;
    }

    public void validateLookupParameters() throws InvalidLookupParametersException {
        ArrayList<InvalidLookupParametersException.Problem> problems = new ArrayList<InvalidLookupParametersException.Problem>();
        ListIterator<OperationListEntry> iterator = this.operations.listIterator();
        int i = this.operations.size();
        while (iterator.hasPrevious()) {
            OperationListEntry operationListEntry = iterator.previous();
            Operation operation = operationListEntry.getOperation();
            DynObject parameters = operationListEntry.getParameters();
            OperationFactory factory = operation.getFactory();
            if (operationListEntry.isActive()) {
                DynField[] fields;
                DynClass paramsDefinition = parameters.getDynClass();
                for (DynField field1 : fields = paramsDefinition.getDynFields()) {
                    DynField_v2 field = (DynField_v2)field1;
                    String name = operationListEntry.getLookpupParameterName(field.getName());
                    if (!StringUtils.isEmpty((CharSequence)name)) {
                        name = (String)field.getTags().get("lookupParameter");
                    }
                    if (StringUtils.isEmpty((CharSequence)name) || this.getParameterValue(name, i) != null) continue;
                    InvalidLookupParametersException.Problem problem = new InvalidLookupParametersException.Problem(factory.getName(), field.getName(), name);
                    problems.add(problem);
                }
            }
            --i;
        }
        if (!problems.isEmpty()) {
            throw new InvalidLookupParametersException(problems);
        }
    }

    private ArrayList<OperationListEntry> cloneOperations() {
        ArrayList<OperationListEntry> clonedOperations = null;
        if (this.operations != null) {
            try {
                clonedOperations = new ArrayList<OperationListEntry>(this.operations.size());
                for (int i = 0; i < this.operations.size(); ++i) {
                    clonedOperations.add((OperationListEntry)this.operations.get(i).clone());
                }
            }
            catch (CloneNotSupportedException e) {
                LOG.warn("Can't clone operation list", (Throwable)e);
            }
        }
        return clonedOperations;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultOperationList cloned = new DefaultOperationList();
        if (this.operations != null) {
            for (int i = 0; i < this.operations.size(); ++i) {
                cloned.add((OperationListEntry)this.operations.get(i).clone());
            }
        }
        return cloned;
    }
}

