/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.operations.median;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractSpecifiedBandsOperation;
import org.gvsig.tools.locator.LocatorException;

public class MedianOperation
extends AbstractSpecifiedBandsOperation {
    public static String SIDE_WINDOW_PARAM = "side_window";
    private Statistics statistics;
    private int sideWindow;
    private RowProcessor[] rowProcessors;
    private int halfSideWindow;

    public MedianOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        this.sideWindow = (Integer)this.getParameter(SIDE_WINDOW_PARAM, 3);
        this.halfSideWindow = this.sideWindow / 2;
        int bands = this.getInputBuffer().getBandCount();
        NoData[] noData = this.getInputBuffer().getBandNoData();
        if (this.mustCopyUnprocessedBands()) {
            try {
                this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getInputBuffer().getBandTypes(), this.getInputBuffer().getBandNoData(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
            }
            catch (CreateEnvelopeException | BufferException | LocatorException e) {
                throw new ProcessingOperationException(e);
            }
        }
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getProcessableBandTypesAsArray(), this.getProcessableBandNoDatasAsArray(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (CreateEnvelopeException | BufferException | LocatorException e) {
            throw new ProcessingOperationException(e);
        }
        this.rowProcessors = new RowProcessor[bands];
        block12: for (int band = 0; band < noData.length; ++band) {
            if (!this.isProcessableBand(band)) continue;
            int bandType = this.getInputBuffer().getBand(band).getDataType();
            switch (bandType) {
                case 0: {
                    this.rowProcessors[band] = new ByteRowProcessor(band);
                    continue block12;
                }
                case 1: {
                    this.rowProcessors[band] = new UShortRowProcessor(band);
                    continue block12;
                }
                case 2: {
                    this.rowProcessors[band] = new ShortRowProcessor(band);
                    continue block12;
                }
                case 3: {
                    this.rowProcessors[band] = new IntRowProcessor(band);
                    continue block12;
                }
                case 4: {
                    this.rowProcessors[band] = new FloatRowProcessor(band);
                    continue block12;
                }
                case 5: {
                    this.rowProcessors[band] = new DoubleRowProcessor(band);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type of band '" + band + "'");
                }
            }
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        for (int band = 0; band < this.getInputBuffer().getBandCount(); ++band) {
            if (this.getBandsToProcess().contains(band)) {
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    ArrayList<Object> bundle = new ArrayList<Object>();
                    for (int r = Math.max(row - this.halfSideWindow, 0); r <= Math.min(row + this.halfSideWindow, this.getInputBuffer().getRows() - 1); ++r) {
                        Object bundleRow = bufferBand.createRowBuffer();
                        bufferBand.fetchRow(row, bundleRow);
                        bundle.add(bundleRow);
                    }
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    this.rowProcessors[band].processRow(rowBuffer, bundle, outputRowBuffer);
                    outputBufferBand.putRow(row, outputRowBuffer);
                }
                continue;
            }
            if (!this.mustCopyUnprocessedBands()) continue;
            try {
                this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private class DoubleRowProcessor
    extends AbstractRowProcessor {
        public DoubleRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputDoubleRow = (Number[])inputRow;
            double[] outputDoubleRow = (double[])outputRow;
            for (int i = 0; i < inputDoubleRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (double[] dArray : bundleRow) {
                    for (int c = Math.max(i - MedianOperation.this.halfSideWindow, 0); c <= Math.min(i + MedianOperation.this.halfSideWindow, inputDoubleRow.length - 1); ++c) {
                        Double value = dArray[c];
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputDoubleRow[i] = this.processValue(inputDoubleRow[i], kernel).floatValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            double temp0;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (double)((Double)value);
            }
            Collections.sort(kernel, new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return ((Double)o1).compareTo((Double)o2);
                }
            });
            int n = kernel.size();
            int temp = n / 2;
            if (n % 2 == 0) {
                int pos = temp;
                temp0 = (kernel.get(pos).doubleValue() + kernel.get(pos + 1).doubleValue()) / 2.0;
            } else {
                int pos = (int)((double)temp + 0.5);
                temp0 = kernel.get(pos).doubleValue();
            }
            return temp0;
        }
    }

    private class FloatRowProcessor
    extends AbstractRowProcessor {
        public FloatRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputFloatRow = (Number[])inputRow;
            float[] outputFloatRow = (float[])outputRow;
            for (int i = 0; i < inputFloatRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (float[] fArray : bundleRow) {
                    for (int c = Math.max(i - MedianOperation.this.halfSideWindow, 0); c <= Math.min(i + MedianOperation.this.halfSideWindow, inputFloatRow.length - 1); ++c) {
                        Float value = Float.valueOf(Float.valueOf(fArray[c]).floatValue());
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputFloatRow[i] = this.processValue(inputFloatRow[i], kernel).floatValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            double temp0;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return Float.valueOf(((Float)value).floatValue());
            }
            Collections.sort(kernel, new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return ((Double)o1).compareTo((Double)o2);
                }
            });
            int n = kernel.size();
            int temp = n / 2;
            if (n % 2 == 0) {
                int pos = temp;
                temp0 = (kernel.get(pos).doubleValue() + kernel.get(pos + 1).doubleValue()) / 2.0;
            } else {
                int pos = (int)((double)temp + 0.5);
                temp0 = kernel.get(pos).doubleValue();
            }
            return Float.valueOf(new Double(temp0).floatValue());
        }
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        public IntRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputIntRow = (Number[])inputRow;
            int[] outputIntRow = (int[])outputRow;
            for (int i = 0; i < inputIntRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (int[] nArray : bundleRow) {
                    for (int c = Math.max(i - MedianOperation.this.halfSideWindow, 0); c <= Math.min(i + MedianOperation.this.halfSideWindow, inputIntRow.length - 1); ++c) {
                        Integer value = nArray[c];
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputIntRow[i] = this.processValue(inputIntRow[i], kernel).intValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            double temp0;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (int)((Integer)value);
            }
            Collections.sort(kernel, new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return ((Integer)o1).compareTo((Integer)o2);
                }
            });
            int n = kernel.size();
            int temp = n / 2;
            if (n % 2 == 0) {
                int pos = temp;
                temp0 = (double)(kernel.get(pos).intValue() + kernel.get(pos + 1).intValue()) / 2.0;
            } else {
                int pos = (int)((double)temp + 0.5);
                temp0 = kernel.get(pos).intValue();
            }
            return new Double(temp0).intValue();
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        public UShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            short[] outputShortRow = (short[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (short[] sArray : bundleRow) {
                    for (int c = Math.max(i - MedianOperation.this.halfSideWindow, 0); c <= Math.min(i + MedianOperation.this.halfSideWindow, inputShortRow.length - 1); ++c) {
                        Integer value = 0xFFFF & Short.valueOf(sArray[c]);
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputShortRow[i] = this.processValue(inputShortRow[i], kernel).shortValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            double temp0;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (short)((Short)value);
            }
            Collections.sort(kernel, new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return o1.intValue() - o2.intValue();
                }
            });
            int n = kernel.size();
            int temp = n / 2;
            if (n % 2 == 0) {
                int pos = temp;
                temp0 = (double)(kernel.get(pos).intValue() + kernel.get(pos + 1).intValue()) / 2.0;
            } else {
                int pos = (int)((double)temp + 0.5);
                temp0 = kernel.get(pos).intValue();
            }
            return (short)(new Double(temp0).intValue() & 0xFFFF);
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        public ShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            Number[] inputShortRow = (Number[])inputRow;
            short[] outputShortRow = (short[])outputRow;
            for (int i = 0; i < inputShortRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (short[] sArray : bundleRow) {
                    for (int c = Math.max(i - MedianOperation.this.halfSideWindow, 0); c <= Math.min(i + MedianOperation.this.halfSideWindow, inputShortRow.length - 1); ++c) {
                        Short value = sArray[c];
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                        kernel.add(value);
                    }
                }
                outputShortRow[i] = this.processValue(inputShortRow[i], kernel).shortValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            double temp0;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (short)((Short)value);
            }
            Collections.sort(kernel, new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return ((Short)o1).compareTo((Short)o2);
                }
            });
            int n = kernel.size();
            int temp = n / 2;
            if (n % 2 == 0) {
                int pos = temp;
                temp0 = (double)(kernel.get(pos).intValue() + kernel.get(pos + 1).intValue()) / 2.0;
            } else {
                int pos = (int)((double)temp + 0.5);
                temp0 = kernel.get(pos).intValue();
            }
            return (short)new Double(temp0).intValue();
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, List<Object> bundleRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                ArrayList<Number> kernel = new ArrayList<Number>();
                for (byte[] byArray : bundleRow) {
                    for (int c = Math.max(i - MedianOperation.this.halfSideWindow, 0); c <= Math.min(i + MedianOperation.this.halfSideWindow, inputByteRow.length - 1); ++c) {
                        Integer value = 0xFF & Byte.valueOf(byArray[c]);
                        if (this.noData.isDefined() && this.noData.getValue().equals(value)) continue;
                        kernel.add(value);
                    }
                }
                outputByteRow[i] = this.processValue(inputByteRow[i], kernel).byteValue();
            }
        }

        @Override
        public Number processValue(Number value, List<Number> kernel) {
            double temp0;
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (byte)((Byte)value);
            }
            Collections.sort(kernel, new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return o1.intValue() - o2.intValue();
                }
            });
            int n = kernel.size();
            int temp = n / 2;
            if (n % 2 == 0) {
                int pos = temp;
                temp0 = (double)(kernel.get(pos).intValue() + kernel.get(pos + 1).intValue()) / 2.0;
            } else {
                int pos = (int)((double)temp + 0.5);
                temp0 = kernel.get(pos).intValue();
            }
            return (byte)(new Double(temp0).intValue() & 0xFF);
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        int band;
        NoData noData;

        public AbstractRowProcessor(int band) {
            this.band = band;
            this.noData = MedianOperation.this.getInputBuffer().getBand(band).getNoData();
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, List<Object> var2, Object var3);

        public Number processValue(Number var1, List<Number> var2);
    }
}

