/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramBand;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramClass;
import org.gvsig.raster.lib.buffer.impl.statistics.DefaultHistogramClass;

public class DefaultHistogramBand
implements HistogramBand {
    Band band;
    List<HistogramClass> histogramClasses;

    public DefaultHistogramBand(Band band) {
        this.band = band;
        this.histogramClasses = new ArrayList<HistogramClass>();
    }

    public DefaultHistogramBand(Band band, List<HistogramClass> histogramClasses) {
        this.band = band;
        this.histogramClasses = histogramClasses;
        Collections.sort(this.histogramClasses);
    }

    public long getNumValues() {
        long count = 0L;
        for (HistogramClass histogramClass : this.histogramClasses) {
            count += histogramClass.getValue();
        }
        return count;
    }

    public int getDataType() {
        return this.band.getDataType();
    }

    public long getHistogramValue(double value) {
        HistogramClass histogramClass = this.getHistogramClass(value);
        if (histogramClass == null) {
            return 0L;
        }
        return histogramClass.getValue();
    }

    private HistogramClass getHistogramClass(double value) {
        for (HistogramClass histogramClass : this.histogramClasses) {
            if (!histogramClass.isIn(value)) continue;
            return histogramClass;
        }
        if (this.histogramClasses.size() == 0) {
            return null;
        }
        HistogramClass lastHistogramClass = this.histogramClasses.get(this.histogramClasses.size() - 1);
        if (lastHistogramClass.getMax() == value) {
            return lastHistogramClass;
        }
        return null;
    }

    public boolean union(HistogramBand hist) {
        int i;
        if (this.getNumClasses() == hist.getNumClasses()) {
            for (i = 0; i < this.histogramClasses.size(); ++i) {
                if (this.getIntervalMin(i) == hist.getIntervalMin(i) && this.getIntervalMax(i) == hist.getIntervalMax(i)) continue;
                return false;
            }
        } else {
            return false;
        }
        for (i = 0; i < this.histogramClasses.size(); ++i) {
            this.histogramClasses.get(i).increment(hist.getValueCount(i));
        }
        return true;
    }

    public long[] getFrequencies() {
        int size;
        Integer dataType = this.getDataType();
        switch (dataType) {
            case 0: {
                int rangeMin = 0;
                int rangeMax = 255;
                size = 256;
                break;
            }
            case 2: {
                int rangeMin = Short.MIN_VALUE;
                int rangeMax = Short.MAX_VALUE;
                size = rangeMax - rangeMin + 1;
                break;
            }
            case 1: {
                int rangeMin = 0;
                int rangeMax = Math.abs(Short.MIN_VALUE) + Short.MAX_VALUE;
                size = rangeMax - rangeMin + 1;
                break;
            }
            case 3: {
                int rangeMin = Integer.MIN_VALUE;
                int rangeMax = Integer.MAX_VALUE;
                size = rangeMax - rangeMin + 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't process type '" + dataType + "'");
            }
        }
        long[] table = new long[size];
        for (int j = 0; j < table.length; ++j) {
            table[j] = this.getHistogramValue(j);
        }
        return table;
    }

    public int getNumClasses() {
        return this.histogramClasses.size();
    }

    public long getValueCount(int interval) {
        return this.histogramClasses.get(interval).getValue();
    }

    public double getIntervalMin(int interval) {
        return this.histogramClasses.get(interval).getMin();
    }

    public double getIntervalMax(int interval) {
        return this.histogramClasses.get(interval).getMax();
    }

    public double getMedian() {
        double halfn = (double)this.getNumValues() / 2.0;
        return this.getUmpteenth(halfn);
    }

    private double getUmpteenth(double n) {
        long contValues = 0L;
        if (this.getDataType() == 4 || this.getDataType() == 5) {
            for (int i = 0; i < this.histogramClasses.size(); ++i) {
                HistogramClass histogramClass = this.histogramClasses.get(i);
                long anteriorCont = contValues;
                if (n == (double)contValues) {
                    return histogramClass.getMin();
                }
                if (n == (double)(contValues += histogramClass.getValue())) {
                    return histogramClass.getMax();
                }
                if (!(n < (double)contValues)) continue;
                double nM = n;
                double nA = anteriorCont;
                double fI = histogramClass.getValue();
                double interval = histogramClass.getMax() - histogramClass.getMin();
                double min = histogramClass.getMin();
                double median = min + (nM - nA) / fI * interval;
                return median;
            }
        } else {
            double antMax = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.histogramClasses.size(); ++i) {
                HistogramClass histogramClass = this.histogramClasses.get(i);
                if (n == (double)contValues) {
                    return (histogramClass.getMin() + antMax) / 2.0;
                }
                if (n < (double)(contValues += histogramClass.getValue())) {
                    return histogramClass.getMin();
                }
                antMax = histogramClass.getMax();
            }
        }
        return 0.0;
    }

    public void addValue(double value) {
        HistogramClass histogramClass = this.getHistogramClass(value);
        if (histogramClass == null) {
            histogramClass = new DefaultHistogramClass(value, value);
            histogramClass.setValue(1L);
            this.histogramClasses.add(histogramClass);
            Collections.sort(this.histogramClasses);
        } else {
            histogramClass.increment(1L);
        }
    }

    public double[] getTailTrimValue(double percent) {
        if (percent > 100.0 || percent < 0.0) {
            StringBuilder builder = new StringBuilder();
            builder.append("Percent ");
            builder.append(percent);
            builder.append(" is out of range [0,100]");
            throw new IllegalArgumentException(builder.toString());
        }
        long lowPosition = Math.round((double)this.getNumValues() * percent / 100.0);
        long upperPosition = Math.round((double)this.getNumValues() * (100.0 - percent) / 100.0);
        double[] result = new double[]{this.getUmpteenth(lowPosition), this.getUmpteenth(upperPosition)};
        return result;
    }

    public double[] getTailTrimValue(int pos) {
        long lowPosition = pos;
        long upperPosition = this.getNumValues() - (long)pos;
        double[] result = new double[]{this.getUmpteenth(lowPosition), this.getUmpteenth(upperPosition)};
        return result;
    }
}

