/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.IOExceptionWithStatus;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProvider;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSProvider;
import org.gvsig.raster.wmts.io.WMTSServerExplorerParameters;
import org.gvsig.raster.wmts.ogc.WMTSClient;
import org.gvsig.raster.wmts.ogc.WMTSOGCLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSServerExplorer
extends AbstractDataServerExplorer
implements RasterDataServerExplorer,
DataServerExplorerProvider {
    public static final String NAME = WMTSProvider.NAME;
    private WMTSClient ogcClient = null;
    private static final Logger logger = LoggerFactory.getLogger(WMTSServerExplorer.class);

    public WMTSServerExplorer(WMTSServerExplorerParameters parameters, DataServerExplorerProviderServices services) throws InitializeException {
        super((DataServerExplorerParameters)parameters, services);
    }

    public String getDataStoreProviderName() {
        return WMTSProvider.NAME;
    }

    public String getDescription() {
        return WMTSProvider.DESCRIPTION;
    }

    public boolean add(String provider, NewDataStoreParameters parameters, boolean overwrite) throws DataException {
        return false;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canAdd(String storeName) throws DataException {
        return false;
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        return null;
    }

    public List<String> getDataStoreProviderNames() {
        return null;
    }

    public WMTSServerExplorerParameters getParameters() {
        return (WMTSServerExplorerParameters)super.getParameters();
    }

    public List<DataStoreParameters> list() throws DataException {
        return null;
    }

    public List<DataStoreParameters> list(int mode) throws DataException {
        return null;
    }

    public void remove(DataStoreParameters parameters) throws DataException {
    }

    public String getProviderName() {
        return WMTSProvider.NAME;
    }

    public DataStoreParameters getStoredParameters() {
        DataManager manager = DALLocator.getDataManager();
        WMTSDataParameters wmtsParams = null;
        try {
            wmtsParams = (WMTSDataParameters)manager.createStoreParameters(this.getDataStoreProviderName());
            String host = this.getParameters().getHost();
            try {
                wmtsParams.setURI(new URI(host));
            }
            catch (URISyntaxException e) {
                logger.warn("Can't create URI from " + host, (Throwable)e);
            }
            wmtsParams.setOGCClient(this.getOGCClient());
            if (WMTSProvider.TILED) {
                TileDataParameters tileParams = (TileDataParameters)manager.createStoreParameters("Tile Store");
                tileParams.setDataParameters((DataParameters)wmtsParams);
                return tileParams;
            }
        }
        catch (InitializeException e) {
            logger.warn("Can't get DataStoreParameters from WMTSServerExplorer", (Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            logger.warn("Can't get DataStoreParameters from WMTSServerExplorer", (Throwable)e);
        }
        return wmtsParams;
    }

    public void connect(ICancellable cancellable) throws ConnectException {
        URL url = null;
        boolean override = false;
        try {
            url = new URL(this.getParameters().getHost());
        }
        catch (Exception e) {
            throw new ConnectException("Malformed URL", (Throwable)e);
        }
        try {
            this.ogcClient = WMTSOGCLocator.getManager().createWMTSClient(url.toString());
            this.ogcClient.setForceChangeAxisOrder(this.getParameters().isLongitudeFirst());
            if (!this.ogcClient.connect(override, cancellable)) {
                throw new ConnectException("Error connecting");
            }
        }
        catch (IOException e) {
            throw new ConnectException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isHostReachable(int timeout) {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        URL url = null;
        try {
            url = new URL(this.getParameters().getHost());
            File file = downloader.downloadFile(url, "isHostReachable", ICancellable.DUMB);
        }
        catch (IOExceptionWithStatus e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isHostReachable() {
        return this.isHostReachable(10000);
    }

    public boolean isConnected() {
        return this.ogcClient != null;
    }

    public WMTSClient getOGCClient() {
        return this.ogcClient;
    }

    public String getHost() {
        return this.getParameters().getHost();
    }

    public DataServerExplorerProviderServices getServerExplorerProviderServices() {
        return null;
    }
}

