/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.io.downloader;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.exception.TileBuildException;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSProvider;
import org.gvsig.raster.wmts.ogc.WMTSStatus;
import org.gvsig.raster.wmts.ogc.struct.WMTSTile;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrix;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixLimits;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSet;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSetLink;

public class WMTSCacheStruct
implements CacheStruct {
    private String layerName = null;
    private String serverURL = null;
    private WMTSTileMatrixSet tileMatrixSet = null;
    private List<WMTSTileMatrixLimits> tileMatrixSetLimits = null;
    private double[] pixelSize = null;
    private RasterDataStore store = null;

    public WMTSCacheStruct(RasterDataStore store, WMTSTileMatrixSetLink tileMatrixSetLink) {
        this.store = store;
        this.tileMatrixSet = tileMatrixSetLink.getTileMatrixSet();
        this.tileMatrixSetLimits = tileMatrixSetLink.getTileMatrixLimits();
        this.pixelSize = ((WMTSProvider)store.getProvider()).getPixelSizeByLevel();
        this.serverURL = ((WMTSProvider)store.getProvider()).getURIOfFirstProvider().getPath();
        this.layerName = ((WMTSDataParameters)store.getParameters()).getLayer().getTitle();
    }

    public int getNumberOfLevels() {
        return this.tileMatrixSet.getTileMatrix().size();
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getServerURL() {
        return this.serverURL + this.getDimension();
    }

    public int[] getTileSizeByLevel(int level) {
        return new int[]{((WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level)).getTileWidth(), ((WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level)).getTileHeight()};
    }

    public int getLayerWidthOfTileMatrixByLevel(int level) {
        if (this.tileMatrixSetLimits != null && this.tileMatrixSetLimits.size() > level) {
            WMTSTileMatrixLimits l = this.tileMatrixSetLimits.get(level);
            return l.getMaxTileRow() - l.getMinTileRow();
        }
        WMTSTileMatrix tm = (WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level);
        return (int)tm.getMatrixWidth();
    }

    public int getLayerHeightOfTileMatrixByLevel(int level) {
        if (this.tileMatrixSetLimits != null && this.tileMatrixSetLimits.size() > level) {
            WMTSTileMatrixLimits l = this.tileMatrixSetLimits.get(level);
            return l.getMaxTileCol() - l.getMinTileCol();
        }
        WMTSTileMatrix tm = (WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level);
        return (int)tm.getMatrixHeight();
    }

    public int getLayerInitXTilePositionByLevel(int level) {
        if (this.tileMatrixSetLimits != null && this.tileMatrixSetLimits.size() > level) {
            WMTSTileMatrixLimits l = this.tileMatrixSetLimits.get(level);
            return l.getMinTileCol();
        }
        return 0;
    }

    public int getLayerInitYTilePositionByLevel(int level) {
        if (this.tileMatrixSetLimits != null && this.tileMatrixSetLimits.size() > level) {
            WMTSTileMatrixLimits l = this.tileMatrixSetLimits.get(level);
            return l.getMinTileRow();
        }
        return 0;
    }

    public long getWorldHeightOfTileMatrixByLevel(int level) {
        return ((WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level)).getMatrixWidth();
    }

    public long getWorldWidthOfTileMatrixByLevel(int level) {
        return ((WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level)).getMatrixHeight();
    }

    public double getPixelSizeByLevel(int level) {
        if (level < this.pixelSize.length) {
            return this.pixelSize[level];
        }
        return this.pixelSize[this.pixelSize.length - 1];
    }

    public Point2D[] getTileExtent(Tile tile) {
        return this.getTileExtent(tile.getLevel(), tile.getCol(), tile.getRow());
    }

    public Point2D[] getTileExtent(int level, int col, int row) {
        double[] ul = this.tileMatrixSet.getBoundingBox().getUpperCorner();
        long tileWidth = ((WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level)).getTileWidth();
        long tileHeight = ((WMTSTileMatrix)this.tileMatrixSet.getTileMatrix().get(level)).getTileHeight();
        double mtsWidthTile = (double)tileWidth * this.pixelSize[level];
        double mtsHeightTile = (double)tileHeight * this.pixelSize[level];
        double ulx = ul[0] + (double)col * mtsWidthTile;
        double uly = ulx + mtsWidthTile;
        double lrx = ul[1] - (double)row * mtsHeightTile;
        double lry = lrx - mtsHeightTile;
        return new Point2D[]{new Point2D.Double(ulx, uly), new Point2D.Double(lrx, lry)};
    }

    public Tile getTileStructure(int level, int tileCol, int tileRow, Point2D ul, Point2D lr) throws TileBuildException {
        int[] size = this.getTileSizeByLevel(level);
        Tile tile = TileCacheLocator.getManager().createTile(level, tileRow, tileCol);
        tile.setUl(ul);
        tile.setLr(lr);
        tile.setWidthPx(size[0]);
        tile.setHeightPx(size[1]);
        Rectangle2D.Double r = new Rectangle2D.Double(Math.min(ul.getX(), lr.getX()), Math.min(ul.getY(), lr.getY()), Math.abs(ul.getX() - lr.getX()), Math.abs(ul.getY() - lr.getY()));
        int bufWidth = (int)(((RectangularShape)r).getWidth() / this.getPixelSizeByLevel(level));
        int bufHeight = (int)(((RectangularShape)r).getHeight() / this.getPixelSizeByLevel(level));
        try {
            WMTSStatus status = ((WMTSProvider)this.store.getProvider()).buildWMTSStatus(r, bufWidth, bufHeight);
            tile.setDownloaderParams("WMTSStatus", (Object)status);
        }
        catch (RasterDriverException e) {
            throw new TileBuildException((Throwable)e);
        }
        return tile;
    }

    public List<Tile> getTileList(Point2D ul, Point2D lr, double mtsPixelRequest) throws TileBuildException {
        Rectangle2D.Double r = new Rectangle2D.Double(Math.min(ul.getX(), lr.getX()), Math.min(ul.getY(), lr.getY()), Math.abs(ul.getX() - lr.getX()), Math.abs(ul.getY() - lr.getY()));
        int bufWidth = (int)(((RectangularShape)r).getWidth() / mtsPixelRequest);
        int bufHeight = (int)(((RectangularShape)r).getHeight() / mtsPixelRequest);
        try {
            WMTSStatus status = ((WMTSProvider)this.store.getProvider()).buildWMTSStatus(r, bufWidth, bufHeight);
            List tiles = status.getTileList();
            ArrayList<Tile> tileList = new ArrayList<Tile>();
            for (int i = 0; i < tiles.size(); ++i) {
                WMTSTile tOrigin = (WMTSTile)tiles.get(i);
                Tile t = TileCacheLocator.getManager().createTile(status.getLevel(), tOrigin.getCol(), tOrigin.getRow());
                t.setUl((Point2D)new Point2D.Double(tOrigin.getULX(), tOrigin.getULY()));
                t.setLr((Point2D)new Point2D.Double(tOrigin.getLRX(), tOrigin.getLRY()));
                t.setWidthPx(tOrigin.getWidthPx());
                t.setHeightPx(tOrigin.getHeightPx());
                t.setDownloaderParams("WMTSStatus", (Object)status.cloneStatus());
                tileList.add(t);
            }
            return tileList;
        }
        catch (RasterDriverException e) {
            throw new TileBuildException((Throwable)e);
        }
    }

    public double[] getTileSizeInRealCoordsByLevel(int level) {
        return new double[]{this.getPixelSizeByLevel(level) * (double)this.getTileSizeByLevel(level)[0], this.getPixelSizeByLevel(level) * (double)this.getTileSizeByLevel(level)[1]};
    }

    public String getFileSuffix() {
        return ((WMTSProvider)this.store.getProvider()).getFileSuffix();
    }

    public boolean compare(CacheStruct struct) {
        MathUtils mu = RasterLocator.getManager().getMathUtils();
        if (struct.getNumberOfLevels() == this.getNumberOfLevels()) {
            for (int i = 0; i < this.getNumberOfLevels(); ++i) {
                if (struct.getTileSizeByLevel(i)[0] != this.getTileSizeByLevel(i)[0] || struct.getTileSizeByLevel(i)[1] != this.getTileSizeByLevel(i)[1] || struct.getWorldHeightOfTileMatrixByLevel(i) != this.getWorldHeightOfTileMatrixByLevel(i) || struct.getWorldWidthOfTileMatrixByLevel(i) != this.getWorldWidthOfTileMatrixByLevel(i) || mu.clipDecimals(struct.getPixelSizeByLevel(i), 2) != mu.clipDecimals(this.getPixelSizeByLevel(i), 2) || !this.compareExtents(struct.getTileExtent(i, 0, 0), this.getTileExtent(i, 0, 0))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareExtents(Point2D[] p, Point2D[] p1) {
        return p[0].getX() == p1[0].getX() && p[0].getY() == p1[0].getY() && p[1].getX() == p1[1].getX() && p[1].getY() == p1[1].getY();
    }

    public String getEPSG() {
        return ((WMTSProvider)this.store.getProvider()).getSRSCode();
    }

    private String getDimension() {
        WMTSDataParameters p = (WMTSDataParameters)((WMTSProvider)this.store.getProvider()).getDataParameters();
        String dimension = p.getDimension();
        String dimensionValue = p.getDimensionSelectedValue();
        if (dimension != null && dimensionValue != null) {
            return dimension + "_" + dimensionValue;
        }
        return "";
    }

    public String getFileSize() {
        return "0";
    }

    public List<Tile> getTileList(int x, int y, int w, int h) {
        return null;
    }

    public ArrayList<Tile> getTileList(Rectangle2D r) {
        return null;
    }
}

