/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.app.mainplugin;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFSwingManager;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class PDFExtension
extends Extension {
    public void initialize() {
    }

    public void postInitialize() {
    }

    public void execute(String action) {
    }

    public void execute(String command, Object[] args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)command, (CharSequence)"show-pdf")) {
            Arguments arguments = Arguments.create((Object[])args);
            String title = (String)arguments.get("title", (Object)"PDF");
            WindowManager.MODE mode = (WindowManager.MODE)arguments.get("mode", (Object)WindowManager.MODE.WINDOW);
            if (arguments.contains("pdfdoc")) {
                PDFDocument pdfdoc = (PDFDocument)arguments.get("pdfdoc");
                this.showPdf(pdfdoc, title, mode);
                return;
            }
            if (arguments.contains("source")) {
                Object source = arguments.get("source");
                this.showPdf(source, title, mode);
                return;
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return false;
    }

    public void showPdf(Object source, String title, WindowManager.MODE mode) {
        PDFManager pdfManager = PDFLocator.getPDFManager();
        PDFDocument pdfDoc = pdfManager.createPDFDocument();
        pdfDoc.setSource(source);
        this.showPdf(pdfDoc, title, mode);
    }

    public void showPdf(PDFDocument pdfDoc, String title, WindowManager.MODE mode) {
        try {
            PDFSwingManager pdfSwingManager = PDFSwingLocator.getPDFSwingManager();
            PDFViewer viewer = pdfSwingManager.createPDFViewer();
            viewer.put(pdfDoc);
            viewer.setMode(0);
            WindowManager winManager = ToolsSwingLocator.getWindowManager();
            winManager.showWindow(viewer.asJComponent(), title, mode);
        }
        catch (Exception ex) {
            logger.warn("Can't show Pdf.'", (Throwable)ex);
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_show_pdf") + ")\n\n" + BaseException.getMessageStack((Throwable)ex, (int)0), i18n.getTranslation("_Show_pdf"), 2);
        }
    }
}

