/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.AbstractTableEditExtension;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;

public class TableEditChangeColumnsExtension
extends AbstractTableEditExtension {
    @Override
    public void initialize() {
        super.initialize();
        IconThemeHelper.registerIcon((String)"action", (String)"table-rename-column", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"table-remove-column", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        try {
            this.featureTableOperations.setTablePanel(this.table);
            if ("table-remove-column".equals(actionCommand)) {
                this.featureTableOperations.deleteAttributes(this.table.getTablePanel().getTable());
            } else if ("table-rename-column".equals(actionCommand)) {
                this.featureTableOperations.renameAttributes(this.table.getTablePanel().getTable());
            }
        }
        catch (DataException e) {
            NotificationManager.showMessageError((String)PluginServices.getText((Object)((Object)this), (String)"update_featuretype_error"), null);
        }
    }

    public boolean isEnabled() {
        try {
            FeatureStoreProviderFactory ffactory;
            FeatureStore store = this.table.getFeatureStore();
            if (!store.isEditing()) {
                return false;
            }
            DataStoreProviderFactory factory = store.getProviderFactory();
            if (factory instanceof FeatureStoreProviderFactory && (ffactory = (FeatureStoreProviderFactory)factory).allowEditableFeatureType() == 2) {
                return false;
            }
            if (this.table.getTablePanel().getTable().getSelectedColumnCount() > 0) {
                return true;
            }
        }
        catch (DataException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        TableDocument tableDoc = (TableDocument)application.getActiveDocument(TableManager.TYPENAME);
        if (tableDoc == null) {
            return false;
        }
        this.table = (FeatureTableDocumentPanel)((Object)tableDoc.getMainComponent());
        return true;
    }
}

