/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jgdal;

import java.util.Vector;
import org.gdal.gdal.Band;
import org.gdal.gdal.ColorTable;
import org.gvsig.jgdal.GdalBuffer;
import org.gvsig.jgdal.GdalColorTable;
import org.gvsig.jgdal.GdalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdalRasterBand {
    public static final Logger logger = LoggerFactory.getLogger(GdalRasterBand.class);
    private boolean hasNoDataValue = false;
    private Band band;

    public GdalRasterBand(Band band) {
        this.band = band;
    }

    public GdalBuffer readRaster(int nXOff, int nYOff, int nXSize, int nYSize, int bufXSize, int bufYSize, int eBufType) throws GdalException {
        if (nXOff < 0 || nXOff > this.getRasterBandXSize() || nYOff < 0 || nYOff > this.getRasterBandYSize()) {
            throw new GdalException("Desplazamiento de la ventana fuera de rango.");
        }
        if (nXSize < 1 || nXSize > this.getRasterBandXSize() || nYSize < 1 || nYSize > this.getRasterBandYSize()) {
            throw new GdalException("Tama\u00f1o de ventana incorrecto.");
        }
        if (nXSize + nXOff > this.getRasterBandXSize() || nYSize + nYOff > this.getRasterBandYSize()) {
            throw new GdalException("Posicion de la ventana incorrecta.");
        }
        if (eBufType < 1 || eBufType > 11) {
            throw new GdalException("Tipo de datos incorrecto.");
        }
        if (bufXSize < 1) {
            bufXSize = nXSize;
        }
        if (bufYSize < 1) {
            bufYSize = nYSize;
        }
        GdalBuffer buf = new GdalBuffer();
        int i = 0;
        switch (eBufType) {
            case 0: {
                i = 0;
                break;
            }
            case 1: {
                buf.reservaByte(bufXSize * bufYSize);
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffByte);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                buf.reservaShort(bufXSize * bufYSize);
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffShort);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                buf.reservaInt(bufXSize * bufYSize);
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffInt);
                break;
            }
            case 6: 
            case 10: {
                buf.reservaFloat(bufXSize * bufYSize);
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffFloat);
                break;
            }
            case 7: 
            case 11: {
                buf.reservaDouble(bufXSize * bufYSize);
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffDouble);
                break;
            }
            case 12: {
                i = 0;
            }
        }
        if (i >= 0) {
            return buf;
        }
        return null;
    }

    public void writeRaster(int nXOff, int nYOff, int nXSize, int nYSize, GdalBuffer buf, int eBufType) throws GdalException {
        GdalBuffer buffer = new GdalBuffer();
        if (nXOff < 0 || nXOff > this.getRasterBandXSize() || nYOff < 0 || nYOff > this.getRasterBandYSize()) {
            throw new GdalException("Desplazamiento de la ventana fuera de rango.");
        }
        if (nXSize < 1 || nXSize > this.getRasterBandXSize() || nYSize < 1 || nYSize > this.getRasterBandYSize()) {
            throw new GdalException("Tama\u00f1o de ventana incorrecto.");
        }
        if (nXSize + nXOff > this.getRasterBandXSize() || nYSize + nYOff > this.getRasterBandYSize()) {
            throw new GdalException("Posicion de la ventana incorrecta.");
        }
        if (eBufType < 1 || eBufType > 11) {
            throw new GdalException("Tipo de datos incorrecto.");
        }
        if (buf == null) {
            throw new GdalException("Buffer incorrecto");
        }
        switch (eBufType) {
            case 0: {
                return;
            }
            case 1: {
                buffer.buffByte = buf.buffByte;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                buffer.buffShort = buf.buffShort;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                buffer.buffInt = buf.buffInt;
                break;
            }
            case 6: 
            case 10: {
                buffer.buffFloat = buf.buffFloat;
                break;
            }
            case 7: 
            case 11: {
                buffer.buffDouble = buf.buffDouble;
                break;
            }
            case 12: {
                return;
            }
        }
        switch (eBufType) {
            case 0: {
                break;
            }
            case 1: {
                this.band.WriteRaster(nXOff, nYOff, nXSize, nYSize, eBufType, buffer.buffByte);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                this.band.WriteRaster(nXOff, nYOff, nXSize, nYSize, eBufType, buffer.buffShort);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                this.band.WriteRaster(nXOff, nYOff, nXSize, nYSize, eBufType, buffer.buffInt);
                break;
            }
            case 6: 
            case 10: {
                this.band.WriteRaster(nXOff, nYOff, nXSize, nYSize, eBufType, buffer.buffFloat);
                break;
            }
            case 7: 
            case 11: {
                this.band.WriteRaster(nXOff, nYOff, nXSize, nYSize, eBufType, buffer.buffDouble);
                break;
            }
        }
    }

    public int getRasterBandXSize() throws GdalException {
        return this.band.GetXSize();
    }

    public int getRasterBandYSize() throws GdalException {
        return this.band.GetYSize();
    }

    public int getOverviewCount() throws GdalException {
        return this.band.GetOverviewCount();
    }

    public GdalRasterBand getOverview(int i) throws GdalException {
        if (i < 0 || i >= this.getOverviewCount()) {
            throw new GdalException("El overview seleccionado no existe");
        }
        Band band_ov = this.band.GetOverview(i);
        if (band_ov == null || !(band_ov instanceof Band)) {
            throw new GdalException("No se ha podido obtener el overview");
        }
        return new GdalRasterBand(band_ov);
    }

    public int getBlockXSize() throws GdalException {
        return this.band.GetBlockXSize();
    }

    public int getBlockYSize() throws GdalException {
        return this.band.GetBlockYSize();
    }

    public int getRasterDataType() throws GdalException {
        return this.band.getDataType();
    }

    public GdalColorTable getRasterColorTable() throws GdalException {
        ColorTable ct = this.band.GetColorTable();
        if (ct == null) {
            return null;
        }
        return new GdalColorTable(ct);
    }

    public GdalBuffer readRasterWithPalette(int nXOff, int nYOff, int nXSize, int nYSize, int bufXSize, int bufYSize, int eBufType) throws GdalException {
        if (nXOff < 0 || nXOff > this.getRasterBandXSize() || nYOff < 0 || nYOff > this.getRasterBandYSize()) {
            throw new GdalException("Desplazamiento de la ventana fuera de rango.");
        }
        if (nXSize < 1 || nXSize > this.getRasterBandXSize() || nYSize < 1 || nYSize > this.getRasterBandYSize()) {
            throw new GdalException("Tama\u00f1o de ventana incorrecto.");
        }
        if (nXSize + nXOff > this.getRasterBandXSize() || nYSize + nYOff > this.getRasterBandYSize()) {
            throw new GdalException("Posicion de la ventana incorrecta.");
        }
        if (eBufType < 1 || eBufType > 11) {
            throw new GdalException("Tipo de datos incorrecto.");
        }
        if (bufXSize < 1) {
            bufXSize = nXSize;
        }
        if (bufYSize < 1) {
            bufYSize = nYSize;
        }
        GdalBuffer buf = new GdalBuffer();
        int i = 0;
        switch (eBufType) {
            case 0: {
                i = 0;
                break;
            }
            case 1: {
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffByte);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffShort);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffInt);
                break;
            }
            case 6: 
            case 10: {
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffFloat);
                break;
            }
            case 7: 
            case 11: {
                i = this.band.ReadRaster(nXOff, nYOff, nXSize, nYSize, bufXSize, bufYSize, eBufType, buf.buffDouble);
                break;
            }
            case 12: {
                i = 0;
            }
        }
        if (i > 0) {
            return buf;
        }
        return null;
    }

    public double getRasterNoDataValue() throws GdalException {
        Double[] aux = new Double[1];
        this.band.GetNoDataValue(aux);
        return aux[0];
    }

    public boolean existsNoDataValue() throws GdalException {
        return this.hasNoDataValue;
    }

    public void setRasterNoDataValue(double val) {
        this.hasNoDataValue = true;
        this.band.SetNoDataValue(val);
    }

    public String[] getMetadata() throws GdalException {
        Vector aux = this.band.GetMetadata_List();
        String[] res = aux.toArray(new String[0]);
        if (res == null) {
            return new String[0];
        }
        return res;
    }

    public int getRasterColorInterpretation() throws GdalException {
        int bandType = this.band.GetColorInterpretation();
        return bandType;
    }

    public void setRasterColorInterpretation(int bandType) throws GdalException {
        if (bandType < 0 || bandType > 16) {
            throw new GdalException("Tipo de banda incorrecto");
        }
        int err = this.band.SetColorInterpretation(bandType);
    }
}

