/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.io;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.store.parameter.NewRasterStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.raster.gdal.io.GdalNewRasterStoreParameters;
import org.gvsig.raster.gdal.io.GdalProvider;
import org.gvsig.raster.impl.store.AbstractRasterFileDataParameters;
import org.gvsig.tools.locator.LocatorException;

public class GdalFilesystemServerExplorer
extends AbstractFilesystemServerExplorerProvider {
    public boolean canCreate() {
        return false;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        return false;
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        DataServerWriter dataWriter;
        NewRasterStoreParameters p = null;
        if (parameters instanceof NewRasterStoreParameters) {
            p = (NewRasterStoreParameters)parameters;
        }
        if ((dataWriter = p.getDataServer()) == null) {
            dataWriter = RasterLocator.getManager().createDataServerWriter();
        }
        dataWriter.setBuffer(p.getBuffer(), p.getBand());
        try {
            Params params = p.getDriverParams() != null ? p.getDriverParams() : RasterLocator.getManager().createWriter(p.getFileName()).getParams();
            AffineTransform affineTransform = p.getAffineTransform();
            if (affineTransform == null) {
                if (p.getBuffer().getDataExtent() != null) {
                    double x = p.getBuffer().getDataExtent().getMinX();
                    double y = p.getBuffer().getDataExtent().getMaxY();
                    double pixelSizeX = p.getBuffer().getDataExtent().getWidth() / (double)p.getBuffer().getWidth();
                    double pixelSizeY = p.getBuffer().getDataExtent().getHeight() / (double)p.getBuffer().getHeight();
                    affineTransform = new AffineTransform(pixelSizeX, 0.0, 0.0, -pixelSizeY, x, y);
                } else {
                    affineTransform = new AffineTransform();
                }
            }
            RasterWriter writer = RasterLocator.getManager().createWriter(dataWriter, p.getPath() + File.separator + p.getFileName(), p.getBand() < 0 ? p.getBuffer().getBandCount() : 1, affineTransform, p.getBuffer().getWidth(), p.getBuffer().getHeight(), p.getBuffer().getDataType(), params, null);
            if (p.getColorInterpretation() != null) {
                writer.setColorBandsInterpretation(p.getColorInterpretation());
            }
            writer.setWkt(p.getWktProjection());
            writer.dataWrite();
            writer.writeClose();
        }
        catch (LocatorException e) {
            throw new CreateException("", (Throwable)e);
        }
        catch (NotSupportedExtensionException e) {
            throw new CreateException("", (Throwable)e);
        }
        catch (RasterDriverException e) {
            throw new CreateException("", (Throwable)e);
        }
        catch (ProcessInterruptedException e) {
        }
        catch (IOException e) {
            throw new CreateException("", (Throwable)e);
        }
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        return new GdalNewRasterStoreParameters();
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        throw new UnsupportedOperationException();
    }

    public String getDataStoreProviderName() {
        return GdalProvider.NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(File pathname) {
        if (pathname.getParentFile() != null && pathname.getParentFile().getName().equals("cellhd")) {
            return !pathname.getName().endsWith(".rmf") && !pathname.getName().endsWith(".rmf~");
        }
        if (pathname.getName().toLowerCase().endsWith(".rmf")) {
            FileInputStream reader = null;
            try {
                reader = new FileInputStream(pathname);
                String xml = "";
                for (int i = 0; i < 6; ++i) {
                    xml = xml + (char)reader.read();
                }
                if (xml.equals("<?xml ")) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return RasterLocator.getManager().getProviderServices().isExtensionSupported(pathname.getAbsolutePath(), GdalProvider.class);
    }

    public String getDescription() {
        return GdalProvider.DESCRIPTION;
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        AbstractRasterFileDataParameters params = (AbstractRasterFileDataParameters)manager.createStoreParameters(this.getDataStoreProviderName());
        params.setFile(file);
        return params;
    }

    public int getMode() {
        return 4;
    }
}

