/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.overview;

import org.gvsig.addo.BuildingOverviewsException;
import org.gvsig.addo.IOverviewIncrement;
import org.gvsig.addo.Jaddo;
import org.gvsig.addo.WritingException;
import org.gvsig.fmap.dal.coverage.exception.OverviewException;
import org.gvsig.fmap.dal.coverage.process.BaseIncrementableTask;
import org.gvsig.fmap.dal.coverage.process.overview.OverviewBuilder;

public class GdalOverviewBuilder
implements OverviewBuilder {
    private Jaddo build = new Jaddo();
    private int value = 0;

    public void buildOverviews(int resamplingAlg, String file, int[] overviews) throws OverviewException {
        try {
            this.build.buildOverviews(resamplingAlg, file, overviews);
        }
        catch (BuildingOverviewsException e) {
            throw new OverviewException("Error building overviews", (Throwable)e);
        }
        catch (WritingException e) {
            throw new OverviewException("Error writing overviews", (Throwable)e);
        }
    }

    public int getPercent() {
        return this.value;
    }

    public void setIncrementListener(BaseIncrementableTask incr) {
        this.build.setIncrementListener(new ProcessBinding(incr));
    }

    public void setPercent(int value) {
        this.value = value;
    }

    class ProcessBinding
    implements IOverviewIncrement {
        private BaseIncrementableTask task = null;

        public ProcessBinding(BaseIncrementableTask task) {
            this.task = task;
        }

        @Override
        public int getPercent() {
            return this.task.getPercent();
        }

        @Override
        public void setPercent(int value) {
            this.task.setPercent(value);
        }
    }
}

