/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.impl.info.InstallerInfoFileReader;
import org.gvsig.installer.lib.impl.info.InstallerInfoFileWriter;
import org.gvsig.installer.lib.impl.utils.Compress;
import org.gvsig.installer.lib.impl.utils.Decompress;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.installer.lib.spi.InstallerInfoFileException;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.tools.service.spi.AbstractProviderServices;
import org.gvsig.tools.task.SimpleTaskStatus;

public class DefaultInstallerProviderServices
extends AbstractProviderServices
implements InstallPackageProviderServices {
    private List<String> defaultSelectedPacketsIDs = null;
    private Properties properties;

    public void decompress(InputStream is, File outputDirectory) throws InstallPackageServiceException {
        Decompress decompress = new Decompress();
        decompress.decompressPlugin(is, outputDirectory);
    }

    public PackageInfo readCompressedPackageInfo(InputStream is) throws InstallPackageServiceException {
        Decompress decompress = new Decompress();
        try {
            return decompress.readInstallerInfo(is);
        }
        catch (InstallerInfoFileException e) {
            throw new ReadPackageException(e);
        }
    }

    public void compressPackageSet(File folder, String fileName, OutputStream os) throws MakePluginPackageServiceException {
        Compress compress = new Compress();
        compress.compressPluginAsPackageSet(folder, fileName, os);
    }

    public void compressPackage(File folder, OutputStream os) throws MakePluginPackageServiceException {
        Compress compress = new Compress();
        compress.compressPluginAsPackage(folder, os);
    }

    public void compressPackageIndex(File folder, OutputStream os) throws MakePluginPackageServiceException {
        Compress compress = new Compress();
        compress.compressPluginAsPackageIndex(folder, os);
    }

    public void readPackageInfo(File directory, PackageInfo installerInfo) throws InstallerInfoFileException {
        File installInfoFile = new File(directory + File.separator + this.getPackageInfoFileName());
        if (installInfoFile.exists()) {
            InstallerInfoFileReader reader = new InstallerInfoFileReader();
            reader.read(installerInfo, installInfoFile.getAbsolutePath());
        }
        if (installerInfo.getCode() == null) {
            installerInfo.setCode(directory.getName());
        }
        if (installerInfo.getName() == null) {
            installerInfo.setName(directory.getName());
        }
    }

    private String getPackageInfoFileName() {
        return InstallerProviderLocator.getProviderManager().getPackageInfoFileName();
    }

    public void writePackageInfo(File directory, PackageInfo packageInfo) throws InstallerInfoFileException {
        this.writePackageInfoFile(directory, this.getPackageInfoFileName(), packageInfo);
    }

    public void writePackageInfoForIndex(File directory, PackageInfo packageInfo) throws InstallerInfoFileException {
        this.writePackageInfoFile(directory, this.getPackageInfoFileName() + ".index", packageInfo);
    }

    private void writePackageInfoFile(File directory, String fileName, PackageInfo installerInfo) throws InstallerInfoFileException {
        if (!directory.exists()) {
            directory.mkdir();
        }
        InstallerInfoFileWriter installerInfoFileWriter = new InstallerInfoFileWriter();
        installerInfoFileWriter.write(installerInfo, directory + File.separator + fileName);
    }

    public InputStream searchPackage(InputStream is, String zipEntry) throws InstallPackageServiceException {
        Decompress decompress = new Decompress();
        return decompress.searchPlugin(is, zipEntry);
    }

    public void readPackageSetInfo(InputStream is, List<PackageInfo> installerInfos, Map<PackageInfo, String> zipEntriesMap, SimpleTaskStatus taskStatus) throws InstallPackageServiceException {
        Decompress decompress = new Decompress(taskStatus);
        decompress.readPackageSetInstallInfos(is, installerInfos, zipEntriesMap);
        this.defaultSelectedPacketsIDs = decompress.getDefaultSelectedPackages();
        this.properties = decompress.getProperties();
    }

    public void readPackageInfo(InputStream is, List<PackageInfo> installerInfos, Map<PackageInfo, String> zipEntriesMap, String name, SimpleTaskStatus taskStatus) throws InstallPackageServiceException {
        Decompress decompress = new Decompress(taskStatus);
        decompress.readPackageInstallInfo(is, installerInfos, zipEntriesMap, name);
    }

    public List<String> getDefaultSelectedPackagesIDs() {
        return this.defaultSelectedPacketsIDs;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public class ReadPackageException
    extends InstallPackageServiceException {
        private static final long serialVersionUID = 1989187468965303199L;
        private static final String message = "Exception reading a compressed file";
        private static final String KEY = "Exception_reading_a_compressed_file";

        public ReadPackageException(InstallerInfoFileException e) {
            super(message, (Throwable)e, KEY, 1989187468965303199L);
        }
    }
}

