/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.graphic;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GraphicChartPanel
extends JPanel {
    private static final long serialVersionUID = 7328137487119964665L;
    private JFreeChart chart = null;
    private ChartPanel jPanelChart = null;
    private XYSeries[] series = new XYSeries[0];
    private XYSeriesCollection dataset = new XYSeriesCollection();
    private int viewType = 0;

    public GraphicChartPanel() {
        this.createChart();
        this.initialize();
        Plot plot = this.jPanelChart.getChart().getPlot();
        plot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        plot.setOutlinePaint((Paint)Color.black);
        this.chart.setBackgroundPaint((Paint)Color.white);
        plot.setBackgroundPaint((Paint)new Color(245, 245, 245));
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getChart(), "Center");
    }

    public ChartPanel getChart() {
        if (this.jPanelChart == null) {
            this.jPanelChart = new ChartPanel(this.chart);
            this.jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        }
        return this.jPanelChart;
    }

    private void createChart() {
        this.chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        XYPlot plot = this.chart.getXYPlot();
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.red);
        plot.getRenderer().setSeriesPaint(1, (Paint)Color.green);
        plot.getRenderer().setSeriesPaint(2, (Paint)Color.blue);
        plot.getRenderer().setSeriesPaint(3, (Paint)Color.cyan);
        plot.getRenderer().setSeriesPaint(4, (Paint)Color.black);
        plot.getRenderer().setSeriesPaint(5, (Paint)Color.darkGray);
        plot.getRenderer().setSeriesPaint(6, (Paint)Color.gray);
        plot.getRenderer().setSeriesPaint(7, (Paint)Color.magenta);
        plot.getRenderer().setSeriesPaint(8, (Paint)Color.yellow);
        plot.getRenderer().setSeriesPaint(9, (Paint)Color.orange);
        Image img = new ImageIcon(this.getClass().getResource("images/splash.png")).getImage();
        plot.setBackgroundPaint(null);
        plot.setBackgroundImageAlpha(0.18f);
        plot.setBackgroundImage(img);
    }

    public void setNewChart(int[][] values, String[] names) {
        this.series = new XYSeries[values.length];
        for (int iGraf = 0; iGraf < values.length; ++iGraf) {
            this.series[iGraf] = new XYSeries((Comparable)((Object)names[iGraf]));
            for (int i = 0; i < values[iGraf].length; ++i) {
                this.series[iGraf].add((double)i, (double)values[iGraf][i]);
            }
        }
        this.reloadGraphic();
    }

    public void setNewChart(double[][][] values, String[] names) {
        this.series = new XYSeries[values.length];
        for (int iGraf = 0; iGraf < values.length; ++iGraf) {
            this.series[iGraf] = new XYSeries((Comparable)((Object)names[iGraf]));
            for (int i = 0; i < values[iGraf].length; ++i) {
                this.series[iGraf].add(values[iGraf][i][0], values[iGraf][i][1]);
            }
        }
        this.reloadGraphic();
    }

    public void setViewType(int type) {
        this.viewType = type;
        this.reloadGraphic();
    }

    private void reloadGraphic() {
        this.dataset.removeAllSeries();
        switch (this.viewType) {
            case 0: {
                for (int i = 0; i < this.series.length; ++i) {
                    this.dataset.addSeries(this.series[i]);
                }
                break;
            }
            case 1: {
                XYSeries[] seriesAcum = new XYSeries[this.series.length];
                for (int i = 0; i < this.series.length; ++i) {
                    seriesAcum[i] = new XYSeries(this.series[i].getKey());
                    double total = 0.0;
                    for (int j = 0; j < this.series[i].getItemCount(); ++j) {
                        seriesAcum[i].add(this.series[i].getX(j), (Number)(total += this.series[i].getY(j).doubleValue()));
                    }
                    this.dataset.addSeries(seriesAcum[i]);
                }
                break;
            }
            case 2: {
                int j;
                int i;
                XYSeries[] seriesLog = new XYSeries[this.series.length];
                double minim = Double.MAX_VALUE;
                for (i = 0; i < this.series.length; ++i) {
                    for (j = 0; j < this.series[i].getItemCount(); ++j) {
                        if (!(minim > this.series[i].getY(j).doubleValue())) continue;
                        minim = this.series[i].getY(j).doubleValue();
                    }
                }
                for (i = 0; i < this.series.length; ++i) {
                    seriesLog[i] = new XYSeries(this.series[i].getKey());
                    for (j = 0; j < this.series[i].getItemCount(); ++j) {
                        seriesLog[i].add(this.series[i].getX(j), (Number)Math.log(this.series[i].getY(j).doubleValue() - minim + 1.0));
                    }
                    this.dataset.addSeries(seriesLog[i]);
                }
                break;
            }
        }
        this.jPanelChart.repaint();
    }

    public void cleanChart() {
        this.series = new XYSeries[0];
        this.reloadGraphic();
    }
}

