/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.propertiespanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.gui.beans.propertiespanel.JPanelProperty;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponentListener;
import org.gvsig.gui.beans.propertiespanel.PropertyStruct;
import org.gvsig.gui.beans.slidertext.SliderTextContainer;
import org.gvsig.gui.beans.slidertext.listeners.SliderEvent;
import org.gvsig.gui.beans.slidertext.listeners.SliderListener;

public class PropertiesComponent
extends JScrollPane
implements FocusListener,
KeyListener,
ChangeListener,
ItemListener,
PropertiesComponentListener,
SliderListener {
    private static final long serialVersionUID = 372118344763661890L;
    private ArrayList datalist = new ArrayList();
    private ArrayList actionCommandListeners = new ArrayList();
    private JPanel jPanelContent = null;
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_SLIDER = 2;
    public static final int TYPE_COMBO = 3;
    int y = 0;

    public PropertiesComponent() {
        this.initialize();
    }

    public PropertiesComponent(ArrayList values) {
        this.initialize();
        for (int i = 0; i < values.size(); ++i) {
            this.addPropertyStruct((PropertyStruct)values.get(i));
        }
    }

    public PropertiesComponent(Properties properties) {
        this.initialize();
        Enumeration<Object> elements = properties.keys();
        while (elements.hasMoreElements()) {
            String key = (String)elements.nextElement();
            this.addValue(key, key, properties.get(key), null);
        }
    }

    private void initialize() {
        this.setBorder(null);
        this.jPanelContent = new JPanel();
        this.jPanelContent.setLayout(new GridBagLayout());
        JPanel jPanelPrincipal = new JPanel();
        jPanelPrincipal.setLayout(new GridBagLayout());
        JPanel jPanelEmpty = new JPanel();
        jPanelEmpty.setPreferredSize(new Dimension(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        jPanelPrincipal.add((Component)this.jPanelContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelPrincipal.add((Component)jPanelEmpty, gridBagConstraints);
        this.setViewportView(jPanelPrincipal);
    }

    public void addPropertyStruct(PropertyStruct property) {
        boolean without_label = false;
        JLabel label = new JLabel(property.getTextLabel() + ": ");
        Component component = new JLabel("Sin soporte para: " + property.getOldValue().getClass().toString());
        if (property.getOldValue() instanceof Component) {
            component = (Component)property.getOldValue();
            without_label = true;
        }
        if (property.getOldValue() instanceof String) {
            component = new JTextField(property.getOldValue().toString());
            ((JTextField)component).setMaximumSize(new Dimension(200, 25));
            ((JTextField)component).addFocusListener(this);
            ((JTextField)component).addKeyListener(this);
        }
        if (property.getOldValue() instanceof JPanelProperty) {
            component = (JPanelProperty)property.getOldValue();
            ((JPanelProperty)component).addStateChangedListener(this);
            without_label = true;
        }
        if (property.getOldValue() instanceof Integer || property.getOldValue() instanceof Double) {
            boolean created = false;
            if (property.getExtras() != null) {
                switch ((Integer)property.getExtras()[0]) {
                    case 2: {
                        without_label = true;
                        component = new SliderTextContainer();
                        ((SliderTextContainer)component).setBorder(BorderFactory.createTitledBorder(property.getTextLabel()));
                        if (property.getExtras().length >= 2) {
                            ((SliderTextContainer)component).setMinimum((Integer)property.getExtras()[1]);
                        }
                        if (property.getExtras().length >= 3) {
                            ((SliderTextContainer)component).setMaximum((Integer)property.getExtras()[2]);
                        }
                        if (property.getOldValue() instanceof Integer) {
                            ((SliderTextContainer)component).setDecimal(false);
                            ((SliderTextContainer)component).setValue(((Integer)property.getOldValue()).intValue());
                        }
                        if (property.getOldValue() instanceof Double) {
                            ((SliderTextContainer)component).setDecimal(true);
                            ((SliderTextContainer)component).setValue((Double)property.getOldValue());
                        }
                        ((SliderTextContainer)component).addValueChangedListener(this);
                        created = true;
                        break;
                    }
                    case 3: {
                        if (!(property.getOldValue() instanceof Integer)) break;
                        component = new JComboBox();
                        ArrayList aux = (ArrayList)property.getExtras()[1];
                        for (int i = 0; i < aux.size(); ++i) {
                            ((JComboBox)component).addItem(aux.get(i).toString());
                        }
                        if (property.getOldValue() instanceof Integer) {
                            ((JComboBox)component).setSelectedIndex((Integer)property.getOldValue());
                        }
                        ((JComboBox)component).addItemListener(this);
                        created = true;
                    }
                }
            }
            if (!created) {
                component = new JSpinner();
                ((JSpinner)component).setValue(property.getOldValue());
                ((JSpinner)component).addChangeListener(this);
            }
        }
        if (property.getOldValue() instanceof Boolean) {
            component = new JCheckBox();
            ((JCheckBox)component).setSelected((Boolean)property.getOldValue());
            ((JCheckBox)component).addItemListener(this);
        }
        if (without_label) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            this.jPanelContent.add(component, gridBagConstraints);
        } else {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.y;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(2, 5, 2, 2);
            this.jPanelContent.add((Component)label, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this.y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 5);
            this.jPanelContent.add(component, gridBagConstraints);
        }
        ++this.y;
        label.setLabelFor(component);
        property.setJLabel(label);
        property.setComponent(component);
        this.datalist.add(property);
    }

    public void addValue(String textLabel, String key, Object value, Object[] extras) {
        PropertyStruct propertyStruct = new PropertyStruct(textLabel, key, value, extras);
        this.addPropertyStruct(propertyStruct);
    }

    public void put(Object key, Object value) {
        PropertyStruct propertyStruct = new PropertyStruct((String)key, (String)key, value, null);
        this.addPropertyStruct(propertyStruct);
    }

    public ArrayList getValues() {
        for (int i = 0; i < this.datalist.size(); ++i) {
            PropertyStruct propertyStruct = (PropertyStruct)this.datalist.get(i);
            if (propertyStruct.getComponent() instanceof JTextField) {
                propertyStruct.setNewValue(((JTextField)propertyStruct.getComponent()).getText());
                continue;
            }
            if (propertyStruct.getComponent() instanceof JSpinner) {
                propertyStruct.setNewValue(((JSpinner)propertyStruct.getComponent()).getValue());
                continue;
            }
            if (propertyStruct.getComponent() instanceof SliderTextContainer) {
                if (propertyStruct.getOldValue() instanceof Double) {
                    propertyStruct.setNewValue(((SliderTextContainer)propertyStruct.getComponent()).getValue());
                    continue;
                }
                propertyStruct.setNewValue((int)((SliderTextContainer)propertyStruct.getComponent()).getValue());
                continue;
            }
            if (propertyStruct.getComponent() instanceof JCheckBox) {
                propertyStruct.setNewValue(new Boolean(((JCheckBox)propertyStruct.getComponent()).getSelectedObjects() != null));
                continue;
            }
            if (propertyStruct.getComponent() instanceof JComboBox) {
                propertyStruct.setNewValue(new Integer(((JComboBox)propertyStruct.getComponent()).getSelectedIndex()));
                continue;
            }
            if (!(propertyStruct.getComponent() instanceof JPanelProperty)) continue;
        }
        return this.datalist;
    }

    public Component getComponentUI(String name) {
        for (int i = 0; i < this.datalist.size(); ++i) {
            PropertyStruct propertyStruct = (PropertyStruct)this.datalist.get(i);
            String key = propertyStruct.getKey();
            if (!key.equals(name)) continue;
            return propertyStruct.getComponent();
        }
        return null;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (int i = 0; i < this.datalist.size(); ++i) {
            PropertyStruct propertyStruct = (PropertyStruct)this.datalist.get(i);
            String key = propertyStruct.getKey();
            if (propertyStruct.getComponent() instanceof JTextField) {
                properties.put(key, ((JTextField)propertyStruct.getComponent()).getText());
                continue;
            }
            if (propertyStruct.getComponent() instanceof JSpinner) {
                properties.put(key, ((JSpinner)propertyStruct.getComponent()).getValue());
                continue;
            }
            if (propertyStruct.getComponent() instanceof SliderTextContainer) {
                if (propertyStruct.getOldValue() instanceof Double) {
                    properties.put(key, new Double(((SliderTextContainer)propertyStruct.getComponent()).getValue()));
                    continue;
                }
                properties.put(key, new Integer((int)((SliderTextContainer)propertyStruct.getComponent()).getValue()));
                continue;
            }
            if (propertyStruct.getComponent() instanceof JCheckBox) {
                properties.put(key, new Boolean(((JCheckBox)propertyStruct.getComponent()).getSelectedObjects() != null));
                continue;
            }
            if (propertyStruct.getComponent() instanceof JComboBox) {
                properties.put(key, new Integer(((JComboBox)propertyStruct.getComponent()).getSelectedIndex()));
                continue;
            }
            if (!(propertyStruct.getComponent() instanceof JPanelProperty)) continue;
            properties.put(key, (JPanelProperty)propertyStruct.getComponent());
        }
        return properties;
    }

    public void addStateChangedListener(PropertiesComponentListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeStateChangedListener(PropertiesComponentListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callStateChanged() {
        for (PropertiesComponentListener listener : this.actionCommandListeners) {
            listener.actionChangeProperties(new EventObject(this));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.callStateChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.callStateChanged();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.callStateChanged();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.callStateChanged();
        }
    }

    @Override
    public void actionChangeProperties(EventObject e) {
        this.callStateChanged();
    }

    @Override
    public void actionValueChanged(SliderEvent e) {
        this.callStateChanged();
    }

    @Override
    public void actionValueDragged(SliderEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }
}

