/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.jComboBoxWithImageIconItems;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.swing.jComboBoxWithImageIconItems.ComboBoxImageIconModel;
import org.gvsig.gui.beans.swing.jComboBoxWithImageIconItems.ImageIconItemInfo;

public class JComboBoxWithImageIconItems
extends JComboBox
implements Serializable {
    private static final long serialVersionUID = -429261182461238958L;
    public static final int DEFAULT_ROW_COUNT = 3;
    private JComboBoxWithImageIconItems referenceToThisJComboBoxWithImageIconItems;

    public JComboBoxWithImageIconItems() {
        this.initialize();
    }

    public JComboBoxWithImageIconItems(ComboBoxImageIconModel aModel) {
        this.initialize();
    }

    public JComboBoxWithImageIconItems(Object[] items) {
        this.initialize();
    }

    public JComboBoxWithImageIconItems(Vector items) {
        this.initialize();
    }

    private void initialize() {
        this.referenceToThisJComboBoxWithImageIconItems = this;
        this.setModel(new ComboBoxImageIconModel());
        this.setRenderer(new ComboBoxImageIconRenderer());
        this.setMaximumRowCount(3);
    }

    public void addImageIconItem(String imageIconPath, ImageIcon imageIcon, String imageIconToolTipText, Object item_Value) {
        this.addItem(new ImageIconItemInfo(imageIconPath, imageIcon, imageIconToolTipText, item_Value));
    }

    public void addImageIconItem(ImageIconItemInfo imageIconItem) {
        this.addItem(imageIconItem);
    }

    public void removeImageIconItem(String imageIconPath, String imageIconToolTipText, String item_Value) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            ImageIconItemInfo iiii1 = (ImageIconItemInfo)this.getItemAt(i);
            if (iiii1.getPath().compareTo(imageIconPath) != 0 || iiii1.getToolTipText().compareTo(imageIconToolTipText) != 0 || (iiii1.getItemValue() != null || item_Value != null) && !iiii1.getItemValue().equals(item_Value)) continue;
            this.removeItemAt(i);
            return;
        }
    }

    public void removeImageIconItem(ImageIconItemInfo imageIconItem) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            ImageIconItemInfo iiii1 = (ImageIconItemInfo)this.getItemAt(i);
            if (iiii1.getPath().compareTo(imageIconItem.getPath()) != 0 || iiii1.getToolTipText().compareTo(imageIconItem.getToolTipText()) != 0 || (iiii1.getItemValue() != null || imageIconItem.getItemValue() != null) && !iiii1.getItemValue().equals(imageIconItem.getItemValue())) continue;
            this.removeItemAt(i);
            return;
        }
    }

    public void removeAllImageIconItems() {
        this.removeAllItems();
    }

    public void addImageIconItems(ImageIconItemInfo[] imageIconItems) {
        for (int i = 0; i < imageIconItems.length; ++i) {
            this.addItem(imageIconItems[i]);
        }
    }

    public void addImageIconItems(Vector imageIconItems) {
        for (int i = 0; i < imageIconItems.size(); ++i) {
            this.addItem(imageIconItems.get(i));
        }
    }

    public void removeImageIconItems(ImageIconItemInfo[] imageIconItems) {
        block0: for (int i = 0; i < imageIconItems.length; ++i) {
            ImageIconItemInfo iiii1 = imageIconItems[i];
            for (int j = 0; j < this.getItemCount(); ++j) {
                ImageIconItemInfo iiii2 = (ImageIconItemInfo)this.getItemAt(j);
                if (iiii1.getPath().compareTo(iiii2.getPath()) != 0 || iiii1.getToolTipText().compareTo(iiii2.getToolTipText()) != 0 || (iiii1.getItemValue() != null || iiii2.getItemValue() != null) && !iiii1.getItemValue().equals(iiii2.getItemValue())) continue;
                this.removeItemAt(j);
                continue block0;
            }
        }
    }

    public void removeImageIconItems(Vector imageIconItems) {
        block0: for (int i = 0; i < imageIconItems.size(); ++i) {
            ImageIconItemInfo iiii1 = (ImageIconItemInfo)imageIconItems.get(i);
            for (int j = 0; j < this.getItemCount(); ++j) {
                ImageIconItemInfo iiii2 = (ImageIconItemInfo)this.getItemAt(j);
                if (iiii1.getPath().compareTo(iiii2.getPath()) != 0 || iiii1.getToolTipText().compareTo(iiii2.getToolTipText()) != 0 || (iiii1.getItemValue() != null || iiii2.getItemValue() != null) && !iiii1.getItemValue().equals(iiii2.getItemValue())) continue;
                this.removeItemAt(j);
                continue block0;
            }
        }
    }

    public void setShowImageIconAndTextProperty(boolean b) {
        ((ComboBoxImageIconModel)this.getModel()).setShowImageIconAndTextProperty(b);
    }

    public boolean getShowImageIconAndTextProperty() {
        return ((ComboBoxImageIconModel)this.getModel()).getShowImageIconAndTextProperty();
    }

    public void setJComboBoxRendererPreferredSize(Dimension d) {
        ((ComboBoxImageIconRenderer)this.getRenderer()).setPreferredSize(d);
    }

    public Dimension getJComboBoxRendererPreferredSize() {
        return ((ComboBoxImageIconRenderer)this.getRenderer()).getPreferredSize();
    }

    private class ComboBoxImageIconRenderer
    extends JLabel
    implements ListCellRenderer,
    Serializable {
        private static final long serialVersionUID = -7247546606502171953L;
        private Font uhOhFont;

        public ComboBoxImageIconRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                ImageIcon icon = ((ImageIconItemInfo)value).getImageIcon();
                String item = ((ImageIconItemInfo)value).getPath();
                String toolTipText = ((ImageIconItemInfo)value).getToolTipText();
                this.setIcon(icon);
                if (toolTipText != null) {
                    this.setToolTipText(toolTipText);
                    JComboBoxWithImageIconItems.this.referenceToThisJComboBoxWithImageIconItems.setToolTipText(toolTipText);
                }
                if (JComboBoxWithImageIconItems.this.getShowImageIconAndTextProperty()) {
                    if (icon != null) {
                        this.setText(item);
                        this.setFont(list.getFont());
                    } else {
                        this.setUhOhText(item + " (" + Messages.getText("no_image_available") + ")", list.getFont());
                    }
                } else {
                    this.setText(" ");
                }
            } else {
                this.setIcon(null);
                this.setToolTipText("");
                JComboBoxWithImageIconItems.this.referenceToThisJComboBoxWithImageIconItems.setToolTipText("");
                this.setText("");
            }
            return this;
        }

        private void setUhOhText(String uhOhText, Font normalFont) {
            if (this.uhOhFont == null) {
                this.uhOhFont = normalFont.deriveFont(2);
            }
            this.setFont(this.uhOhFont);
            this.setText(uhOhText);
        }
    }
}

