/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import org.gvsig.gui.beans.table.MoveRowsPanel;
import org.gvsig.gui.beans.table.Table;
import org.gvsig.gui.beans.table.TableControlerPanel;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.gui.beans.table.listeners.TableListener;

public class TableContainer
extends JPanel {
    private static final long serialVersionUID = 384372026944926838L;
    private Table table = null;
    private TableControlerPanel pTableControl = null;
    private MoveRowsPanel moveRowsPanel = null;
    private String[] columnNames = null;
    private int[] columnWidths = null;
    private TableListener tableListener = null;
    private boolean initTable = false;
    private String tableModelClass = "ListModel";
    private ArrayList listeners = null;

    public TableContainer(String[] columnNames, int[] columnWidths) {
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
    }

    public TableContainer(String[] columnNames, int[] columnWidths, ArrayList listeners) {
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
        this.listeners = listeners;
    }

    public void initialize() {
        this.initTable = true;
        this.tableListener = new TableListener(this);
        this.getTable().getJTable().getSelectionModel().addListSelectionListener(this.tableListener);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add((Component)this.getTable(), "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        panel.add(this.getPTableControl());
        panel.add(this.getMoveRowsPanel());
        this.add((Component)panel, "South");
    }

    public Table getTable() {
        if (this.table == null) {
            this.table = new Table(this.columnNames, this.columnWidths, this.tableModelClass, this.listeners);
            this.table.setTableContainer(this);
        }
        return this.table;
    }

    public TableControlerPanel getPTableControl() {
        if (this.pTableControl == null) {
            this.pTableControl = new TableControlerPanel(this.tableListener);
        }
        return this.pTableControl;
    }

    public MoveRowsPanel getMoveRowsPanel() {
        if (this.moveRowsPanel == null) {
            this.moveRowsPanel = new MoveRowsPanel(this.tableListener);
            this.moveRowsPanel.setVisible(false);
        }
        return this.moveRowsPanel;
    }

    public void addRow(Object[] list) throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        TableListener.comboEventEnable = false;
        this.getTable().addRow(list);
        this.getPTableControl().addPointToTable(this.getTable().getJTable().getRowCount());
        this.setSelectedIndex(this.getRowCount() - 1);
        TableListener.comboEventEnable = true;
    }

    public void delRow(int i) throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        TableListener.comboEventEnable = false;
        try {
            this.setSelectedIndex(this.getSelectedRow() - 1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            try {
                this.setSelectedIndex(this.getSelectedRow() + 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.getTable().delRow(i);
        this.getPTableControl().setNItems(this.getRowCount());
        TableListener.comboEventEnable = true;
    }

    public void swapRow(int i, int j) throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        TableListener.comboEventEnable = false;
        this.getTable().swapRow(i, j);
        TableListener.comboEventEnable = true;
    }

    public void removeAllRows() throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        TableListener.comboEventEnable = false;
        this.getTable().removeAllRows();
        this.getPTableControl().setNItems(0);
        TableListener.comboEventEnable = true;
    }

    public int getRowCount() throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        return this.getTable().getJTable().getRowCount();
    }

    public void setSelectedIndex(int i) throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        TableListener.comboEventEnable = false;
        try {
            this.getPTableControl().setSelectedIndex(i);
            this.getMoveRowsPanel().setSelectedIndex(i, this.getRowCount());
            this.getTable().getJTable().setRowSelectionInterval(i, i);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TableListener.comboEventEnable = true;
    }

    public int getSelectedRow() throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        return this.getTable().getJTable().getSelectedRow();
    }

    public int[] getSelectedRows() throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        return this.getTable().getJTable().getSelectedRows();
    }

    public void setValueAt(Object value, int row, int col) throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        this.getTable().getJTable().setValueAt(value, row, col);
    }

    public void setEditable(boolean editable) throws NotInitializeException {
        if (!this.initTable) {
            throw new NotInitializeException();
        }
        if (!editable) {
            this.getTable().getJTable().setBackground(this.getBackground());
        } else {
            this.getTable().getJTable().setBackground(Color.white);
        }
        this.getTable().getJTable().setEnabled(editable);
    }

    public void setModel(String model) {
        this.tableModelClass = model;
    }

    public DefaultTableModel getModel() {
        return (DefaultTableModel)this.getTable().getJTable().getModel();
    }

    public void setControlVisible(boolean visible) {
        this.getPTableControl().setVisible(visible);
    }

    public void setMoveRowsButtonsVisible(boolean visible) {
        this.getMoveRowsPanel().setVisible(visible);
    }

    public TableControlerPanel getControl() {
        return this.getPTableControl();
    }

    public void setEnableControlsListener(boolean enabled) {
        this.tableListener.enableNewLineListener = enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getTable().getJTable().setEnabled(enabled);
        if (!enabled) {
            this.getPTableControl().disableAllControls();
        } else {
            this.getPTableControl().restoreControlsValue();
        }
    }
}

