/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.splitline.operation;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperation;
import org.gvsig.vectorediting.lib.prov.splitline.operation.SplitLineOperationUtils;

public class CurveSplitLineOperation
implements SplitLineOperation {
    @Override
    public Curve[] split(Geometry geometry, Point projectedPoint) throws LocatorException, GeometryOperationNotSupportedException, GeometryOperationException, GeometryException {
        int pointer;
        MultiLine lines;
        Curve lineToSplit = (Curve)geometry;
        if (!(lineToSplit instanceof Line) && (lines = lineToSplit.toLines()) != null && lines.getPrimitivesNumber() > 0) {
            lineToSplit = (Curve)lines.getPrimitiveAt(0);
        }
        int subtype = geometry.getGeometryType().getSubType();
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        Line splittedLine1 = GeometryLocator.getGeometryManager().createLine(subtype);
        for (pointer = 0; pointer < lineToSplit.getNumVertices() - 1; ++pointer) {
            splittedLine1.addVertex(lineToSplit.getVertex(pointer));
            Line segment = geoManager.createLine(subtype);
            segment.setPoints(lineToSplit.getVertex(pointer), lineToSplit.getVertex(pointer + 1));
            if (!SplitLineOperationUtils.intersects((Curve)segment, projectedPoint)) continue;
            splittedLine1.addVertex(projectedPoint);
            ++pointer;
            break;
        }
        Line splittedLine2 = GeometryLocator.getGeometryManager().createLine(subtype);
        splittedLine2.addVertex(projectedPoint);
        while (pointer < lineToSplit.getNumVertices()) {
            splittedLine2.addVertex(lineToSplit.getVertex(pointer));
            ++pointer;
        }
        return new Curve[]{splittedLine1, splittedLine2};
    }
}

