/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.convexhull;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.Sextante;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;

public class ConvexHullOperation {
    public static final String NAME = "ConvexHull";
    public static final int CODE = GeometryLocator.getGeometryManager().getGeometryOperationCode("ConvexHull");
    Geometry geometry = null;
    GeometryFactory geomFact = null;
    private GeometryManager geometryManager = GeometryLocator.getGeometryManager();

    public void setFeatureStore(FeatureStore out, String[] attrNames) throws DataException {
    }

    public org.gvsig.fmap.geom.Geometry getGeometry() {
        if (this.geometry == null) {
            return null;
        }
        GeometryOperationContext ctx = new GeometryOperationContext();
        ctx.setAttribute("JTSGeometry", (Object)this.geometry);
        try {
            return (org.gvsig.fmap.geom.Geometry)this.geometryManager.invokeOperation("fromJTS", ctx);
        }
        catch (GeometryOperationNotSupportedException e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
        catch (GeometryOperationException e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
    }

    public org.gvsig.fmap.geom.Geometry invoke(org.gvsig.fmap.geom.Geometry g) {
        if (g == null) {
            return null;
        }
        Geometry actualGeometry = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        if (this.geometry == null) {
            this.geometry = actualGeometry;
        } else {
            Geometry[] geoms = new Geometry[]{this.geometry, actualGeometry};
            if (this.geomFact == null) {
                this.geomFact = new GeometryFactory();
            }
            GeometryCollection gc = this.geomFact.createGeometryCollection(geoms);
            this.geometry = gc.convexHull();
        }
        return this.getGeometry();
    }

    public int getOperationIndex() {
        return CODE;
    }
}

