/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.arc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class ArcEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter startPoint;
    private final EditingServiceParameter endPoint;
    private final EditingServiceParameter middlePoint;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;

    public ArcEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.startPoint = new DefaultEditingServiceParameter("start_point", "start_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.endPoint = new DefaultEditingServiceParameter("end_point", "end_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.middlePoint = new DefaultEditingServiceParameter("middle_point", "middle_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.startPoint) == null) {
            return this.startPoint;
        }
        if (this.values.get(this.endPoint) == null) {
            return this.endPoint;
        }
        if (this.values.get(this.middlePoint) == null) {
            return this.middlePoint;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        if (this.values != null && this.values.get(this.startPoint) != null) {
            Point startPointValue = (Point)this.values.get(this.startPoint);
            geometries.addStatus((Geometry)startPointValue, auxiliaryPointSymbolEditing, "");
            if (this.values.get(this.endPoint) == null) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    Line line = editingProviderServices.createLine(startPointValue, mousePosition, subtype);
                    geometries.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
                return geometries;
            }
            Point endPointValue = (Point)this.values.get(this.endPoint);
            geometries.addStatus((Geometry)endPointValue, auxiliaryPointSymbolEditing, "");
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Line line1 = editingProviderServices.createLine(startPointValue, mousePosition, subtype);
                geometries.addStatus((Geometry)line1, auxiliaryLineSymbolEditing, "");
                Line line2 = editingProviderServices.createLine(endPointValue, mousePosition, subtype);
                geometries.addStatus((Geometry)line2, auxiliaryLineSymbolEditing, "");
                Point center = editingProviderServices.getCenter(startPointValue, mousePosition, endPointValue, subtype);
                geometries.addStatus((Geometry)center, auxiliaryPointSymbolEditing, "");
                Arc arc = editingProviderServices.createArc(startPointValue, mousePosition, endPointValue, subtype);
                geometries.addStatus((Geometry)arc, lineSymbolEditing, "");
                geometries.addStatus((Geometry)arc, previewSymbol, "");
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
            return geometries;
        }
        return null;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.startPoint);
        parameters.add(this.endPoint);
        parameters.add(this.middlePoint);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.startPoint) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.endPoint) {
            if (value instanceof Point) {
                if (((Point)value).equals((Point)this.values.get(this.startPoint))) {
                    throw new InvalidEntryException(null);
                }
                this.values.put(param, value);
                return;
            }
        } else if (param == this.middlePoint && value instanceof Point) {
            if (((Point)value).equals((Point)this.values.get(this.startPoint)) || ((Point)value).equals((Point)this.values.get(this.endPoint))) {
                throw new InvalidEntryException(null);
            }
            this.values.put(param, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        Point startPointValue = (Point)this.values.get(this.startPoint);
        Point middlePointValue = (Point)this.values.get(this.middlePoint);
        Point endPointValue = (Point)this.values.get(this.endPoint);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            Arc arc = editingProviderServices.createArc(startPointValue, middlePointValue, endPointValue, subtype);
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)arc);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-arc";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

