/*
 * Decompiled with CFR 0.152.
 */
package org.amic.properties;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.amic.properties.PropertiesTableModel;
import org.amic.util.string.ClassFormatter;
import org.amic.xml.XmlReader;
import org.amic.xml.XmlWriter;

public class XMLProperties {
    private PropertiesTableModel model;
    private String propTag = "property";
    private String rootTag = "properties";

    public XMLProperties(PropertiesTableModel model) {
        this.model = model;
    }

    public void setRootTag(String tag) {
        this.rootTag = tag;
    }

    public void setPropertyTag(String tag) {
        this.propTag = tag;
    }

    public String getXML() {
        try {
            XmlWriter xw = new XmlWriter(this.rootTag);
            this.addXML(xw);
            return xw.getXML();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void addXML(XmlWriter xw) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            PropertiesTableModel.Property prop = this.model.getRowByIndex(i);
            this.addProperty(xw.addNode(this.propTag), prop);
            ++i;
        }
    }

    public void setXML(String xml) {
        this.setXML(new ByteArrayInputStream(xml.getBytes()));
    }

    public void setXML(InputStream is) {
        try {
            XmlReader xr = new XmlReader(is);
            this.setXML(xr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setXML(XmlReader xr) {
        this.model.clearModel();
        try {
            XmlReader[] nodes = xr.getNodes();
            int i = 0;
            while (i < nodes.length) {
                String name = nodes[i].getName();
                if (name.equalsIgnoreCase(this.propTag)) {
                    this.addProperty(nodes[i]);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addProperty(XmlWriter xw, PropertiesTableModel.Property prop) {
        xw.addNode("name").setText(prop.name);
        if (prop.label != null) {
            xw.addNode("label").setText(prop.label);
        }
        if (prop.jClass != null) {
            xw.addNode("java-class").setText(prop.jClass.getName());
        }
        if (prop.format != null) {
            xw.addNode("format").setText(prop.format);
        }
        if (prop.validCount() > 0) {
            int i = 0;
            while (i < prop.validCount()) {
                xw.addNode("valid").setText((String)prop.valids.elementAt(i));
                ++i;
            }
        }
        xw.addNode("editable").setText(new Boolean(prop.editable).toString());
        if (prop.value != null) {
            xw.addNode("value").setText(prop.format == null ? ClassFormatter.format(prop.value) : ClassFormatter.format(prop.value, prop.format));
        }
    }

    private void addProperty(XmlReader xr) {
        XmlReader[] nodes = xr.getNodes();
        String propName = "";
        int i = 0;
        while (i < nodes.length) {
            String name = nodes[i].getName();
            if (name.equalsIgnoreCase("name")) {
                propName = nodes[i].getValue();
                this.model.addRow(propName, null);
            } else if (name.equalsIgnoreCase("label")) {
                this.model.setLabel(propName, nodes[i].getValue());
            } else if (name.equalsIgnoreCase("java-class")) {
                try {
                    this.model.setJClass(propName, Class.forName(nodes[i].getValue()));
                }
                catch (Exception ex) {}
            } else if (name.equalsIgnoreCase("format")) {
                this.model.setFormat(propName, nodes[i].getValue());
            } else if (name.equalsIgnoreCase("valid")) {
                this.model.addValidValue(propName, nodes[i].getValue());
            } else if (name.equalsIgnoreCase("editable")) {
                this.model.setEditable(propName, new Boolean(nodes[i].getValue()));
            } else if (name.equalsIgnoreCase("value")) {
                this.model.setValue(propName, nodes[i].getValue());
            }
            ++i;
        }
    }
}

