/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.date;

import java.util.Calendar;
import java.util.Date;
import org.amic.util.date.CheckDate;

public class Scheduler {
    public static int MONDAY = 2;
    public static int TUESDAY = 3;
    public static int WEDNESDAY = 4;
    public static int THURSDAY = 5;
    public static int FRIDAY = 6;
    public static int SATURDAY = 7;
    public static int SUNDAY = 1;
    private CheckDate date;
    private Date initialDate;
    private Date finalDate;
    private int initialHour;
    private int initialMinute;
    private int finalHour;
    private int finalMinute;
    private int initialDay;
    private int initialMonth;
    private int finalDay;
    private int finalMonth;
    private int addMinute;
    private int addHour;
    private int addDay;
    private int addWeek;
    private int addMonth;
    private int weekDay;
    private int weekOrder;
    private int absoluteDay;

    public Scheduler() {
        this((Date)null);
    }

    public Scheduler(Date date) {
        this(new CheckDate(date));
    }

    public Scheduler(String date) {
        this(new CheckDate(date));
    }

    public Scheduler(CheckDate date) {
        this.date = date;
        this.setInitialTimeLimit(0, 0);
        this.setFinalTimeLimit(23, 59);
        this.setInitialDateLimit(1, 1);
        this.setFinalDateLimit(31, 12);
        this.setInitialDate((Date)null);
        this.setFinalDate((Date)null);
        this.setWeekDay(-1, 0);
        this.setAbsoluteDay(0);
        this.setDaysToAdd(0);
        this.setWeeksToAdd(0);
        this.setMonthsToAdd(0);
    }

    public Date getDate() {
        return this.date.getDate();
    }

    public Calendar getCalendar() {
        return this.date.getCalendar();
    }

    public CheckDate getCheckDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date.setDate(date);
    }

    public void setDate(String date) {
        this.date.setDate(date);
    }

    public Scheduler firstDate() {
        if (this.initialDate != null) {
            this.date.setDate(this.initialDate);
        }
        this.checkLimits();
        return this;
    }

    public Scheduler nextDate(Date now) {
        return this.nextDate(new CheckDate(now));
    }

    public Scheduler nextDate(String now) {
        return this.nextDate(new CheckDate(now));
    }

    public Scheduler nextDate(CheckDate now) {
        this.firstDate();
        while (now.getDate().compareTo(this.date.getDate()) > 0) {
            this.nextDate();
        }
        return this;
    }

    public Scheduler nextDate() {
        Date d = new Date(this.date.getDate().getTime());
        this.date.addMinutes(this.addMinute);
        this.date.addHours(this.addHour);
        this.checkLimits();
        if (!this.date.sameDay(d) || d.compareTo(this.date.getDate()) == 0) {
            this.initTime();
            this.date.addDays(this.addDay);
            this.date.addWeeks(this.addWeek);
            if (this.addMonth > 0 && this.weekDay > -1) {
                this.date.setDay(1);
            }
            this.date.addMonths(this.addMonth);
            this.checkLimits();
        }
        return this;
    }

    public boolean isInBounds() {
        return (this.initialDate == null || this.initialDate != null && this.initialDate.compareTo(this.date.getDate()) <= 0) && (this.finalDate == null || this.finalDate != null && this.finalDate.compareTo(this.date.getDate()) >= 0);
    }

    public boolean isDaily() {
        return this.addDay > 0;
    }

    public boolean isWeekly() {
        return this.addWeek > 0;
    }

    public boolean isMonthly() {
        return this.addMonth > 0;
    }

    public int getInitialHourLimit() {
        return this.initialHour;
    }

    public int getInitialMinuteLimit() {
        return this.initialMinute;
    }

    public int getFinalHourLimit() {
        return this.finalHour;
    }

    public int getFinalMinuteLimit() {
        return this.finalMinute;
    }

    public int getInitialDayLimit() {
        return this.initialDay;
    }

    public int getInitialMonthLimit() {
        return this.initialMonth;
    }

    public int getFinalDayLimit() {
        return this.finalDay;
    }

    public int getFinalMonthLimit() {
        return this.finalMonth;
    }

    public int getMinutesToAdd() {
        return this.addMinute;
    }

    public int getHoursToAdd() {
        return this.addHour;
    }

    public int getDaysToAdd() {
        return this.addDay;
    }

    public int getWeeksToAdd() {
        return this.addWeek;
    }

    public int getMonthsToAdd() {
        return this.addMonth;
    }

    public int getWeekDay() {
        return this.weekDay;
    }

    public int getWeekOrder() {
        return this.weekOrder;
    }

    public int getAbsoluteDay() {
        return this.absoluteDay;
    }

    public Date getInitialDate() {
        return this.initialDate;
    }

    public Date getFinalDate() {
        return this.finalDate;
    }

    public void setInitialTimeLimit(int hour, int minute) {
        this.initialHour = hour;
        this.initialMinute = minute;
    }

    public void setFinalTimeLimit(int hour, int minute) {
        this.finalHour = hour;
        this.finalMinute = minute;
    }

    public void setInitialDateLimit(int day, int month) {
        this.initialDay = day;
        this.initialMonth = month;
    }

    public void setFinalDateLimit(int day, int month) {
        this.finalDay = day;
        this.finalMonth = month;
    }

    public void setInitialDate(Date date) {
        this.initialDate = date;
    }

    public void setFinalDate(Date date) {
        this.finalDate = date;
    }

    public void setInitialDate(String date) {
        this.initialDate = new CheckDate(date).getDate();
    }

    public void setFinalDate(String date) {
        this.finalDate = new CheckDate(date).getDate();
    }

    public void setMinutesToAdd(int addMinute) {
        this.addMinute = addMinute;
    }

    public void setHoursToAdd(int addHour) {
        this.addHour = addHour;
    }

    public void setDaysToAdd(int addDay) {
        this.addDay = addDay;
    }

    public void setWeeksToAdd(int addWeek) {
        this.addWeek = addWeek;
    }

    public void setMonthsToAdd(int addMonth) {
        this.addMonth = addMonth;
    }

    public void setWeekDay(int weekDay, int order) {
        this.absoluteDay = 0;
        this.weekDay = weekDay;
        this.weekOrder = order;
    }

    public void setAbsoluteDay(int absoluteDay) {
        this.weekDay = -1;
        this.weekOrder = 0;
        this.absoluteDay = absoluteDay;
    }

    private void checkLimits() {
        if (this.date.compareHourMinute(this.initialHour, this.initialMinute) < 0) {
            this.initTime();
        } else if (this.date.compareHourMinute(this.finalHour, this.finalMinute) > 0) {
            this.date.addDays(1);
            this.initTime();
        }
        this.checkWeekDay();
        this.checkAbsoluteDay();
        while (!this.checkDateLimits()) {
            this.checkWeekDay();
            this.checkAbsoluteDay();
        }
    }

    private void checkWeekDay() {
        if (this.weekDay != -1) {
            this.date.setDayOfWeek(this.weekDay);
            if (this.weekOrder > 0) {
                while (Math.ceil((double)this.date.getDay() / 7.0) != (double)this.weekOrder) {
                    this.date.addWeeks(1);
                }
            }
        }
    }

    private void checkAbsoluteDay() {
        if (this.absoluteDay > 0) {
            while (this.date.getDay() != this.absoluteDay) {
                this.date.addDays(1);
            }
        }
    }

    private boolean checkDateLimits() {
        if (this.date.compareDayMonth(this.initialDay, this.initialMonth) < 0) {
            this.initDate();
            this.initTime();
            return false;
        }
        if (this.date.compareDayMonth(this.finalDay, this.finalMonth) > 0) {
            this.date.addYears(1);
            this.initDate();
            this.initTime();
            return false;
        }
        return true;
    }

    private void initTime() {
        this.date.setHourMinute(this.initialHour, this.initialMinute);
    }

    private void initDate() {
        this.date.setDay(1);
        this.date.setMonth(this.initialMonth);
        this.date.setDay(this.initialDay);
    }
}

