/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.forum;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class Forum {
    public ResultSet rs = null;
    public String errMsg;
    private PreparedStatement ps = null;
    private Connection con = null;
    private String libUsed;
    private String driver;
    private String user;
    private String password;
    private String url;

    public Forum(String lib, String driver, String user, String password, String url) {
        this.libUsed = lib;
        this.driver = driver;
        this.user = user;
        this.password = password;
        this.url = url;
        this.con = this.newConnection();
    }

    public void totalForum() {
        this.ps = null;
        try {
            this.ps = this.con.prepareStatement("select fidtheme, fday, fhour, flogin, ftheme, (select max(fday) from forums where fidtheme = d.fidtheme and flib = d.flib) as flast, (select count(*) from forums where fidtheme = d.fidtheme and flib = d.flib) as fcount from forums d where cast(fday + fhour as timestamp) = (select min(cast(fday + fhour as timestamp)) from forums where fidtheme = d.fidtheme and flib = d.flib) and flib = ? order by fday desc, fhour desc");
            this.ps.setString(1, this.libUsed);
            this.ps.execute();
            this.rs = this.ps.getResultSet();
        }
        catch (SQLException ex) {
            this.errMsg = ex.getMessage();
        }
    }

    public void theme(int idTheme) {
        this.ps = null;
        try {
            this.ps = this.con.prepareStatement("select fidtheme, fday, fhour, flogin, ftheme, ftext from forums where fidtheme = ? and flib = ? order by fday, fhour");
            this.ps.setInt(1, idTheme);
            this.ps.setString(2, this.libUsed);
            this.ps.execute();
            this.rs = this.ps.getResultSet();
        }
        catch (SQLException ex) {
            this.errMsg = ex.getMessage();
        }
    }

    public void insert(int idTheme, String login, String theme, String text) {
        this.ps = null;
        try {
            if (idTheme == -1) {
                try {
                    this.ps = this.con.prepareStatement("select min(fidTheme) - 1 from forums where flib = ?");
                    this.ps.setString(1, this.libUsed);
                    this.ps.execute();
                    this.ps.getResultSet().next();
                    idTheme = this.ps.getResultSet().getInt(1);
                    if (idTheme < 1) {
                        this.ps = this.con.prepareStatement("select max(fidTheme) + 1 from forums where flib = ?");
                        this.ps.setString(1, this.libUsed);
                        this.ps.execute();
                        this.ps.getResultSet().next();
                        idTheme = this.ps.getResultSet().getInt(1);
                    }
                }
                catch (SQLException ex) {
                    this.errMsg = ex.getMessage();
                }
            }
            if (idTheme < 1) {
                idTheme = 1;
            }
            this.ps = this.con.prepareStatement("insert into forums (flib, fidtheme, fday, fhour, flogin, ftheme, ftext) values (?, ?, ?, ?, ?, ?, ?)");
            this.ps.setString(1, this.libUsed);
            this.ps.setInt(2, idTheme);
            this.ps.setDate(3, new Date(Calendar.getInstance().getTime().getTime()));
            this.ps.setTime(4, new Time(Calendar.getInstance().getTime().getTime()));
            this.ps.setString(5, login);
            this.ps.setString(6, theme);
            this.ps.setString(7, text);
            this.ps.execute();
        }
        catch (SQLException ex) {
            this.errMsg = ex.getMessage();
        }
    }

    public void delete(int idTheme, String day, String hour, String login) {
        this.ps = null;
        try {
            this.ps = this.con.prepareStatement("delete from forums where fidtheme = ? and fday = ? and fhour = ? and flogin = ? and flib = ?");
            this.ps.setInt(1, idTheme);
            this.ps.setString(2, day);
            this.ps.setString(3, hour);
            this.ps.setString(4, login);
            this.ps.setString(5, this.libUsed);
            this.ps.execute();
        }
        catch (SQLException ex) {
            this.errMsg = ex.getMessage();
        }
    }

    public void disconnect() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException ex) {
            this.errMsg = ex.getMessage();
        }
    }

    private Connection newConnection() {
        Connection nova = null;
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            nova = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException ex) {
            this.errMsg = ex.getMessage();
            return null;
        }
        return nova;
    }
}

