/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.xml;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.amic.util.db.Converter;
import org.amic.util.xml.RecordPacked;
import org.amic.util.xml.TablePacked;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DBExport {
    private int visible;
    private boolean canInsert;
    private boolean canDelete;
    private boolean canUpdate;
    private boolean onlyModified;
    private String identifier;
    private Document doc;
    private Element root;
    private ResultSetMetaData rsm;

    public DBExport(String identifier) {
        this(identifier, false);
    }

    public DBExport(String identifier, boolean onlyModified) {
        this.identifier = identifier;
        this.onlyModified = onlyModified;
        this.visible = 0;
        this.canInsert = true;
        this.canDelete = true;
        this.canUpdate = true;
    }

    public void setData(ResultSet rs) throws SQLException, ParserConfigurationException {
        int recCount = 0;
        this.startDocument();
        this.setDataset(rs);
        Node data = this.root.appendChild(this.doc.createElement("data"));
        while (rs.next()) {
            Node rec = data.appendChild(this.doc.createElement("record"));
            ((Element)rec).setAttribute("number", String.valueOf(++recCount));
            int idx = 1;
            while (idx <= this.rsm.getColumnCount()) {
                Node col = rec.appendChild(this.doc.createElement(this.rsm.getColumnName(idx)));
                String temp = new Converter(rs.getObject(idx)).getString();
                if (temp.indexOf(60) > -1) {
                    col.appendChild(this.doc.createCDATASection(temp));
                } else {
                    col.appendChild(this.doc.createTextNode(temp));
                }
                ++idx;
            }
        }
    }

    public void setData(TablePacked tp) throws ParserConfigurationException {
        int recCount = 0;
        this.identifier = tp.getIdentifier();
        this.startDocument();
        this.setProperties(tp);
        this.setTablePacked(tp);
        Node data = this.root.appendChild(this.doc.createElement("data"));
        int r = 0;
        while (r < tp.getRowCount()) {
            RecordPacked record = tp.getRecord(r);
            if (!this.onlyModified || record.isModified()) {
                Node rec = data.appendChild(this.doc.createElement("record"));
                ((Element)rec).setAttribute("number", String.valueOf(++recCount));
                if (record.isInserted()) {
                    ((Element)rec).setAttribute("inserted", String.valueOf(true));
                }
                if (record.isUpdated()) {
                    ((Element)rec).setAttribute("updated", String.valueOf(true));
                }
                if (record.isDeleted()) {
                    ((Element)rec).setAttribute("deleted", String.valueOf(true));
                }
                int idx = 0;
                while (idx < tp.getFieldCount()) {
                    String temp;
                    Node col = rec.appendChild(this.doc.createElement(tp.getFieldName(idx)));
                    if (record.getOldValue(idx) != null && !record.getOldValue(idx).equals(record.getValue(idx))) {
                        ((Element)col).setAttribute("old-value", new Converter(record.getOldValue(idx)).getString());
                    }
                    if ((temp = new Converter(record.getValue(idx)).getString()).indexOf(60) > -1 || temp.indexOf(62) > -1) {
                        col.appendChild(this.doc.createCDATASection(temp));
                    } else {
                        col.appendChild(this.doc.createTextNode(temp));
                    }
                    ++idx;
                }
            }
            ++r;
        }
    }

    public String getDocument() {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + this.root.toString();
    }

    public void setVisibleFields(int value) {
        this.visible = value;
    }

    public void setCanInsert(boolean value) {
        this.canInsert = value;
    }

    public void setCanDelete(boolean value) {
        this.canDelete = value;
    }

    public void setCanUpdate(boolean value) {
        this.canUpdate = value;
    }

    private void addTableDescriptors(TablePacked tp, int index, Node col) {
        Object[] valid;
        Object form;
        String def;
        Object obj = tp.getFieldDefaultValue(index);
        if (obj != null && (def = new Converter(obj).getString()) != null) {
            ((Element)col).setAttribute("default", def);
        }
        if ((form = tp.getFieldFormat(index)) != null) {
            ((Element)col).setAttribute("format", form.toString());
        }
        if ((valid = tp.getFieldValids(index)) != null) {
            int i = 0;
            while (i < valid.length) {
                ((Element)col).setAttribute("valid-" + i, valid[i].toString());
                ++i;
            }
        }
    }

    private void setDataset(ResultSet rs) throws SQLException {
        Node col;
        Node desc = this.root.appendChild(this.doc.createElement("metadata"));
        if (this.visible > 0) {
            col = desc.appendChild(this.doc.createElement("visible"));
            col.appendChild(this.doc.createTextNode(this.visible + ""));
        }
        this.rsm = rs.getMetaData();
        int idx = 1;
        while (idx <= this.rsm.getColumnCount()) {
            String fieldName = this.rsm.getColumnName(idx);
            col = desc.appendChild(this.doc.createElement(fieldName));
            ((Element)col).setAttribute("label", this.rsm.getColumnLabel(idx));
            ((Element)col).setAttribute("table-name", this.rsm.getTableName(idx));
            ((Element)col).setAttribute("type", String.valueOf(this.rsm.getColumnType(idx)));
            ((Element)col).setAttribute("type-name", this.rsm.getColumnTypeName(idx));
            ((Element)col).setAttribute("display-size", String.valueOf(this.rsm.getColumnDisplaySize(idx)));
            ((Element)col).setAttribute("precision", String.valueOf(this.rsm.getPrecision(idx)));
            ((Element)col).setAttribute("scale", String.valueOf(this.rsm.getScale(idx)));
            ((Element)col).setAttribute("is-currency", String.valueOf(this.rsm.isCurrency(idx)));
            ++idx;
        }
    }

    private void setTablePacked(TablePacked tp) {
        Node col;
        Node desc = this.root.appendChild(this.doc.createElement("metadata"));
        if (tp.getVisibleFieldCount() != tp.getFieldCount()) {
            col = desc.appendChild(this.doc.createElement("visible"));
            col.appendChild(this.doc.createTextNode(tp.getVisibleFieldCount() + ""));
        }
        int idx = 0;
        while (idx < tp.getFieldCount()) {
            col = desc.appendChild(this.doc.createElement(tp.getFieldName(idx)));
            ((Element)col).setAttribute("label", tp.getFieldLabel(idx));
            ((Element)col).setAttribute("table-name", "");
            ((Element)col).setAttribute("type", String.valueOf(tp.getFieldType(idx)));
            ((Element)col).setAttribute("type-name", tp.getFieldTypeName(idx));
            ((Element)col).setAttribute("display-size", String.valueOf(tp.getFieldDisplaySize(idx)));
            ((Element)col).setAttribute("precision", String.valueOf(tp.getFieldPrecision(idx)));
            ((Element)col).setAttribute("scale", String.valueOf(tp.getFieldScale(idx)));
            ((Element)col).setAttribute("is-currency", String.valueOf(tp.isFieldCurrency(idx)));
            ((Element)col).setAttribute("is-editable", String.valueOf(tp.isFieldEditable(idx)));
            if (!this.onlyModified) {
                this.addTableDescriptors(tp, idx, col);
            }
            ++idx;
        }
    }

    private void setProperties(TablePacked tp) {
        if (!tp.hasProperties()) {
            return;
        }
        Enumeration enumeration = tp.getPropertyKeys();
        Node desc = this.root.appendChild(this.doc.createElement("properties"));
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Node col = desc.appendChild(this.doc.createElement(key));
            Object value = tp.getProperty(key);
            if (!(value instanceof String)) {
                ((Element)col).setAttribute("class", value.getClass().getName());
            }
            if (value.toString().indexOf(60) > -1 || value.toString().indexOf(62) > -1) {
                col.appendChild(this.doc.createCDATASection(value.toString()));
                continue;
            }
            col.appendChild(this.doc.createTextNode(value.toString()));
        }
    }

    private void startDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
        this.root = this.doc.createElement(this.identifier);
        this.doc.appendChild(this.root);
        this.root.setAttribute("can-insert", String.valueOf(this.canInsert));
        this.root.setAttribute("can-delete", String.valueOf(this.canDelete));
        this.root.setAttribute("can-update", String.valueOf(this.canUpdate));
    }
}

