/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;

public class DwgCircle
extends DwgObject
implements IDwgExtrusionable,
IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private double[] center;
    private double radius;
    private double thickness;
    private double[] extrusion;

    public DwgCircle(int index) {
        super(index);
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public void applyExtrussion() {
        double[] circleCenter = this.getCenter();
        double[] circleExt = this.getExtrusion();
        circleCenter = AcadExtrusionCalculator.extrude2(circleCenter, circleExt);
        this.setCenter(circleCenter);
    }

    @Override
    public boolean has3DData() {
        return this.getCenter()[2] != 0.0;
    }

    @Override
    public double getZ() {
        return this.getCenter()[2];
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        double[] c = this.getCenter();
        double radius = Math.abs(this.getRadius());
        Circle circle = (Circle)gMan.create(this.getGeometryType(), this.getGeometrySubType(is3DFile));
        Point center = (Point)gMan.create(1, this.getGeometrySubType(is3DFile));
        center.setCoordinates(c);
        circle.setPoints(center, radius);
        return circle;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "Circle";
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        DwgCircle transformedEntity = null;
        double[] center = this.getCenter();
        Point2D.Double pointAux = new Point2D.Double(center[0] - bPoint[0], center[1] - bPoint[1]);
        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double laZ = center[2] * scale[2];
        double[] transformedCenter = new double[]{laX, laY, laZ};
        double radius = this.getRadius();
        double transformedRadius = radius * scale[0];
        transformedEntity = (DwgCircle)this.clone();
        transformedEntity.setCenter(transformedCenter);
        transformedEntity.setRadius(transformedRadius);
        dwgObjectsWithoutBlocks.add(transformedEntity);
        handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
    }

    @Override
    public Object clone() {
        DwgCircle obj = new DwgCircle(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgCircle myObj = (DwgCircle)obj;
        myObj.setCenter(this.center);
        myObj.setExtrusion(this.extrusion);
        myObj.setRadius(this.radius);
        myObj.setThickness(this.thickness);
    }

    @Override
    public int getGeometrySubType(boolean is3DFile) {
        if (is3DFile) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getGeometryType() {
        return 11;
    }
}

