/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;

public class DwgInsert
extends DwgObject
implements IDwgExtrusionable,
IDwg3DTestable,
IDwgBlockMember {
    private double[] insertionPoint;
    private double[] scale;
    private double rotation;
    private double[] extrusion;
    private DwgHandleReference blockHeaderHandle = null;
    private DwgHandleReference firstAttribHandle = null;
    private DwgHandleReference lastAttribHandle = null;
    private DwgHandleReference seqendHandle = null;
    private ArrayList ownedObjectsHandles = new ArrayList();
    private boolean processed = false;

    public DwgInsert(int index) {
        super(index);
    }

    public void dump() {
        System.out.println("<Insert>");
        System.out.println("<inspoint x=" + this.insertionPoint[0] + " y=" + this.insertionPoint[1] + " z=" + this.insertionPoint[2] + ">");
        System.out.println("<scale x=" + this.scale[0] + " y=" + this.scale[1] + " z=" + this.scale[2] + ">");
        System.out.println("<rotation rot=" + this.rotation + " >");
        System.out.println("</Insert>");
    }

    public DwgHandleReference getBlockHeaderHandle() {
        return this.blockHeaderHandle;
    }

    public void setBlockHeaderHandle(DwgHandleReference blockHeaderHandle) {
        this.blockHeaderHandle = blockHeaderHandle;
    }

    public DwgHandleReference getFirstAttribHandle() {
        return this.firstAttribHandle;
    }

    public void setFirstAttribHandle(DwgHandleReference firstAttribHandle) {
        this.firstAttribHandle = firstAttribHandle;
    }

    public double[] getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(double[] insertionPoint) {
        this.insertionPoint = insertionPoint;
    }

    public DwgHandleReference getLastAttribHandle() {
        return this.lastAttribHandle;
    }

    public void setLastAttribHandle(DwgHandleReference lastAttribHandle) {
        this.lastAttribHandle = lastAttribHandle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public double[] getScale() {
        return this.scale;
    }

    public void setScale(double[] scale) {
        this.scale = scale;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    public DwgHandleReference getSeqendHandle() {
        return this.seqendHandle;
    }

    public void setSeqendHandle(DwgHandleReference seqendHandle) {
        this.seqendHandle = seqendHandle;
    }

    public ArrayList getOwnedObjectsHandles() {
        return this.ownedObjectsHandles;
    }

    public void setOwnedObjectsHandles(ArrayList handles) {
        this.ownedObjectsHandles = handles;
    }

    public void addOwnedObjectHandle(DwgHandleReference handle) {
        this.ownedObjectsHandles.add(handle);
    }

    @Override
    public void applyExtrussion() {
        double[] insertPoint = this.getInsertionPoint();
        double[] insertExt = this.getExtrusion();
        insertPoint = AcadExtrusionCalculator.extrude2(insertPoint, insertExt);
        this.setInsertionPoint(insertPoint);
    }

    @Override
    public boolean has3DData() {
        return this.getInsertionPoint()[2] != 0.0;
    }

    @Override
    public double getZ() {
        return this.getInsertionPoint()[2];
    }

    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        double[] p = this.getInsertionPoint();
        Point point = (Point)gMan.create(this.getGeometryType(), this.getGeometrySubType(is3DFile));
        point.setCoordinates(p);
        return point;
    }

    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPoint3D";
        }
        return "FPoint2D";
    }

    public String toString() {
        return "Insert";
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handle_objWithoutBlocks, DwgFile callBack) {
        this.processed = true;
        double[] p = this.getInsertionPoint();
        Point2D.Double point = new Point2D.Double(p[0], p[1]);
        double[] newScale = this.getScale();
        double newRot = this.getRotation();
        DwgHandleReference newBlockHandle = this.getBlockHeaderHandle();
        Point2D.Double pointAux = new Point2D.Double(((Point2D)point).getX() - bPoint[0], ((Point2D)point).getY() - bPoint[1]);
        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double laZ = p[2] * scale[2];
        Point2D.Double newInsPoint = new Point2D.Double(laX, laY);
        newScale = new double[]{scale[0] * newScale[0], scale[1] * newScale[1], scale[2] * newScale[2]};
        if ((newRot += rot) < 0.0) {
            newRot += Math.PI * 2;
        } else if (newRot > Math.PI * 2) {
            newRot -= Math.PI * 2;
        }
        callBack.manageInsert2(newInsPoint, newScale, newRot, newBlockHandle.getOffset(), dwgObjectsWithoutBlocks, handle_objWithoutBlocks);
    }

    @Override
    public Object clone() {
        DwgInsert obj = new DwgInsert(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgInsert myObj = (DwgInsert)obj;
        myObj.setBlockHeaderHandle(this.blockHeaderHandle);
        myObj.setExtrusion(this.extrusion);
        myObj.setFirstAttribHandle(this.firstAttribHandle);
        myObj.setInsertionPoint(this.insertionPoint);
        myObj.setLastAttribHandle(this.lastAttribHandle);
        myObj.setRotation(this.rotation);
        myObj.setScale(this.scale);
        myObj.setSeqendHandle(this.seqendHandle);
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public int getGeometryType() {
        return 1;
    }
}

