/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;

public class DwgPoint
extends DwgObject
implements IDwg3DTestable,
IDwg2FMap {
    private double[] point;
    private double thickness;
    private double[] extrusion;
    private double xAxisAngle;

    public DwgPoint(int index) {
        super(index);
    }

    public double[] getPoint() {
        return this.point;
    }

    public void setPoint(double[] point) {
        this.point = point;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double getXAxisAngle() {
        return this.xAxisAngle;
    }

    public void setXAxisAngle(double axisAngle) {
        this.xAxisAngle = axisAngle;
    }

    public void applyExtrussion() {
        double[] point = this.getPoint();
        double[] pointExt = this.getExtrusion();
        point = AcadExtrusionCalculator.extrude2(point, pointExt);
        this.setPoint(point);
    }

    @Override
    public boolean has3DData() {
        return this.getPoint()[2] != 0.0;
    }

    @Override
    public double getZ() {
        return this.getPoint()[2];
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        double[] p = this.getPoint();
        Point point = (Point)gMan.create(this.getGeometryType(), this.getGeometrySubType(is3DFile));
        point.setCoordinates(p);
        return point;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPoint3D";
        }
        return "FPoint2D";
    }

    @Override
    public String toString() {
        return "Point";
    }

    @Override
    public Object clone() {
        DwgPoint obj = new DwgPoint(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgPoint myObj = (DwgPoint)obj;
        myObj.setExtrusion(this.extrusion);
        myObj.setPoint(this.point);
        myObj.setThickness(this.thickness);
        myObj.setXAxisAngle(this.xAxisAngle);
    }

    @Override
    public int getGeometryType() {
        return 1;
    }
}

