/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgClass2004;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgObjectFactory;
import org.gvsig.dwg.lib.DwgObjectOffset;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.readers.DwgObjectReaderPool;
import org.gvsig.dwg.lib.readers.Gap;
import org.gvsig.dwg.lib.readers.IDwgFileReader;
import org.gvsig.dwg.lib.readers.IDwgObjectReader;
import org.gvsig.dwg.lib.readers.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwgFileVR2004Reader
implements IDwgFileReader {
    protected DwgFile dwgFile;
    protected ByteBuffer bb;
    static byte[] magicNumber = null;
    private String version = "";
    private byte[] unknowSixBytes;
    private byte[] threeBytes0;
    private byte[] unknowTwoBytes;
    private byte[] eightyTwoBytes0;
    private byte[] encryptedData;
    private byte[] decryptedData;
    private String fileID = "";
    private int rootTreeNodeGap;
    private int lowermostLeftTreeNodeGap;
    private int lowermostRightTreeNodeGap;
    private int lastSectionId;
    private int lastSectionAddress;
    private int SecondHeaderAddress;
    private int gapAmount;
    private int sectionAmount;
    private int sectionMapId;
    private int sectionMapAddress;
    private int sectionInfoId;
    private int sectionInfoIndex = 0;
    private int sectionArraySize;
    private int gapArraySize;
    private byte[] generatedSequence;
    private Section[] sections;
    private Gap[] gaps;
    static final int TYPE_SECTION_MAP = 1;
    static final int TYPE_SECTION_INFO = 2;
    private static Logger logger = LoggerFactory.getLogger((String)DwgFileVR2004Reader.class.getName());

    @Override
    public void read(DwgFile dwgFile, ByteBuffer bb) throws IOException {
        this.dwgFile = dwgFile;
        this.bb = bb;
        this.readDwgR2004FileHeader(bb);
        this.readDwgR2004SectionMap(bb);
        this.readDwgR2004InfoSection(bb);
        this.readDwgR2004Headers(bb);
        this.readDwgR2004Classes(bb);
        this.readDwgR2004ObjectOffsets(bb);
        this.readDwgR2004Objects();
    }

    protected void readDwgR2004InfoSection(ByteBuffer bb) {
        String sectionName = "";
        if (this.sectionInfoIndex == 0) {
            logger.trace("No se ha encontrado la Section Info en el array de secciones.");
        }
        int pos = this.sections[this.sectionInfoIndex].getAddress();
        bb.position(pos);
        ByteBuffer dData = this.readSystemSection(bb);
        dData.order(ByteOrder.LITTLE_ENDIAN);
        dData.position(0);
        int numDescriptions = dData.getInt();
        dData.getInt();
        dData.getInt();
        dData.getInt();
        dData.getInt();
        for (int i = 0; i < numDescriptions; ++i) {
            int sizeOfSection = dData.getInt();
            dData.getInt();
            int numSections = dData.getInt();
            int maxDecompressedSize = dData.getInt();
            dData.getInt();
            int compressed = dData.getInt();
            int sectionType = dData.getInt();
            int encrypted = dData.getInt();
            sectionName = "";
            for (int j = 0; j < 64; ++j) {
                char c = (char)dData.get();
                sectionName = sectionName + c;
            }
            for (int k = 0; k < numSections; ++k) {
                int sectionNumber = dData.getInt();
                int dataSize = dData.getInt();
                int startOffset = dData.getInt();
                dData.getInt();
                for (int j = 0; j < this.sectionAmount; ++j) {
                    Section section = this.sections[j];
                    if (section.getNumber() != sectionNumber) continue;
                    section.setName(sectionName);
                    section.setSizeOfLogicalSection(sizeOfSection);
                    section.setDataSize(dataSize);
                    section.setMaxDecompressedSize(maxDecompressedSize);
                    section.setCompressed(compressed);
                    section.setType(sectionType);
                    section.setEncrypted(encrypted);
                    section.setStartOffset(startOffset);
                }
            }
        }
    }

    protected void readDwgR2004FileHeader(ByteBuffer bb) {
        int i;
        logger.trace("STARTING TO READ DWG FILE.");
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i2 = 0; i2 < 6; ++i2) {
            this.version = this.version + (char)bb.get();
        }
        if (!this.version.equalsIgnoreCase("AC1018")) {
            logger.trace("Error en la version: " + this.version);
        }
        this.unknowSixBytes = new byte[6];
        int pos = 6;
        for (i = 0; i < 5; ++i) {
            this.unknowSixBytes[i] = bb.get();
            if (this.unknowSixBytes[i] == 0) continue;
            logger.trace("(unknowSixBytes) En la posicion 0x" + Integer.toHexString(pos + i) + " deber\u00c3\u00ada haber un 0, pero hay un 0x" + Integer.toHexString(this.unknowSixBytes[i]));
        }
        pos = 11;
        this.unknowSixBytes[5] = bb.get();
        if (this.unknowSixBytes[5] != 76) {
            logger.trace("(unknowSixBytes) En la posicion 0x" + Integer.toHexString(pos) + " deber\u00c3\u00ada haber un 0x4C, pero hay un 0x" + Integer.toHexString(this.unknowSixBytes[5]));
        }
        bb.get();
        bb.getInt();
        bb.get();
        bb.get();
        bb.getShort();
        this.threeBytes0 = new byte[3];
        pos = 21;
        bb.get(this.threeBytes0);
        if (this.threeBytes0[0] != 0) {
            logger.trace("Posible error leyendo la cabecera del archivo DWG: En la posicion 0x" + Integer.toHexString(pos) + " deber\u00eda haber un 0x0, pero hay un 0x" + Integer.toHexString(this.threeBytes0[0]));
        }
        pos = 22;
        if (this.threeBytes0[1] != 25) {
            logger.trace("Posible error leyendo la cabecera del archivo DWG: En la posicion 0x" + Integer.toHexString(pos) + " deber\u00eda haber un 0x19, pero hay un 0x" + Integer.toHexString(this.threeBytes0[1]));
        }
        pos = 23;
        if (this.threeBytes0[2] != 76) {
            logger.trace("Posible error leyendo la cabecera del archivo DWG: En la posicion 0x" + Integer.toHexString(pos) + " deber\u00eda haber un 0x4C, pero hay un 0x" + Integer.toHexString(this.threeBytes0[2]));
        }
        bb.getInt();
        bb.getInt();
        bb.getInt();
        bb.getInt();
        bb.getInt();
        pos = 44;
        this.unknowTwoBytes = new byte[2];
        for (i = 0; i < 2; ++i) {
            this.unknowTwoBytes[i] = bb.get();
        }
        pos = 46;
        this.eightyTwoBytes0 = new byte[82];
        for (i = 0; i < this.eightyTwoBytes0.length; ++i) {
            this.eightyTwoBytes0[i] = bb.get();
            if (this.eightyTwoBytes0[i] == 0) continue;
            logger.trace("Posible error leyendo la cabecera del archivo DWG: (eightyTwoBytes0) En la posicion 0x" + Integer.toHexString(pos + i) + " deber\u00eda haber un 0, pero hay un 0x" + Integer.toHexString(this.eightyTwoBytes0[i]));
        }
        int len = 108;
        this.encryptedData = new byte[len];
        this.decryptedData = new byte[len];
        if (magicNumber == null) {
            DwgFileVR2004Reader.setMagicNumber();
        }
        for (int i3 = 0; i3 < len; ++i3) {
            this.encryptedData[i3] = bb.get();
            this.decryptedData[i3] = (byte)(this.encryptedData[i3] ^ magicNumber[i3]);
        }
        ByteBuffer decryptedDataBB = ByteBuffer.allocate(len);
        decryptedDataBB.put(this.decryptedData);
        decryptedDataBB.position(0);
        decryptedDataBB.order(ByteOrder.LITTLE_ENDIAN);
        for (int i4 = 0; i4 < 12; ++i4) {
            this.fileID = this.fileID + (char)decryptedDataBB.get();
        }
        decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        this.rootTreeNodeGap = decryptedDataBB.getInt();
        this.lowermostLeftTreeNodeGap = decryptedDataBB.getInt();
        this.lowermostRightTreeNodeGap = decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        this.lastSectionId = decryptedDataBB.getInt();
        this.lastSectionAddress = decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        this.SecondHeaderAddress = decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        this.gapAmount = decryptedDataBB.getInt();
        this.sectionAmount = decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        this.sectionMapId = decryptedDataBB.getInt();
        this.sectionMapAddress = decryptedDataBB.getInt() + 256;
        decryptedDataBB.getInt();
        this.sectionInfoId = decryptedDataBB.getInt();
        this.sectionArraySize = decryptedDataBB.getInt();
        this.gapArraySize = decryptedDataBB.getInt();
        decryptedDataBB.getInt();
        len = 20;
        this.generatedSequence = new byte[len];
        bb.get(this.generatedSequence);
    }

    private void readDwgR2004Headers(ByteBuffer bb) {
        ByteBuffer decompressedBB = this.readSection(bb, "AcDb:Header");
        byte[] sentinel = new byte[16];
        decompressedBB.order(ByteOrder.nativeOrder());
        decompressedBB.position(0);
        decompressedBB.get(sentinel);
        if ((sentinel[0] & 0xFF) != 207) {
            logger.trace("sentinel[0] != 0xcf found " + (sentinel[0] & 0xFF));
        }
        if ((sentinel[1] & 0xFF) != 123) {
            logger.trace("sentinel[1] != 0x7b found " + (sentinel[1] & 0xFF));
        }
        if ((sentinel[2] & 0xFF) != 31) {
            logger.trace("sentinel[2] != 0x1f found " + (sentinel[2] & 0xFF));
        }
        if ((sentinel[3] & 0xFF) != 35) {
            logger.trace("sentinel[3] != 0x23 found " + (sentinel[3] & 0xFF));
        }
        if ((sentinel[4] & 0xFF) != 253) {
            logger.trace("sentinel[4] != 0xfd found " + (sentinel[4] & 0xFF));
        }
        if ((sentinel[5] & 0xFF) != 222) {
            logger.trace("sentinel[5] != 0xde found " + (sentinel[5] & 0xFF));
        }
        if ((sentinel[6] & 0xFF) != 56) {
            logger.trace("sentinel[6] != 0x38 found " + (sentinel[6] & 0xFF));
        }
        if ((sentinel[7] & 0xFF) != 169) {
            logger.trace("sentinel[7] != 0xa9 found " + (sentinel[7] & 0xFF));
        }
        if ((sentinel[8] & 0xFF) != 95) {
            logger.trace("sentinel[8] != 0x5f found " + (sentinel[8] & 0xFF));
        }
        if ((sentinel[9] & 0xFF) != 124) {
            logger.trace("sentinel[9] != 0x7c found " + (sentinel[9] & 0xFF));
        }
        if ((sentinel[10] & 0xFF) != 104) {
            logger.trace("sentinel[10] != 0x68 found " + (sentinel[10] & 0xFF));
        }
        if ((sentinel[11] & 0xFF) != 184) {
            logger.trace("sentinel[11] != 0xb8 found " + (sentinel[11] & 0xFF));
        }
        if ((sentinel[12] & 0xFF) != 78) {
            logger.trace("sentinel[12] != 0x4e found " + (sentinel[12] & 0xFF));
        }
        if ((sentinel[13] & 0xFF) != 109) {
            logger.trace("sentinel[13] != 0x6d found " + (sentinel[13] & 0xFF));
        }
        if ((sentinel[14] & 0xFF) != 51) {
            logger.trace("sentinel[14] != 0x33 found " + (sentinel[14] & 0xFF));
        }
        if ((sentinel[15] & 0xFF) != 95) {
            logger.trace("sentinel[15] != 0x5f found " + (sentinel[15] & 0xFF));
        }
        decompressedBB.order(ByteOrder.LITTLE_ENDIAN);
        int size = decompressedBB.getInt();
        decompressedBB.order(ByteOrder.nativeOrder());
        byte[] data = new byte[size];
        decompressedBB.get(data);
        int[] intData = DwgUtil.toIntArray(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        decompressedBB.getShort();
        decompressedBB.order(ByteOrder.nativeOrder());
        byte[] lastSentinnel = new byte[16];
        decompressedBB.get(lastSentinnel);
        if ((lastSentinnel[0] & 0xFF) != 48) {
            logger.trace("lastSentinnel[0] != 0x30 , is: " + lastSentinnel[0]);
        }
        if ((lastSentinnel[1] & 0xFF) != 132) {
            logger.trace("lastSentinnel[1] != 0x84 , is: " + lastSentinnel[1]);
        }
        if ((lastSentinnel[2] & 0xFF) != 224) {
            logger.trace("lastSentinnel[2] != 0xe0 , is: " + lastSentinnel[2]);
        }
        if ((lastSentinnel[3] & 0xFF) != 220) {
            logger.trace("lastSentinnel[3] != 0xdc , is: " + lastSentinnel[3]);
        }
        if ((lastSentinnel[4] & 0xFF) != 2) {
            logger.trace("lastSentinnel[4] != 0x02 , is: " + lastSentinnel[4]);
        }
        if ((lastSentinnel[5] & 0xFF) != 33) {
            logger.trace("lastSentinnel[5] != 0x21 , is: " + lastSentinnel[5]);
        }
        if ((lastSentinnel[6] & 0xFF) != 199) {
            logger.trace("lastSentinnel[6] != 0xc7 , is: " + lastSentinnel[6]);
        }
        if ((lastSentinnel[7] & 0xFF) != 86) {
            logger.trace("lastSentinnel[7] != 0x56 , is: " + lastSentinnel[7]);
        }
        if ((lastSentinnel[8] & 0xFF) != 160) {
            logger.trace("lastSentinnel[8] != 0xa0 , is: " + lastSentinnel[8]);
        }
        if ((lastSentinnel[9] & 0xFF) != 131) {
            logger.trace("lastSentinnel[9] != 0x83 , is: " + lastSentinnel[9]);
        }
        if ((lastSentinnel[10] & 0xFF) != 151) {
            logger.trace("lastSentinnel[10] != 0x97 , is: " + lastSentinnel[10]);
        }
        if ((lastSentinnel[11] & 0xFF) != 71) {
            logger.trace("lastSentinnel[11] != 0x47 , is: " + lastSentinnel[11]);
        }
        if ((lastSentinnel[12] & 0xFF) != 177) {
            logger.trace("lastSentinnel[12] != 0xb1 , is: " + lastSentinnel[12]);
        }
        if ((lastSentinnel[13] & 0xFF) != 146) {
            logger.trace("lastSentinnel[13] != 0x92 , is: " + lastSentinnel[13]);
        }
        if ((lastSentinnel[14] & 0xFF) != 204) {
            logger.trace("lastSentinnel[14] != 0xcc , is: " + lastSentinnel[14]);
        }
        if ((lastSentinnel[15] & 0xFF) != 160) {
            logger.trace("lastSentinnel[15] != 0xa0 , is: " + lastSentinnel[15]);
        }
        int bitPos = 0;
        try {
            ArrayList val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL1", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL2", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL3", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VAL4", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING1", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING2", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING3", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STRING4", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LONG1", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LONG2", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMASO", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSHO", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PLINEGEN", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ORTHOMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("REGENMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FILLMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("QTEXTMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PSLTSCALE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LIMCHECK", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNDOCUMENTED1", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USER_TIMER", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SKPOLY", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ANGDIR", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SPLFRAME", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MIRRTEXT", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("WORLDVIEW", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TILEMODE", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PLIMCHECK", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VISRETAIN", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DISPSILH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PELLISE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PROXYGRAPH", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TREEDEPTH", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LUNITS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LUPREC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("AUNITS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("AUPREC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ATTMODE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PDMODE", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNKNOWN1", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNKNOWN2", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNKNOWN3", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI1", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI3", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI4", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERI5", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SPLINESEGS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFU", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFV", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFTYPE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFTAB1", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SURFTAB2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SPLINETYPE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SHADEDGE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SHADEDIF", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNITMODE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MAXACTVP", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ISOLINES", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CMLJUST", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TEXTQLTY", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("LTSCALE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TEXTSIZE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("TRACEWID", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SKETCHINC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FILLETRAD", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("THICKNESS", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("ANGBASE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PDSIZE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PLINEWID", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR1", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR2", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR3", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR4", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("USERR5", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERA", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERB", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CHAMFERD", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FACETRES", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CMLSCALE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CELTSCALE", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MENUNAME", val.get(1));
            int[] tdcreate = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdcreate[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdcreate[1] = (Integer)val.get(1);
            this.dwgFile.setHeader("TDCREATE", tdcreate);
            int[] tdupdate = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdupdate[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdupdate[1] = (Integer)val.get(1);
            this.dwgFile.setHeader("TDUPDATE", tdupdate);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNKNOWN4", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNKNOWN5", val.get(1));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UNKNOWN6", val.get(1));
            int[] tdindwg = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdindwg[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdindwg[1] = (Integer)val.get(1);
            int[] tdusrtime = new int[2];
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdusrtime[0] = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            tdusrtime[1] = (Integer)val.get(1);
            this.dwgFile.setHeader("TDUSRTIME", tdusrtime);
            val = DwgUtil.getCmColor(intData, bitPos, this.dwgFile.getDwgVersion());
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CECOLOR", val.get(1));
            this.dwgFile.setHeader("CECOLOR_RGBVALUE", val.get(2));
            Object cecolorColorByte = val.get(3);
            this.dwgFile.setHeader("CECOLOR_COLORBYTE", cecolorColorByte);
            this.dwgFile.setHeader("CECOLOR_NAME", val.get(4));
            this.dwgFile.getDwgVersion();
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("HANDSEED", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("CLAYER", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("TEXSTYLE", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("CELLTYPE", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMSTYLE", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("CMLSTYLE", new Integer(intHandle));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PSVPSCALE", val.get(1));
            double[] spaces1 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces1[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces1[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces1[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_INSBASE", spaces1);
            double[] spaces2 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces2[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces2[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces2[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_EXTMIN", spaces2);
            double[] spaces3 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces3[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces3[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces3[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_EXTMAX", spaces2);
            double[] spaces4 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces4[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces4[1] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_LIMMIN", spaces4);
            double[] spaces5 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces5[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces5[1] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_LIMMAX", spaces5);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PSPACE_ELEVATION", val.get(1));
            double[] spaces6 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces6[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces6[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces6[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_UCSORG", spaces6);
            double[] spaces7 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces7[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces7[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces7[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_UCSXDIR", spaces7);
            double[] spaces8 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces8[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces8[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces8[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PSPACE_UCSYDIR", spaces8);
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PSPACE_UCSNAME", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PUCSBASE", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PUCSORTHOVIEW", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PUCSORTHOREF", new Integer(intHandle));
            double[] pucsorgtop = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgtop[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgtop[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgtop[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGTOP", pucsorgtop);
            double[] pucsorgbottom = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgbottom[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgbottom[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgbottom[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGBOTTOM", pucsorgbottom);
            double[] pucsorgleft = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgleft[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgleft[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgleft[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGLEFT", pucsorgleft);
            double[] pucsorgright = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgright[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgright[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgright[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGRIGHT", pucsorgright);
            double[] pucsorgfront = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgfront[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgfront[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgfront[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGFRONT", pucsorgfront);
            double[] pucsorgback = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgback[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgback[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            pucsorgback[2] = (Double)val.get(1);
            this.dwgFile.setHeader("PUCSORGBACK", pucsorgback);
            double[] spaces9 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces9[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces9[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces9[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_INSBASE", spaces9);
            double[] spaces10 = new double[6];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces10[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces10[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces10[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_EXTMIN", spaces10);
            double[] spaces11 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces11[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces11[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces11[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_EXTMAX", spaces11);
            double[] spaces12 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces12[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces12[1] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_LIMMIN", spaces12);
            double[] spaces13 = new double[2];
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces13[0] = (Double)val.get(1);
            val = DwgUtil.getRawDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces13[1] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_LIMMAX", spaces13);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("MSPACE_ELEVATION", (Double)val.get(1));
            double[] spaces14 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces14[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces14[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces14[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_UCSORG", spaces14);
            double[] spaces15 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces15[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces15[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces15[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_UCSXDIR", spaces15);
            double[] spaces16 = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces16[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces16[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            spaces16[2] = (Double)val.get(1);
            this.dwgFile.setHeader("MSPACE_UCSYDIR", spaces16);
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("MSPACE_UCSNAME", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("UCSBASE", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("UCSORTHOVIEW", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("UCSORTHOREF", new Integer(intHandle));
            double[] ucsorgtop = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgtop[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgtop[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgtop[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGTOP", ucsorgtop);
            double[] ucsorgbottom = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgbottom[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgbottom[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgbottom[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGBOTTOM", ucsorgbottom);
            double[] ucsorgleft = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgleft[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgleft[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgleft[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGLEFT", ucsorgleft);
            double[] ucsorgright = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgright[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgright[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgright[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGRIGHT", ucsorgright);
            double[] ucsorgfront = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgfront[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgfront[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgfront[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGFRONT", ucsorgfront);
            double[] ucsorgback = new double[3];
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgback[0] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgback[1] = (Double)val.get(1);
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            ucsorgback[2] = (Double)val.get(1);
            this.dwgFile.setHeader("UCSORGBACK", ucsorgback);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMPOST", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAPOST", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSCALE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMASZ", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMEXO", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDLI", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMEXE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAND", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDLE", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTP", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTM", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOL", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLIM", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTIH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSE1", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSE2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTAD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMZIN", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAZIN", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTXT", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCEN", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSZ", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTF", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLFAC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTVP", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTFAC", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMGAP", val.get(1));
            val = DwgUtil.getBitDouble(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTRND", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTD", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOFL", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSAH", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTIX", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSOXD", val.get(1));
            val = DwgUtil.getCmColor(intData, bitPos, this.dwgFile.getDwgVersion());
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCLRD", val.get(1));
            this.dwgFile.setHeader("DIMCLRD_RGBVALUE", val.get(2));
            Object dimclrdColorByte = val.get(3);
            this.dwgFile.setHeader("DIMCLRD_COLORBYTE", dimclrdColorByte);
            this.dwgFile.setHeader("DIMCLRD_NAME", val.get(4));
            val = DwgUtil.getCmColor(intData, bitPos, this.dwgFile.getDwgVersion());
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCLRE", val.get(1));
            this.dwgFile.setHeader("DIMCLRE_RGBVALUE", val.get(2));
            Object dimclreColorByte = val.get(3);
            this.dwgFile.setHeader("DIMCLRE_COLORBYTE", dimclreColorByte);
            this.dwgFile.setHeader("DIMCLRE_NAME", val.get(4));
            val = DwgUtil.getCmColor(intData, bitPos, this.dwgFile.getDwgVersion());
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMCLRT", val.get(1));
            this.dwgFile.setHeader("DIMCLRT_RGBVALUE", val.get(2));
            Object dimclrtColorByte = val.get(3);
            this.dwgFile.setHeader("DIMCLRT_COLORBYTE", dimclrtColorByte);
            this.dwgFile.setHeader("DIMCLRT_NAME", val.get(4));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMADEC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDEC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTDEC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTU", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTTD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMAUNIT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMFRAC", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLUNIT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMDSEP", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTMOVE", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMJUST", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSD1", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMSD2", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTOLJ", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMTZIN", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTZ", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMALTTZ", val.get(1));
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMUPT", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMFIT", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMTXTSTY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMLDRBLK", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMBLK", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMBLK1", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMBLK2", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLWD", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMLWE", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("BLOCK_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LAYER_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("STYLE_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LINETYPE_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("VIEW_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("UCS_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("VPORT_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("APPID_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("DIMSTYLE_CONTROL_OBJECT", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("ACAD_GROUP_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("ACAD_MLINE_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("NAMED_OBJECT_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("HYPERLINKBASE", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("STYLESHEET", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LAYOUT_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PLOT_SETTINGS_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PLOT_STYLES_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("MATERIALS_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("COLORS_DICTIONARY", new Integer(intHandle));
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FLAGS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("INSUNITS", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("CEPSNTYPE", val.get(1));
            if ((Integer)val.get(1) == 3) {
                val = DwgUtil.getHandle(intData, bitPos);
                bitPos = (Integer)val.get(0);
                intHandle = DwgUtil.handleToInt(val);
                this.dwgFile.setHeader("CPSNID", new Integer(intHandle));
            }
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("FINGERPRINTGUID", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("VERSIONGUID", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("SORTENTS", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("INDEXCTL", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("HIDETEXT", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("XCLIPFRAME", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("DIMASSOC", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("HALOGAP", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("OBSCUREDCOLOR", val.get(1));
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("INTERSECTION_COLOR", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("OBSCUREDLTYPE", val.get(1));
            val = DwgUtil.getRawChar(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("INTERSECTION_DISPLAY", val.get(1));
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            this.dwgFile.setHeader("PROJECTNAME", val.get(1));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("PAPER_BLOCK_RECORD", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("MODEL_BLOCK_RECORD", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LTYPE_BYLAYER", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LTYPE_BYBLOCK", new Integer(intHandle));
            val = DwgUtil.getHandle(intData, bitPos);
            bitPos = (Integer)val.get(0);
            intHandle = DwgUtil.handleToInt(val);
            this.dwgFile.setHeader("LTYPE_CONTINUOUS", new Integer(intHandle));
        }
        catch (Exception e) {
            logger.trace(e.getMessage());
        }
    }

    private int[] decryptSectionHeader(byte[] encrypted, int offset) {
        int secMask = 0x4164536B ^ offset;
        int[] decrypted = new int[8];
        ByteBuffer Hdr = ByteBuffer.allocate(32);
        Hdr.position(0);
        Hdr.put(encrypted);
        Hdr.order(ByteOrder.LITTLE_ENDIAN);
        Hdr.position(0);
        for (int i = 0; i < 8; ++i) {
            int aux = Hdr.getInt();
            decrypted[i] = aux ^= secMask;
        }
        return decrypted;
    }

    private Section[] findSections(String name) {
        Comparator cmp = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (((Section)arg0).getStartOffset() > ((Section)arg1).getStartOffset()) {
                    return 1;
                }
                return -1;
            }
        };
        TreeSet<Section> foundSections = new TreeSet<Section>(cmp);
        for (int i = 0; i < this.sectionAmount; ++i) {
            if (this.sections[i].getName() != null && this.sections[i].getName().contains(name)) {
                foundSections.add(this.sections[i]);
            }
            if (i != this.sectionAmount) continue;
            logger.trace("No se han encontrado secciones llamadas \"" + name + "\"");
        }
        return foundSections.toArray(new Section[0]);
    }

    private void readDwgR2004Classes(ByteBuffer bb) {
        ByteBuffer decompressedBB = this.readSection(bb, "AcDb:Classes");
        byte[] sentinel = new byte[16];
        decompressedBB.order(ByteOrder.nativeOrder());
        decompressedBB.position(0);
        decompressedBB.get(sentinel);
        if ((sentinel[0] & 0xFF) != 141) {
            logger.trace(" sentinel[0] != 0x8d");
        }
        if ((sentinel[1] & 0xFF) != 161) {
            logger.trace("sentinel[1] != 0xa1");
        }
        if ((sentinel[2] & 0xFF) != 196) {
            logger.trace("sentinel[2] != 0xc4");
        }
        if ((sentinel[3] & 0xFF) != 184) {
            logger.trace("sentinel[3] != 0xb8");
        }
        if ((sentinel[4] & 0xFF) != 196) {
            logger.trace("sentinel[4] != 0xc4");
        }
        if ((sentinel[5] & 0xFF) != 169) {
            logger.trace("sentinel[5] != 0xa9");
        }
        if ((sentinel[6] & 0xFF) != 248) {
            logger.trace("sentinel[6] != 0xf8");
        }
        if ((sentinel[7] & 0xFF) != 197) {
            logger.trace("sentinel[7] != 0xc5");
        }
        if ((sentinel[8] & 0xFF) != 192) {
            logger.trace("sentinel[8] != 0xc0");
        }
        if ((sentinel[9] & 0xFF) != 220) {
            logger.trace("sentinel[9] != 0xdc");
        }
        if ((sentinel[10] & 0xFF) != 244) {
            logger.trace("sentinel[10] != 0xf4");
        }
        if ((sentinel[11] & 0xFF) != 95) {
            logger.trace("sentinel[11] != 0x5f");
        }
        if ((sentinel[12] & 0xFF) != 231) {
            logger.trace("sentinel[12] != 0xe7");
        }
        if ((sentinel[13] & 0xFF) != 207) {
            logger.trace("sentinel[13] != 0xcf");
        }
        if ((sentinel[14] & 0xFF) != 182) {
            logger.trace("sentinel[14] != 0xb6");
        }
        if ((sentinel[15] & 0xFF) != 138) {
            logger.trace("sentinel[15] != 0x8a");
        }
        decompressedBB.order(ByteOrder.LITTLE_ENDIAN);
        int size = decompressedBB.getInt();
        decompressedBB.order(ByteOrder.nativeOrder());
        byte[] data = new byte[size];
        decompressedBB.get(data);
        int[] intData = DwgUtil.toIntArray(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        short crc = decompressedBB.getShort();
        ArrayList val = null;
        int bitPos = 0;
        val = DwgUtil.getBitShort(intData, bitPos);
        bitPos = (Integer)val.get(0);
        int MaxclassNum = (Integer)val.get(1);
        val = DwgUtil.getRawChar(intData, bitPos);
        if ((Integer)val.get(1) != 0) {
            logger.trace("Classes Section RC1 != 0x00");
        }
        bitPos = (Integer)val.get(0);
        val = DwgUtil.getRawChar(intData, bitPos);
        bitPos = (Integer)val.get(0);
        if ((Integer)val.get(1) != 0) {
            logger.trace("Classes Section RC2 != 0x00");
        }
        val = DwgUtil.testBit(intData, bitPos);
        bitPos = (Integer)val.get(0);
        if (!((Boolean)val.get(1)).booleanValue()) {
            logger.trace("Classes Section B != true");
        }
        int maxBit = size * 8;
        while (bitPos + 8 < maxBit) {
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int classNum = (Integer)val.get(1);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int version = (Integer)val.get(1);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            String appName = (String)val.get(1);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            String cPlusPlusName = (String)val.get(1);
            val = DwgUtil.getTextString(intData, bitPos);
            bitPos = (Integer)val.get(0);
            String dxfName = (String)val.get(1);
            val = DwgUtil.testBit(intData, bitPos);
            bitPos = (Integer)val.get(0);
            boolean isZombie = (Boolean)val.get(1);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int id = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int numberObject = (Integer)val.get(1);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int DwgVersion = (Integer)val.get(1);
            val = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int maintenanceVersion = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int unknown1 = (Integer)val.get(1);
            val = DwgUtil.getBitLong(intData, bitPos);
            bitPos = (Integer)val.get(0);
            int unknown2 = (Integer)val.get(1);
            DwgClass2004 dwgClass = new DwgClass2004(classNum, version, appName, cPlusPlusName, dxfName, isZombie, id, numberObject, DwgVersion, maintenanceVersion, unknown1, unknown2);
            this.dwgFile.addDwgClass(dwgClass);
        }
        decompressedBB.order(ByteOrder.nativeOrder());
        byte[] lastSentinnel = new byte[16];
        decompressedBB.get(lastSentinnel);
        if (lastSentinnel[0] != 114) {
            logger.trace("lastSentinnel[0] != 0x72");
        }
        if (lastSentinnel[1] != 94) {
            logger.trace("lastSentinnel[1] != 0x5e");
        }
        if (lastSentinnel[2] != 59) {
            logger.trace("lastSentinnel[2] != 0x3b");
        }
        if (lastSentinnel[3] != 71) {
            logger.trace("lastSentinnel[3] != 0x47");
        }
        if (lastSentinnel[4] != 59) {
            logger.trace("lastSentinnel[4] != 0x3b");
        }
        if (lastSentinnel[5] != 86) {
            logger.trace("lastSentinnel[5] != 0x56");
        }
        if (lastSentinnel[6] != 7) {
            logger.trace("lastSentinnel[6] != 0x07");
        }
        if (lastSentinnel[7] != 58) {
            logger.trace("lastSentinnel[7] != 0x3a");
        }
        if (lastSentinnel[8] != 63) {
            logger.trace("lastSentinnel[8] != 0x3f");
        }
        if (lastSentinnel[9] != 35) {
            logger.trace("lastSentinnel[9] != 0x23");
        }
        if (lastSentinnel[10] != 11) {
            logger.trace("lastSentinnel[10] != 0x0b");
        }
        if ((lastSentinnel[11] & 0xFF) != 160) {
            logger.trace("lastSentinnel[11] != 0xa0");
        }
        if (lastSentinnel[12] != 24) {
            logger.trace("lastSentinnel[12] != 0x18");
        }
        if (lastSentinnel[13] != 48) {
            logger.trace("lastSentinnel[13] != 0x30");
        }
        if (lastSentinnel[14] != 73) {
            logger.trace("lastSentinnel[14] != 0x49");
        }
        if (lastSentinnel[15] != 117) {
            logger.trace("lastSentinnel[15] != 0x75");
        }
    }

    private void readDwgR2004ObjectOffsets(ByteBuffer bb) {
        short size;
        ByteBuffer decompressedBB = this.readSection(bb, "AcDb:Handles");
        decompressedBB.position(0);
        int bitPos = 0;
        do {
            bitPos = 0;
            decompressedBB.order(ByteOrder.BIG_ENDIAN);
            size = decompressedBB.getShort();
            decompressedBB.order(ByteOrder.LITTLE_ENDIAN);
            if (size == 2) break;
            byte[] dataBytes = new byte[size - 2];
            decompressedBB.get(dataBytes);
            int[] data = DwgUtil.bytesToMachineBytes(dataBytes);
            int bitMax = (size - 2) * 8;
            int lastHandle = 0;
            int lastLoc = 0;
            while (bitPos < bitMax) {
                ArrayList v = DwgUtil.getModularChar(data, bitPos);
                bitPos = (Integer)v.get(0);
                int handle = (Integer)v.get(1);
                if (handle < 0) {
                    logger.trace("offset negativo");
                    handle = -handle;
                }
                v = DwgUtil.getModularChar(data, bitPos);
                bitPos = (Integer)v.get(0);
                int loc = (Integer)v.get(1);
                this.dwgFile.addDwgObjectOffset(lastHandle += handle, lastLoc += loc);
            }
            decompressedBB.getShort();
        } while (size != 2);
    }

    protected ByteBuffer readSection(ByteBuffer bb, String name) {
        Section[] foundSections = this.findSections(name);
        ByteBuffer fullSectionDecompressedBB = null;
        ByteBuffer sectionDecompressedData = null;
        int numberOfFoundSections = foundSections.length;
        if (numberOfFoundSections == 0) {
            logger.trace("No se han encontrado secciones llamadas " + name);
        } else {
            int decompressedSize = foundSections[0].getMaxDecompressedSize();
            fullSectionDecompressedBB = ByteBuffer.allocate(decompressedSize * numberOfFoundSections);
            fullSectionDecompressedBB.position(0);
            for (int i = 0; i < numberOfFoundSections; ++i) {
                Section section = foundSections[i];
                int offset = section.getAddress();
                bb.position(offset);
                bb.order(ByteOrder.nativeOrder());
                byte[] encrypted = new byte[32];
                bb.get(encrypted);
                int[] decrypted = this.decryptSectionHeader(encrypted, offset);
                if (decrypted[1] != section.getType()) {
                    logger.trace("Discrepancia en el tipo de seccion: " + section.getType() + " , " + decrypted[1]);
                }
                if (decrypted[2] != section.getDataSize()) {
                    logger.trace("Discrepancia en el tama\u00c3\u00b1o de los datos de la seccion: " + section.getDataSize() + " , " + decrypted[2]);
                }
                if (decrypted[3] != section.getSize()) {
                    logger.trace("Discrepancia en el tama\u00c3\u00b1o de la seccion: " + section.getSize() + " , " + decrypted[3]);
                }
                if (decrypted[4] != section.getStartOffset()) {
                    logger.trace("Discrepancia en el start offset de la seccion: " + section.getStartOffset() + " , " + decrypted[4]);
                }
                decompressedSize = section.getMaxDecompressedSize();
                sectionDecompressedData = this.readCompressedSection(bb, decrypted[2], decompressedSize, 0);
                sectionDecompressedData.position(0);
                section.setDecompressedData(sectionDecompressedData);
                if (fullSectionDecompressedBB.position() != section.getStartOffset()) {
                    logger.trace("Desincronizaci\u00f3n entre el start offset de la seccion y la posici\u00f3n del ByteBuffer compuesto: " + section.getStartOffset() + " , " + fullSectionDecompressedBB.position());
                }
                fullSectionDecompressedBB.put(section.getDecompressedData());
            }
        }
        return fullSectionDecompressedBB;
    }

    protected void readDwgR2004Objects() {
        ByteBuffer decompressedBB = this.readSection(this.bb, "AcDb:AcDbObjects");
        if (decompressedBB != null) {
            decompressedBB.position(0);
            for (int i = 0; i < this.dwgFile.getDwgObjectOffsets().size(); ++i) {
                try {
                    DwgObjectOffset doo = (DwgObjectOffset)this.dwgFile.getDwgObjectOffsets().get(i);
                    DwgObject obj = this.readDwgR2004Object(decompressedBB, doo.getOffset(), i);
                    if (obj == null || obj.getClass() == DwgObject.class) continue;
                    this.dwgFile.addDwgObject(obj);
                    continue;
                }
                catch (Exception e) {
                    logger.trace(e.getMessage());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DwgObject readDwgR2004Object(ByteBuffer bb, int offset, int index) {
        DwgObject obj = null;
        try {
            if (offset >= bb.capacity()) {
                logger.trace("Posible error leyendo un objeto: capacity = " + bb.capacity() + " offset = " + offset);
                return null;
            }
            bb.position(offset);
            int size = DwgUtil.getModularShort(bb);
            if (size == 0 || size > 29696) {
                logger.trace("Posible error leyendo un objeto: size = " + size);
                return null;
            }
            if (offset + size * 8 >= bb.capacity()) {
                logger.trace("Posible error leyendo un objeto: capacity = " + bb.capacity() + " offset = " + offset + " size = " + size);
                return null;
            }
            bb.order(ByteOrder.LITTLE_ENDIAN);
            byte[] data = new byte[size];
            int[] intData = new int[size];
            bb.get(data);
            try {
                intData = DwgUtil.toIntArray(data);
            }
            catch (Exception e) {
                logger.trace("Error leyendo un objeto: size = " + size, (Throwable)e);
                return null;
            }
            int bitPos = 0;
            ArrayList v = DwgUtil.getBitShort(intData, bitPos);
            bitPos = (Integer)v.get(0);
            int type = (Integer)v.get(1);
            obj = DwgObjectFactory.getInstance().create(type, index);
            if (obj == null) {
                logger.trace("dwgFileVR2004Reader: Entrando en Objeto Nulo");
                if (type >= 500) {
                    int newIndex = type - 500;
                    if (newIndex >= this.dwgFile.getDwgClasses().size() - 1) return null;
                    DwgClass2004 dwgClass = (DwgClass2004)this.dwgFile.getDwgClasses().get(newIndex);
                    String dxfEntityName = dwgClass.getDxfName();
                    obj = DwgObjectFactory.getInstance().create(dxfEntityName, index);
                    if (obj == null) {
                        logger.trace(dxfEntityName + " todavia no est\u00e1 implementado");
                        return null;
                    }
                } else {
                    logger.trace("dwgFileVR2004Reader: Encontrado tipo " + type);
                    return null;
                }
            }
            obj.setAddress(offset);
            obj.setVersion(this.dwgFile.getDwgVersion());
            v = DwgUtil.getRawLong(intData, bitPos);
            bitPos = (Integer)v.get(0);
            int objBSize = (Integer)v.get(1);
            obj.setSizeInBits(objBSize);
            DwgHandleReference entityHandle = new DwgHandleReference();
            bitPos = entityHandle.read(intData, bitPos);
            obj.setHandle(entityHandle);
            v = DwgUtil.readExtendedData(intData, bitPos);
            bitPos = (Integer)v.get(0);
            ArrayList extData = (ArrayList)v.get(1);
            obj.setExtendedData(extData);
            boolean gflag = obj.isGraphicsFlag();
            if (gflag) {
                v = DwgUtil.testBit(intData, bitPos);
                bitPos = (Integer)v.get(0);
                boolean val = (Boolean)v.get(1);
                if (val) {
                    v = DwgUtil.getRawLong(intData, bitPos);
                    bitPos = (Integer)v.get(0);
                    size = (Integer)v.get(1);
                    int bgSize = size * 8;
                    Integer giData = (Integer)DwgUtil.getBits(intData, bgSize, bitPos);
                    obj.setGraphicData(giData);
                    bitPos += bgSize;
                }
            }
            if (obj.getClass() == DwgObject.class) return obj;
            this.readSpecificObject2004(obj, intData, bitPos);
            return obj;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
        catch (CorruptedDwgEntityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void readSpecificObject2004(DwgObject obj, int[] data, int bitPos) throws RuntimeException, CorruptedDwgEntityException {
        DwgObjectReaderPool pool = DwgObjectReaderPool.getInstance();
        IDwgObjectReader reader = pool.get(obj, "2004");
        if (reader != null) {
            reader.readSpecificObj(data, bitPos, obj);
        } else {
            logger.trace("No se ha implementado la lectura de " + obj.getClass().getName() + ", code=" + obj.getType());
        }
    }

    protected void readDwgR2004SectionMap(ByteBuffer bb) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.position(this.sectionMapAddress);
        ByteBuffer dData = this.readSystemSection(bb);
        dData.order(ByteOrder.LITTLE_ENDIAN);
        dData.position(0);
        int gapNumber = 0;
        this.sections = new Section[this.sectionAmount + 1];
        this.gaps = new Gap[this.gapAmount];
        this.sections[0] = new Section();
        this.sections[0].setNumber(0);
        this.sections[0].setSize(0);
        this.sections[0].setAddress(256);
        int size = 0;
        int previousSize = 0;
        for (int i = 1; i <= this.sectionAmount; ++i) {
            previousSize = size;
            size = 0;
            this.sections[i] = new Section();
            int sectionNumber = dData.getInt();
            while (sectionNumber < 0) {
                if (gapNumber >= this.gapAmount) {
                    logger.trace("ERROR: Se han encontrado mas gaps de los definidos");
                }
                this.gaps[gapNumber] = new Gap();
                int gapSize = dData.getInt();
                size += gapSize;
                this.gaps[gapNumber].setSize(gapSize);
                this.gaps[gapNumber].setParent(dData.getInt());
                this.gaps[gapNumber].setLeft(dData.getInt());
                this.gaps[gapNumber].setRight(dData.getInt());
                this.gaps[gapNumber].setZero(dData.getInt());
                ++gapNumber;
                sectionNumber = dData.getInt();
            }
            if (sectionNumber == this.sectionInfoId) {
                this.sectionInfoIndex = i;
            }
            this.sections[i].setNumber(sectionNumber);
            int sectionSize = dData.getInt();
            this.sections[i].setSize(sectionSize);
            size += sectionSize;
            if (i == 1) {
                this.sections[i].setAddress(256);
                continue;
            }
            this.sections[i].setAddress(this.sections[i - 1].getAddress() + previousSize);
        }
    }

    protected ByteBuffer readSystemSection(ByteBuffer bb) {
        int sectionType = bb.getInt();
        int decompressedSize = bb.getInt();
        int compressedSize = bb.getInt();
        int compressionType = bb.getInt();
        int checksum = bb.getInt();
        return this.readCompressedSection(bb, compressedSize, decompressedSize, checksum);
    }

    protected ByteBuffer readCompressedSection(ByteBuffer bb, int compressedSize, int decompressedSize, int checksum) {
        long calcSize = 0L;
        ByteBuffer decompressedData = ByteBuffer.allocate(decompressedSize);
        decompressedData.order(ByteOrder.LITTLE_ENDIAN);
        decompressedData.position(0);
        int opcodes = 0;
        byte opcode1 = bb.get();
        byte opcode2 = 0;
        boolean opcode2valid = false;
        int literalLength = 0;
        int lls = 0;
        int compressedBytes = 0;
        int compOffset = 0;
        int litCount = 0;
        try {
            byte b;
            int i;
            if ((opcode1 & 0xFF) >= 0 && (opcode1 & 0xFF) <= 15) {
                literalLength = this.readLiteralLength(bb, opcode1);
                ++lls;
                if (literalLength != 0) {
                    for (i = 0; i < literalLength; ++i) {
                        b = bb.get();
                        decompressedData.put(b);
                    }
                    opcode1 = bb.get();
                }
                calcSize += (long)literalLength;
            } else {
                logger.trace("Error leyendo el literal Length");
            }
            while (opcode1 != 17) {
                int[] twoBytesOffset;
                if ((opcode1 & 0xFF) >= 0 && (opcode1 & 0xFF) <= 15) {
                    logger.trace("Posible error leyendo el opcode " + opcode1);
                    decompressedData.put(opcode1);
                    if (opcode2valid) {
                        opcode1 = opcode2;
                        opcode2valid = false;
                        continue;
                    }
                    opcode1 = bb.get();
                    continue;
                }
                compressedBytes = 0;
                compOffset = 0;
                litCount = 0;
                ++opcodes;
                if ((opcode1 & 0xFF) == 16) {
                    compressedBytes = this.readLongCompressionOffset(bb) + 9;
                    twoBytesOffset = this.readTwoByteOffset(bb);
                    compOffset = twoBytesOffset[0] + 16383;
                    litCount = twoBytesOffset[1];
                    opcode2 = bb.get();
                    opcode2valid = true;
                    if (litCount == 0) {
                        litCount = this.readLiteralLength(bb, opcode2);
                        opcode2valid = false;
                        if (litCount != 0) {
                            opcode2 = bb.get();
                            opcode2valid = true;
                        }
                    }
                } else if ((opcode1 & 0xFF) >= 18 && (opcode1 & 0xFF) <= 23) {
                    compressedBytes = (opcode1 & 0xF) + 2;
                    twoBytesOffset = this.readTwoByteOffset(bb);
                    compOffset = twoBytesOffset[0] + 16383;
                    litCount = twoBytesOffset[1];
                    opcode2 = bb.get();
                    opcode2valid = true;
                    if (litCount == 0) {
                        litCount = this.readLiteralLength(bb, opcode2);
                        opcode2valid = false;
                        if (litCount != 0) {
                            opcode2 = bb.get();
                            opcode2valid = true;
                        }
                    }
                } else if ((opcode1 & 0xFF) == 24) {
                    compressedBytes = this.readLongCompressionOffset(bb) + 9;
                    twoBytesOffset = this.readTwoByteOffset(bb);
                    compOffset = twoBytesOffset[0] + Short.MAX_VALUE;
                    litCount = twoBytesOffset[1];
                    opcode2 = bb.get();
                    opcode2valid = true;
                    if (litCount == 0) {
                        litCount = this.readLiteralLength(bb, opcode2);
                        opcode2valid = false;
                        if (litCount != 0) {
                            opcode2 = bb.get();
                            opcode2valid = true;
                        }
                    }
                } else if ((opcode1 & 0xFF) >= 25 && (opcode1 & 0xFF) <= 31) {
                    compressedBytes = (opcode1 & 0xF) + 2;
                    twoBytesOffset = this.readTwoByteOffset(bb);
                    compOffset = twoBytesOffset[0] + Short.MAX_VALUE;
                    litCount = twoBytesOffset[1];
                    opcode2 = bb.get();
                    opcode2valid = true;
                    if (litCount == 0) {
                        litCount = this.readLiteralLength(bb, opcode2);
                        opcode2valid = false;
                        if (litCount != 0) {
                            opcode2 = bb.get();
                            opcode2valid = true;
                        }
                    }
                } else if ((opcode1 & 0xFF) == 32) {
                    compressedBytes = this.readLongCompressionOffset(bb) + 33;
                    twoBytesOffset = this.readTwoByteOffset(bb);
                    compOffset = twoBytesOffset[0];
                    litCount = twoBytesOffset[1];
                    opcode2 = bb.get();
                    opcode2valid = true;
                    if (litCount == 0) {
                        litCount = this.readLiteralLength(bb, opcode2);
                        opcode2valid = false;
                        if (litCount != 0) {
                            opcode2 = bb.get();
                            opcode2valid = true;
                        }
                    }
                } else if ((opcode1 & 0xFF) >= 33 && (opcode1 & 0xFF) <= 63) {
                    compressedBytes = (opcode1 & 0xFF) - 30;
                    twoBytesOffset = this.readTwoByteOffset(bb);
                    compOffset = twoBytesOffset[0];
                    litCount = twoBytesOffset[1];
                    opcode2 = bb.get();
                    opcode2valid = true;
                    if (litCount == 0) {
                        litCount = this.readLiteralLength(bb, opcode2);
                        opcode2valid = false;
                        if (litCount != 0) {
                            opcode2 = bb.get();
                            opcode2valid = true;
                        }
                    }
                } else if ((opcode1 & 0xFF) >= 64 && (opcode1 & 0xFF) <= 255) {
                    compressedBytes = ((opcode1 & 0xF0) >> 4) - 1;
                    opcode2 = bb.get();
                    opcode2valid = true;
                    compOffset = (opcode2 & 0xFF) << 2 | (opcode1 & 0xC) >> 2;
                    opcode2valid = false;
                    if ((opcode1 & 3) == 0) {
                        litCount = 0;
                        byte opcode3 = bb.get();
                        litCount = this.readLiteralLength(bb, opcode3);
                        opcode2 = litCount == 0 ? opcode3 : bb.get();
                        opcode2valid = true;
                    } else {
                        litCount = opcode1 & 3;
                        opcode2 = bb.get();
                        opcode2valid = true;
                    }
                } else {
                    logger.trace("Posible error de lectura de una seccion comprimida: Ha aparecido un opcode1 con valor " + Integer.toHexString(opcode1 & 0xFF));
                    opcode2 = bb.get();
                    opcode2valid = true;
                }
                if (compressedBytes < 0) {
                    logger.trace("Posible error de lectura de una seccion comprimida: compressedBytes < 0");
                }
                if (compOffset < 0) {
                    logger.trace("Posible error de lectura de una seccion comprimida: compOffset < 0");
                }
                if (litCount < 0) {
                    logger.trace("Posible error de lectura de una seccion comprimida: litCount < 0");
                }
                if (compressedBytes > compOffset) {
                    logger.trace("Posible error en la lectura de una seccion comprimida: No parece logico que compressedBytes > compOffset");
                }
                if (compOffset >= decompressedData.position()) {
                    logger.trace("Posible error en la lectura de una seccion comprimida: el compOffset se sale");
                    compressedBytes = 0;
                }
                for (i = 0; i < compressedBytes; ++i) {
                    b = decompressedData.get(decompressedData.position() - compOffset - 1);
                    decompressedData.put(b);
                }
                for (i = 0; i < litCount; ++i) {
                    decompressedData.put(opcode2);
                    opcode2valid = false;
                    opcode2 = bb.get();
                    opcode2valid = true;
                }
                calcSize = calcSize + (long)compressedBytes + (long)litCount;
                opcode1 = opcode2;
                opcode2valid = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decompressedData;
    }

    private int readLiteralLength(ByteBuffer bb, byte b) {
        int total = 0;
        if (1 <= b && b <= 15) {
            total = (b & 0xFF) + 3;
            return total;
        }
        if (b == 0) {
            total = 15;
            b = bb.get();
            while (b == 0) {
                total += 255;
                b = bb.get();
            }
            return total += (b & 0xFF) + 3;
        }
        if ((b & 0xF0) != 0) {
            return 0;
        }
        logger.trace("Posible error de lectura: Se ha encontrado un Literal Lenght: " + Integer.toHexString(b & 0xFF));
        return total;
    }

    private int[] readTwoByteOffset(ByteBuffer bb) {
        byte firstByte = bb.get();
        int[] values = new int[2];
        int offset = (firstByte & 0xFF) >> 2 | (bb.get() & 0xFF) << 6;
        int litCount = firstByte & 3;
        values[0] = offset;
        values[1] = litCount;
        return values;
    }

    private int readLongCompressionOffset(ByteBuffer bb) {
        int value = 0;
        byte b = bb.get();
        while (b == 0) {
            value += 255;
            b = bb.get();
        }
        return value += b & 0xFF;
    }

    static void setMagicNumber() {
        int size = 108;
        magicNumber = new byte[size];
        int randseed = 1;
        for (int i = 0; i < size; ++i) {
            randseed *= 214013;
            DwgFileVR2004Reader.magicNumber[i] = (byte)((randseed += 2531011) >> 16);
        }
    }

    @Override
    public int readObjectHeader(int[] data, int offset, DwgObject dwgObject) throws RuntimeException, CorruptedDwgEntityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readObjectTailer(int[] data, int offset, DwgObject dwgObject) throws RuntimeException, CorruptedDwgEntityException {
        throw new UnsupportedOperationException();
    }
}

