/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.util;

import java.awt.geom.Point2D;
import java.util.Vector;

public class ArcFromBulgeCalculator {
    private double[] coord1;
    private double[] coord2;
    private double[] center;
    private double radio;
    private double empieza;
    private double acaba;
    private double bulge;
    private double d;
    private double dd;
    private double aci;
    private double[] coordAux;

    public ArcFromBulgeCalculator(double[] p1, double[] p2, double bulge) {
        this.bulge = bulge;
        if (bulge < 0.0) {
            this.coord1 = p2;
            this.coord2 = p1;
        } else {
            this.coord1 = p1;
            this.coord2 = p2;
        }
        this.calParams();
    }

    private void calParams() {
        this.d = Math.sqrt((this.coord2[0] - this.coord1[0]) * (this.coord2[0] - this.coord1[0]) + (this.coord2[1] - this.coord1[1]) * (this.coord2[1] - this.coord1[1]));
        this.coordAux = new double[]{(this.coord1[0] + this.coord2[0]) / 2.0, (this.coord1[1] + this.coord2[1]) / 2.0};
        double b = Math.abs(this.bulge);
        double beta = Math.atan(b);
        double alfa = beta * 4.0;
        double landa = alfa / 2.0;
        this.dd = this.d / 2.0 / Math.tan(landa);
        this.radio = this.d / 2.0 / Math.sin(landa);
        this.aci = Math.atan((this.coord2[0] - this.coord1[0]) / (this.coord2[1] - this.coord1[1]));
        double aciDegree = this.aci * 180.0 / Math.PI;
        if (this.coord2[1] > this.coord1[1]) {
            this.aci += Math.PI;
            aciDegree = this.aci * 180.0 / Math.PI;
        }
        this.center = new double[]{this.coordAux[0] + this.dd * Math.sin(this.aci + 1.5707963267948966), this.coordAux[1] + this.dd * Math.cos(this.aci + 1.5707963267948966)};
        this.calEA(alfa);
    }

    private void calEA(double alfa) {
        this.empieza = Math.atan2(this.coord1[1] - this.center[1], this.coord1[0] - this.center[0]);
        this.acaba = this.empieza + alfa;
        this.empieza = this.empieza * 180.0 / Math.PI;
        this.acaba = this.acaba * 180.0 / Math.PI;
    }

    public Vector getPoints(double inc) {
        Vector arc = new Vector();
        int iempieza = (int)this.empieza + 1;
        int iacaba = (int)this.acaba;
        if (this.empieza <= this.acaba) {
            this.addNode(arc, this.empieza);
            for (double angulo = (double)iempieza; angulo <= (double)iacaba; angulo += inc) {
                this.addNode(arc, angulo);
            }
            this.addNode(arc, this.acaba);
        } else {
            double angulo;
            this.addNode(arc, this.empieza);
            for (angulo = (double)iempieza; angulo <= 360.0; angulo += inc) {
                this.addNode(arc, angulo);
            }
            for (angulo = 1.0; angulo <= (double)iacaba; angulo += inc) {
                this.addNode(arc, angulo);
            }
            this.addNode(arc, angulo);
        }
        Point2D aux = (Point2D)arc.get(arc.size() - 1);
        double aux1 = Math.abs(aux.getX() - this.coord2[0]);
        double aux2 = Math.abs(aux.getY() - this.coord2[1]);
        return arc;
    }

    public Vector getCentralPoint() {
        Vector arc = new Vector();
        if (this.empieza <= this.acaba) {
            this.addNode(arc, (this.empieza + this.acaba) / 2.0);
        } else {
            this.addNode(arc, this.empieza);
            double alfa = 360.0 - this.empieza;
            double beta = this.acaba;
            double an = alfa + beta;
            double mid = an / 2.0;
            if (mid <= alfa) {
                this.addNode(arc, this.empieza + mid);
            } else {
                this.addNode(arc, mid - alfa);
            }
        }
        return arc;
    }

    private void addNode(Vector arc, double angulo) {
        double yy = this.center[1] + this.radio * Math.sin(angulo * Math.PI / 180.0);
        double xx = this.center[0] + this.radio * Math.cos(angulo * Math.PI / 180.0);
        arc.add(new Point2D.Double(xx, yy));
    }
}

