/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.addgeometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class AddGeometryEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter geometryParameter;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;

    public AddGeometryEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "_Select_a_single_record_without_geometry_or_with_empty_geometry", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        int geomType = this.featureStore.getDefaultFeatureTypeQuietly().getDefaultGeometryAttribute().getGeomType().getType();
        this.geometryParameter = new DefaultEditingServiceParameter("Draw geometry", "_Draw_geometry_to_add", geomType, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.GEOMETRY});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.geometryParameter) == null) {
            return this.geometryParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.selectionParameter);
        list.add(this.geometryParameter);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        block14: {
            if (param == this.selectionParameter) {
                if (value instanceof FeatureSelection) {
                    FeatureSelection selection = (FeatureSelection)value;
                    DisposableIterator it = null;
                    try {
                        if (selection.getSelectedCount() == 1L) {
                            try {
                                it = selection.fastIterator();
                                while (it.hasNext()) {
                                    Feature feature = (Feature)it.next();
                                    Geometry geometry = feature.getDefaultGeometry();
                                    if (geometry == null || geometry.isEmpty()) continue;
                                    selection.deselectAll();
                                    throw new InvalidEntryException(null);
                                }
                                this.values.put(this.selectionParameter, selection);
                                break block14;
                            }
                            catch (BaseException e) {
                                throw new InvalidEntryException((Throwable)e);
                            }
                            finally {
                                DisposeUtils.disposeQuietly((Disposable)it);
                            }
                        }
                        selection.deselectAll();
                        throw new InvalidEntryException(null);
                    }
                    catch (DataException ex) {
                        throw new InvalidEntryException((Throwable)ex);
                    }
                }
            } else if (param == this.geometryParameter && value instanceof Geometry) {
                Geometry geometry = (Geometry)value;
                FeatureAttributeDescriptor geomAttr = this.featureStore.getDefaultFeatureTypeQuietly().getDefaultGeometryAttribute();
                if (geometry.isValid() && this.featureStore.allowGeometry(geomAttr.getName(), geometry)) {
                    this.values.put(param, value);
                }
                throw new InvalidEntryException(null);
            }
        }
    }

    public void finishAndStore() throws FinishServiceException {
        FeatureSelection selected = (FeatureSelection)this.values.get(this.selectionParameter);
        Geometry geometry = (Geometry)this.values.get(this.geometryParameter);
        DisposableIterator it = null;
        try {
            if (!selected.isEmpty()) {
                it = selected.fastIterator();
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    EditingProviderServices editingProviderServices = this.getProviderServices();
                    EditableFeature editableFeature = feature.getEditable();
                    editableFeature.setDefaultGeometry(geometry);
                    editingProviderServices.updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                }
                this.featureStore.getFeatureSelection().deselectAll();
            }
        }
        catch (BaseException e) {
            throw new FinishServiceException("Can't finalize " + this.getName(), (Throwable)e);
        }
        finally {
            DisposeUtils.disposeQuietly(it);
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() == 1L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-add-geometry";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

